/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.converters;

import io.atlasmap.converters.DateTimeHelper;
import io.atlasmap.converters.LocalDateConverter;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Date;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class LocalDateConverterTest {
    private LocalDateConverter converter = new LocalDateConverter();

    @Test
    public void toDate() {
        Date date = this.converter.toDate(LocalDate.now());
        Assertions.assertNotNull((Object)date);
    }

    @Test
    public void toZonedDateTime() {
        ZonedDateTime zonedDateTime = this.converter.toZonedDateTime(LocalDate.now());
        Assertions.assertNotNull((Object)zonedDateTime);
        Assertions.assertTrue((boolean)zonedDateTime.getZone().getId().equals(ZoneId.systemDefault().getId()));
    }

    @Test
    public void toZonedDateTimeWithZoneId() {
        ZonedDateTime zonedDateTime = DateTimeHelper.toZonedDateTime(new Date(), "America/New_York");
        Assertions.assertNotNull((Object)zonedDateTime);
        Assertions.assertTrue((boolean)zonedDateTime.getZone().getId().equals("America/New_York"));
    }
}

