/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.converters;

import io.atlasmap.api.AtlasConversionException;
import io.atlasmap.converters.LongConverter;
import io.atlasmap.spi.AtlasConversionConcern;
import io.atlasmap.spi.AtlasConversionInfo;
import io.atlasmap.v2.FieldType;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Date;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class LongConverterTest {
    private LongConverter converter = new LongConverter();

    @Test
    public void convertToBoolean() {
        Long aLong = 0L;
        Long l = 1L;
        Boolean b = this.converter.toBoolean(l);
        Assertions.assertNotNull((Object)b);
        Assertions.assertTrue((boolean)b);
        b = this.converter.toBoolean(aLong);
        Assertions.assertNotNull((Object)b);
        Assertions.assertFalse((boolean)b);
    }

    @Test
    public void convertToBooleanNull() {
        Long l = null;
        Boolean b = this.converter.toBoolean(l);
        Assertions.assertNull((Object)b);
    }

    @Test
    public void convertToBooleanNegative() {
        Long dt = -1L;
        Boolean b = this.converter.toBoolean(dt);
        Assertions.assertTrue((boolean)b);
    }

    @Test
    public void convertToByte() throws Exception {
        Long l = 0L;
        Byte value = 0;
        Assertions.assertEquals((Byte)value, (Byte)this.converter.toByte(l));
    }

    @Test
    public void convertToByteOutOfRange() throws Exception {
        Assertions.assertThrows(AtlasConversionException.class, () -> this.converter.toByte(Long.MAX_VALUE));
    }

    @Test
    public void convertToByteNull() throws Exception {
        Assertions.assertNull((Object)this.converter.toByte(null));
    }

    @Test
    public void convertToCharacter() throws Exception {
        Long l = 0L;
        Character c = this.converter.toCharacter(l);
        Assertions.assertNotNull((Object)c);
        Assertions.assertEquals((int)0, (int)c.charValue());
    }

    @Test
    public void convertToCharacterNull() throws Exception {
        Long l = null;
        Character c = this.converter.toCharacter(l);
        Assertions.assertNull((Object)c);
    }

    @Test
    public void convertToCharacterMAX() throws Exception {
        Assertions.assertThrows(AtlasConversionException.class, () -> {
            Long l = Long.MAX_VALUE;
            this.converter.toCharacter(l);
        });
    }

    @Test
    public void convertToCharacterMIN() throws Exception {
        Assertions.assertThrows(AtlasConversionException.class, () -> {
            Long l = -1L;
            this.converter.toCharacter(l);
        });
    }

    @Test
    public void toDate() throws Exception {
        Date date = this.converter.toDate(Long.MAX_VALUE);
        Assertions.assertNotNull((Object)date);
        date = this.converter.toDate(Long.MIN_VALUE);
        Assertions.assertNotNull((Object)date);
        date = this.converter.toDate(Long.parseLong("0"));
        Assertions.assertTrue((boolean)date.toInstant().toString().equals("1970-01-01T00:00:00Z"));
    }

    @Test
    public void convertToDouble() {
        Long l = 0L;
        Double d = this.converter.toDouble(l);
        Assertions.assertNotNull((Object)d);
        Assertions.assertEquals((double)0.0, (double)d, (double)0.0);
    }

    @Test
    public void convertToDoubleNull() {
        Long l = null;
        Double d = this.converter.toDouble(l);
        Assertions.assertNull((Object)d);
    }

    @Test
    public void convertToDoubleMAX() {
        Long l = Long.MAX_VALUE;
        Double d = this.converter.toDouble(l);
        Assertions.assertNotNull((Object)d);
        Assertions.assertEquals((double)9.223372036854776E18, (double)l.longValue(), (double)0.0);
    }

    @Test
    public void convertToFloat() {
        Long l = 0L;
        Float f = this.converter.toFloat(l);
        Assertions.assertNotNull((Object)f);
        Assertions.assertEquals((double)0.0, (double)f.floatValue(), (double)0.0);
        l = 1L;
        f = this.converter.toFloat(l);
        Assertions.assertNotNull((Object)f);
        Assertions.assertEquals((double)1.0, (double)f.floatValue(), (double)0.0);
    }

    @Test
    public void convertToFloatNull() {
        Assertions.assertNull((Object)this.converter.toFloat(null));
    }

    @Test
    public void convertToFloatMAX() {
        Long l = Long.MAX_VALUE;
        Float f = this.converter.toFloat(l);
        Assertions.assertNotNull((Object)f);
        Assertions.assertEquals((double)9.223372036854776E18, (double)l.longValue(), (double)0.0);
    }

    @Test
    public void convertToInteger() throws Exception {
        Long l = 0L;
        Integer i = this.converter.toInteger(l);
        Assertions.assertNotNull((Object)i);
        Assertions.assertEquals((double)0.0, (double)i.intValue(), (double)0.0);
    }

    @Test
    public void convertToIntegerMAX() throws Exception {
        Assertions.assertThrows(AtlasConversionException.class, () -> this.converter.toInteger(Long.MAX_VALUE));
    }

    @Test
    public void convertToIntegerMIN() throws Exception {
        Assertions.assertThrows(AtlasConversionException.class, () -> this.converter.toInteger(Long.MIN_VALUE));
    }

    @Test
    public void convertToIntegerNull() throws Exception {
        Long l = null;
        Integer i = this.converter.toInteger(l);
        Assertions.assertNull((Object)i);
    }

    @Test
    public void convertToLong() {
        Long l = 1L;
        Long d = this.converter.toLong(l);
        Assertions.assertNotNull((Object)d);
        Assertions.assertNotSame((Object)l, (Object)d);
        Assertions.assertEquals((double)1.0, (double)d.longValue(), (double)0.0);
    }

    @Test
    public void convertToLongNull() {
        Long l = null;
        Long d = this.converter.toLong(l);
        Assertions.assertNull((Object)d);
    }

    @Test
    public void convertToShort() throws Exception {
        Long l = 0L;
        Short s = this.converter.toShort(l);
        Assertions.assertNotNull((Object)s);
        Assertions.assertEquals((double)0.0, (double)s.shortValue(), (double)0.0);
    }

    @Test
    public void convertToShortNull() throws Exception {
        Long l = null;
        Short s = this.converter.toShort(l);
        Assertions.assertNull((Object)s);
    }

    @Test
    public void convertToShortExceptionMAX() throws Exception {
        Assertions.assertThrows(AtlasConversionException.class, () -> {
            Long l = Long.MAX_VALUE;
            this.converter.toShort(l);
        });
    }

    @Test
    public void convertToString() {
        Long l = 0L;
        String s = this.converter.toString(l);
        Assertions.assertNotNull((Object)s);
        Assertions.assertTrue((boolean)"0".equals(s));
    }

    @Test
    public void convertToStringNull() {
        Long l = null;
        String s = this.converter.toString(l);
        Assertions.assertNull((Object)s);
    }

    @Test
    public void checkAnnotations() throws Exception {
        Method[] methods;
        Class<LongConverter> aClass = LongConverter.class;
        for (Method method : methods = aClass.getMethods()) {
            if (method.isSynthetic() || !method.getName().startsWith("convert")) continue;
            Annotation[] annotations = method.getDeclaredAnnotations();
            Assertions.assertNotNull((Object)annotations);
            Assertions.assertTrue((annotations.length > 0 ? 1 : 0) != 0);
            for (Annotation annotation2 : annotations) {
                Assertions.assertTrue((boolean)AtlasConversionInfo.class.isAssignableFrom(annotation2.annotationType()));
                AtlasConversionInfo atlasConversionInfo = (AtlasConversionInfo)annotation2;
                Assertions.assertNotNull((Object)((Object)atlasConversionInfo.sourceType()));
                Assertions.assertTrue((atlasConversionInfo.sourceType().compareTo(FieldType.LONG) == 0 ? 1 : 0) != 0);
                Assertions.assertNotNull((Object)((Object)atlasConversionInfo.targetType()));
                for (AtlasConversionConcern atlasConversionConcern : atlasConversionInfo.concerns()) {
                    Assertions.assertNotNull((Object)atlasConversionConcern.getMessage(atlasConversionInfo));
                    Assertions.assertNotNull((Object)atlasConversionConcern.value());
                }
            }
        }
    }
}

