/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.converters;

import io.atlasmap.api.AtlasConversionException;
import io.atlasmap.converters.ShortConverter;
import io.atlasmap.spi.AtlasConversionConcern;
import io.atlasmap.spi.AtlasConversionInfo;
import io.atlasmap.v2.FieldType;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ShortConverterTest {
    private ShortConverter converter = new ShortConverter();

    @Test
    public void convertToBoolean() {
        Short f = 0;
        Short t = 1;
        Boolean b = this.converter.toBoolean(t);
        Assertions.assertNotNull((Object)b);
        Assertions.assertTrue((boolean)b);
        b = this.converter.toBoolean(f);
        Assertions.assertNotNull((Object)b);
        Assertions.assertFalse((boolean)b);
    }

    @Test
    public void convertToBooleanNull() {
        Short l = null;
        Boolean b = this.converter.toBoolean(l);
        Assertions.assertNull((Object)b);
    }

    @Test
    public void convertToBooleanNegative() {
        Short dt = -1;
        Boolean b = this.converter.toBoolean(dt);
        Assertions.assertTrue((boolean)b);
    }

    @Test
    public void convertToByte() throws Exception {
        Short l = 0;
        Byte value = 0;
        Assertions.assertEquals((Byte)value, (Byte)this.converter.toByte(l));
    }

    @Test
    public void convertToByteOutOfRange() throws Exception {
        Assertions.assertThrows(AtlasConversionException.class, () -> this.converter.toByte((short)Short.MAX_VALUE));
    }

    @Test
    public void convertToByteNull() throws Exception {
        Assertions.assertNull((Object)this.converter.toByte(null));
    }

    @Test
    public void convertToCharacter() throws Exception {
        Short shorty = 4;
        Character character = this.converter.toCharacter(shorty);
        Assertions.assertNotNull((Object)character);
        Assertions.assertEquals((Character)Character.valueOf((char)shorty.shortValue()), (Character)character);
    }

    @Test
    public void convertToCharacterNull() throws Exception {
        Short s = null;
        Character c = this.converter.toCharacter(s);
        Assertions.assertNull((Object)c);
    }

    @Test
    public void convertToCharacterMAX() throws Exception {
        Short s = Short.MAX_VALUE;
        Character c = this.converter.toCharacter(s);
        Assertions.assertNotNull((Object)c);
        Assertions.assertEquals((Character)Character.valueOf((char)s.shortValue()), (Character)c);
    }

    @Test
    public void convertToCharacterMIN() throws Exception {
        Assertions.assertThrows(AtlasConversionException.class, () -> {
            Short s = Short.MIN_VALUE;
            this.converter.toCharacter(s);
        });
    }

    @Test
    public void convertToDouble() {
        Short s = 0;
        Double d = this.converter.toDouble(s);
        Assertions.assertNotNull((Object)d);
        Assertions.assertEquals((double)0.0, (double)d, (double)0.0);
    }

    @Test
    public void convertToDoubleNull() {
        Short s = null;
        Double d = this.converter.toDouble(s);
        Assertions.assertNull((Object)d);
    }

    @Test
    public void convertToDoubleMAX() {
        Short s = Short.MAX_VALUE;
        Double d = this.converter.toDouble(s);
        Assertions.assertNotNull((Object)d);
        Assertions.assertEquals((double)32767.0, (double)s.shortValue(), (double)0.0);
    }

    @Test
    public void convertToFloat() {
        Short s = 0;
        Float f = this.converter.toFloat(s);
        Assertions.assertNotNull((Object)f);
        Assertions.assertEquals((double)0.0, (double)f.floatValue(), (double)0.0);
    }

    @Test
    public void convertToFloatNull() {
        Assertions.assertNull((Object)this.converter.toFloat(null));
    }

    @Test
    public void convertToFloatMAX() {
        Short s = Short.MAX_VALUE;
        Float f = this.converter.toFloat(s);
        Assertions.assertNotNull((Object)f);
        Assertions.assertEquals((double)32767.0, (double)s.shortValue(), (double)0.0);
    }

    @Test
    public void convertToInteger() {
        Short s = 0;
        Integer i = this.converter.toInteger(s);
        Assertions.assertNotNull((Object)i);
        Assertions.assertEquals((double)0.0, (double)i.intValue(), (double)0.0);
    }

    @Test
    public void convertToIntegerNull() {
        Short l = null;
        Integer i = this.converter.toInteger(l);
        Assertions.assertNull((Object)i);
    }

    @Test
    public void convertToLong() {
        Short s = 1;
        Long l = this.converter.toLong(s);
        Assertions.assertNotNull((Object)l);
        Assertions.assertEquals((double)1.0, (double)l.longValue(), (double)0.0);
    }

    @Test
    public void convertToLongNull() {
        Short s = null;
        Long l = this.converter.toLong(s);
        Assertions.assertNull((Object)l);
    }

    @Test
    public void convertToLongMAX() {
        Short s = Short.MAX_VALUE;
        Long l = this.converter.toLong(s);
        Assertions.assertNotNull((Object)l);
        Assertions.assertEquals((double)32767.0, (double)l.longValue(), (double)0.0);
    }

    @Test
    public void convertToLongMIN() {
        Short s = Short.MIN_VALUE;
        Long l = this.converter.toLong(s);
        Assertions.assertNotNull((Object)l);
        Assertions.assertEquals((double)-32768.0, (double)l.longValue(), (double)0.0);
    }

    @Test
    public void convertToShort() {
        Short aShort = 0;
        Short s = this.converter.toShort(aShort);
        Assertions.assertNotNull((Object)s);
        Assertions.assertNotSame((Object)aShort, (Object)s);
        Assertions.assertEquals((double)0.0, (double)s.shortValue(), (double)0.0);
    }

    @Test
    public void convertToShortNull() {
        Short l = null;
        Short s = this.converter.toShort(l);
        Assertions.assertNull((Object)s);
    }

    @Test
    public void convertToString() {
        Short l = 0;
        String s = this.converter.toString(l);
        Assertions.assertNotNull((Object)s);
        Assertions.assertTrue((boolean)"0".equals(s));
    }

    @Test
    public void convertToStringNull() {
        Short l = null;
        String s = this.converter.toString(l);
        Assertions.assertNull((Object)s);
    }

    @Test
    public void checkAnnotations() throws Exception {
        Method[] methods;
        Class<ShortConverter> aClass = ShortConverter.class;
        for (Method method : methods = aClass.getMethods()) {
            if (method.isSynthetic() || !method.getName().startsWith("convert")) continue;
            Annotation[] annotations = method.getDeclaredAnnotations();
            Assertions.assertNotNull((Object)annotations);
            Assertions.assertTrue((annotations.length > 0 ? 1 : 0) != 0);
            for (Annotation annotation2 : annotations) {
                Assertions.assertTrue((boolean)AtlasConversionInfo.class.isAssignableFrom(annotation2.annotationType()));
                AtlasConversionInfo atlasConversionInfo = (AtlasConversionInfo)annotation2;
                Assertions.assertNotNull((Object)((Object)atlasConversionInfo.sourceType()));
                Assertions.assertTrue((atlasConversionInfo.sourceType().compareTo(FieldType.SHORT) == 0 ? 1 : 0) != 0);
                Assertions.assertNotNull((Object)((Object)atlasConversionInfo.targetType()));
                for (AtlasConversionConcern atlasConversionConcern : atlasConversionInfo.concerns()) {
                    Assertions.assertNotNull((Object)atlasConversionConcern.getMessage(atlasConversionInfo));
                    Assertions.assertNotNull((Object)atlasConversionConcern.value());
                }
            }
        }
    }

    @Test
    public void testCharacterDigit() {
        int intTen = 10;
        char ch = Character.valueOf(Short.MAX_VALUE).charValue();
        Character.digit(ch, intTen);
    }
}

