/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.core;

import io.atlasmap.core.ADMArchiveHandler;
import io.atlasmap.core.AtlasUtil;
import io.atlasmap.v2.AtlasMapping;
import io.atlasmap.v2.Json;
import java.io.ByteArrayInputStream;
import java.io.FileOutputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ADMArchiveHandlerTest {
    @Test
    public void testExportLoadEmpty() throws Exception {
        ADMArchiveHandler handler = new ADMArchiveHandler();
        handler.export(new FileOutputStream("target/test.adm"));
        handler = new ADMArchiveHandler();
        handler.load(Paths.get("target/test.adm", new String[0]));
        Assertions.assertNull((Object)handler.getMappingDefinition());
        Assertions.assertNull((Object)handler.getMappingDefinitionBytes());
    }

    @Test
    public void testFileName() throws Exception {
        ADMArchiveHandler handler = new ADMArchiveHandler();
        handler.setMappingDefinitionId("2");
        Assertions.assertEquals((Object)"atlasmapping-UI.2.json", (Object)handler.getMappingDefinitionFileName());
        Assertions.assertEquals((Object)"adm-catalog-files-2.gz", (Object)handler.getGzippedADMDigestFileName());
    }

    @Test
    public void testExportLoadPersist() throws Exception {
        ADMArchiveHandler handler = new ADMArchiveHandler();
        AtlasMapping mapping = new AtlasMapping();
        mapping.setName("foo");
        byte[] mappingBytes = Json.mapper().writeValueAsBytes(mapping);
        handler.setMappingDefinitionBytes(new ByteArrayInputStream(mappingBytes));
        Assertions.assertNotNull((Object)handler.getMappingDefinition());
        Assertions.assertEquals((Object)"foo", (Object)handler.getMappingDefinition().getName());
        byte[] digestBytes = "dummy".getBytes();
        handler.setGzippedADMDigest(new ByteArrayInputStream(digestBytes));
        Assertions.assertNotNull((Object)handler.getGzippedADMDigestBytes());
        handler.export(new FileOutputStream("target/test2.adm"));
        handler = new ADMArchiveHandler();
        handler.load(Paths.get("target/test2.adm", new String[0]));
        Assertions.assertNotNull((Object)handler.getMappingDefinition());
        Assertions.assertEquals((Object)"foo", (Object)handler.getMappingDefinition().getName());
        Assertions.assertNotNull((Object)handler.getGzippedADMDigestBytes());
        Path persistPath = Paths.get("target/test2", new String[0]);
        AtlasUtil.deleteDirectory(persistPath.toFile());
        persistPath.toFile().mkdirs();
        handler.setPersistDirectory(persistPath);
        handler.persist();
        Assertions.assertTrue((boolean)persistPath.resolve(handler.getMappingDefinitionFileName()).toFile().exists());
        Assertions.assertTrue((boolean)persistPath.resolve(handler.getGzippedADMDigestFileName()).toFile().exists());
    }

    @Test
    public void testPersistIgnoreInvalidBytes() throws Exception {
        ADMArchiveHandler handler = new ADMArchiveHandler();
        byte[] mappingBytes = "no data".getBytes();
        handler.setMappingDefinitionBytes(new ByteArrayInputStream(mappingBytes));
        Path persistPath = Paths.get("target/test3", new String[0]);
        AtlasUtil.deleteDirectory(persistPath.toFile());
        persistPath.toFile().mkdirs();
        handler.setPersistDirectory(persistPath);
        handler.persist();
        Assertions.assertFalse((boolean)persistPath.resolve(handler.getMappingDefinitionFileName()).toFile().exists());
        handler.setMappingDefinitionBytes(new ByteArrayInputStream(mappingBytes));
        Assertions.assertNull((Object)handler.getMappingDefinition());
    }
}

