/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.core;

import io.atlasmap.core.AtlasUtil;
import io.atlasmap.v2.ValidationStatus;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class AtlasUtilTest {
    @Test
    public void testIsEmpty() {
        Assertions.assertTrue((boolean)AtlasUtil.isEmpty(null));
        Assertions.assertTrue((boolean)AtlasUtil.isEmpty(""));
        Assertions.assertTrue((boolean)AtlasUtil.isEmpty("     "));
        Assertions.assertTrue((boolean)AtlasUtil.isEmpty("\n\n"));
        Assertions.assertTrue((boolean)AtlasUtil.isEmpty("\t\t"));
        Assertions.assertTrue((boolean)AtlasUtil.isEmpty("\r\n"));
        Assertions.assertTrue((boolean)AtlasUtil.isEmpty("\f\t\n\r"));
        Assertions.assertFalse((boolean)AtlasUtil.isEmpty("\b"));
    }

    @Test
    public void testAtlasUri() {
        Map<String, String> params;
        String uriJavaNover = "atlas:java";
        String uriJavaNoverWParm = "atlas:java?foo=bar";
        String uriJavaNoverWParms = "atlas:java?foo=bar&bar=blah";
        String uriJavaVer1 = "atlas:java::1";
        String uriJavaVer2 = "atlas:java::2";
        String uriJavaVer2WParm = "atlas:java::2?foo=bar";
        String uriJavaVer2WParams = "atlas:java::2?foo=bar&bar=blah";
        List<String> javaUris = Arrays.asList(uriJavaNover, uriJavaNoverWParm, uriJavaNoverWParms, uriJavaVer1, uriJavaVer2, uriJavaVer2WParm, uriJavaVer2WParams);
        List<String> noverUris = Arrays.asList(uriJavaNover, uriJavaNoverWParm, uriJavaNoverWParms);
        List<String> javaVer1Uris = Arrays.asList(uriJavaVer1);
        List<String> javaVer2Uris = Arrays.asList(uriJavaVer2, uriJavaVer2WParm, uriJavaVer2WParams);
        List<String> parmUris = Arrays.asList(uriJavaNoverWParm, uriJavaVer2WParm);
        List<String> parmsUris = Arrays.asList(uriJavaNoverWParms, uriJavaVer2WParams);
        for (String uri : javaUris) {
            Assertions.assertEquals((Object)"atlas", (Object)AtlasUtil.getUriScheme(uri));
        }
        for (String uri : javaUris) {
            Assertions.assertEquals((Object)"java", (Object)AtlasUtil.getUriModule(uri));
        }
        for (String uri : javaUris) {
            Assertions.assertNull((Object)AtlasUtil.getUriDataType(uri));
        }
        for (String uri : noverUris) {
            Assertions.assertNull((Object)AtlasUtil.getUriModuleVersion(uri));
        }
        for (String uri : javaVer1Uris) {
            Assertions.assertEquals((Object)"1", (Object)AtlasUtil.getUriModuleVersion(uri));
        }
        for (String uri : javaVer2Uris) {
            Assertions.assertEquals((Object)"2", (Object)AtlasUtil.getUriModuleVersion(uri));
        }
        for (String uri : parmUris) {
            params = AtlasUtil.getUriParameters(uri);
            Assertions.assertNotNull(params);
            Assertions.assertEquals((Integer)1, (Integer)params.size());
            Assertions.assertEquals((Object)"bar", (Object)params.get("foo"));
            Assertions.assertNull((Object)params.get("bar"));
        }
        for (String uri : parmsUris) {
            params = AtlasUtil.getUriParameters(uri);
            Assertions.assertNotNull(params);
            Assertions.assertEquals((Integer)2, (Integer)params.size());
            Assertions.assertEquals((Object)"bar", (Object)params.get("foo"));
            Assertions.assertEquals((Object)"blah", (Object)params.get("bar"));
            Assertions.assertNull((Object)params.get("blah"));
        }
    }

    @Test
    public void testFindClassesForPackage() {
        List<Class<?>> classes = AtlasUtil.findClassesForPackage("io.atlasmap.v2");
        Assertions.assertNotNull(classes);
        Assertions.assertTrue((boolean)classes.stream().map(Class::getName).collect(Collectors.toList()).containsAll(Arrays.asList("io.atlasmap.v2.Field", "io.atlasmap.v2.AtlasMapping", "io.atlasmap.v2.Action", "io.atlasmap.v2.Capitalize")));
    }

    @Test
    public void testGetUriDataType() {
        Assertions.assertEquals((Object)"util", (Object)AtlasUtil.getUriDataType("atlas:java:util?param1=value1&param2=value2"));
    }

    @Test
    public void testFindClassesForPackageIllegalArgumentException() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> AtlasUtil.findClassesForPackage("io.atlasmapv2"));
    }

    @Test
    public void testFind() {
        File file = Paths.get("src" + File.separator + "main" + File.separator + "java" + File.separator + "io" + File.separator + "atlasmap" + File.separator + "core", new String[0]).toFile();
        Assertions.assertEquals((int)0, (int)AtlasUtil.find(file, ".").size());
    }

    @Test
    public void testLoadPropertiesFromURL() throws Exception {
        URL url = Paths.get("src" + File.separator + "test" + File.separator + "resources" + File.separator + "AtlasUtilTest.properties", new String[0]).toUri().toURL();
        Properties properties = AtlasUtil.loadPropertiesFromURL(url);
        Assertions.assertNotNull((Object)properties);
        Assertions.assertEquals((Object)"value1", (Object)properties.get("key1"));
        Assertions.assertEquals((Object)"value2", (Object)properties.get("key2"));
    }

    @Test
    public void testLoadPropertiesFromURLNullPointerException() throws Exception {
        Assertions.assertThrows(NullPointerException.class, () -> AtlasUtil.loadPropertiesFromURL(null));
    }

    @Test
    public void testLoadPropertiesFromURLMalformedURLException() throws Exception {
        Assertions.assertThrows(MalformedURLException.class, () -> AtlasUtil.loadPropertiesFromURL(new URL("invalid URL")));
    }

    @Test
    public void testMatchUriModule() {
        Assertions.assertFalse((boolean)AtlasUtil.matchUriModule(null, null));
        Assertions.assertFalse((boolean)AtlasUtil.matchUriModule(null, "atlas:java"));
        Assertions.assertFalse((boolean)AtlasUtil.matchUriModule("atlas:java", null));
        Assertions.assertFalse((boolean)AtlasUtil.matchUriModule("", ""));
        Assertions.assertFalse((boolean)AtlasUtil.matchUriModule("atlas:java", ""));
        Assertions.assertFalse((boolean)AtlasUtil.matchUriModule("", "atlas:java"));
        Assertions.assertTrue((boolean)AtlasUtil.matchUriModule("atlas:java", "atlas:java"));
    }

    @Test
    public void testValidateUriIllegalStateException() {
        Assertions.assertThrows(IllegalStateException.class, () -> AtlasUtil.validateUri("java:atlas"));
    }

    @Test
    public void testValidateUriIllegalStateExceptionMultipleQuestionMark() {
        Assertions.assertThrows(IllegalStateException.class, () -> AtlasUtil.validateUri("atlas:?java?"));
    }

    @Test
    public void testValidateUriSingleQuestionMark() {
        AtlasUtil.validateUri("atlas:java?");
    }

    @Test
    public void testValidateUri() {
        AtlasUtil.validateUri("atlas:java");
    }

    @Test
    public void testGetUriPartsAsArray() {
        Assertions.assertNull(AtlasUtil.getUriPartsAsArray(null));
        Assertions.assertEquals((int)2, (int)AtlasUtil.getUriPartsAsArray("atlas:?java").size());
        Assertions.assertEquals((int)2, (int)AtlasUtil.getUriPartsAsArray("atlas:?").size());
        Assertions.assertEquals((int)2, (int)AtlasUtil.getUriPartsAsArray("atlas:").size());
    }

    @Test
    public void testGetUriScheme() {
        Assertions.assertNull((Object)AtlasUtil.getUriScheme(null));
    }

    @Test
    public void testGetUriParameters() {
        Assertions.assertNull(AtlasUtil.getUriParameters(null));
        Assertions.assertEquals((int)0, (int)AtlasUtil.getUriParameters("").size());
        Assertions.assertEquals((int)0, (int)AtlasUtil.getUriParameters("atlas:").size());
        Assertions.assertEquals((int)0, (int)AtlasUtil.getUriParameters("atlas:?").size());
        Assertions.assertEquals((int)2, (int)AtlasUtil.getUriParameters("atlas:?param1=value1&param2=value2").size());
        Assertions.assertEquals((int)1, (int)AtlasUtil.getUriParameters("atlas:?param1=value1&param2=").size());
        Assertions.assertEquals((int)1, (int)AtlasUtil.getUriParameters("atlas:?param1=&param2=value2").size());
        Assertions.assertEquals((int)1, (int)AtlasUtil.getUriParameters("atlas:?=&param2=value2").size());
        Assertions.assertEquals((int)0, (int)AtlasUtil.getUriParameters("atlas:?=").size());
        Assertions.assertEquals((int)0, (int)AtlasUtil.getUriParameters("atlas:?&").size());
        Assertions.assertEquals((int)0, (int)AtlasUtil.getUriParameters("atlas:?p").size());
    }

    @Test
    public void testGetUriParametersIllegalArgumentException() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> AtlasUtil.getUriParameters("atlas:?%%XX"));
    }

    @Test
    public void testGetUriParameterValue() {
        Assertions.assertNull((Object)AtlasUtil.getUriParameterValue("atlas:?java", "java"));
        Assertions.assertEquals((Object)"value1", (Object)AtlasUtil.getUriParameterValue("atlas:?param1=value1&param2=value2", "param1"));
        Assertions.assertEquals((Object)"value1", (Object)AtlasUtil.getUriParameterValue("atlas:?param1=value1&param2=", "param1"));
        Assertions.assertEquals((Object)"value2", (Object)AtlasUtil.getUriParameterValue("atlas:?param1=&param2=value2", "param2"));
        Assertions.assertNull((Object)AtlasUtil.getUriParameterValue("atlas:?", "java"));
        Assertions.assertNull((Object)AtlasUtil.getUriParameterValue("atlas:?param", "java"));
        Assertions.assertNull((Object)AtlasUtil.getUriParameterValue("atlas:?&", "java"));
        Assertions.assertNull((Object)AtlasUtil.getUriParameterValue("atlas:?=", "java"));
        Assertions.assertNull((Object)AtlasUtil.getUriParameterValue("atlas:? ", "java"));
    }

    @Test
    public void testFindClassesFromJar() throws Exception {
        URL jarFile = new File("target" + File.separator + "test-dependencies" + File.separator + "atlas-model.jar").toURI().toURL();
        String urlString = "jar:file:" + jarFile.getPath() + "!/";
        Assertions.assertFalse((boolean)AtlasUtil.findClassesFromJar(new URL(urlString)).isEmpty());
    }

    @Test
    public void testFindClassesFromJarFileNotFoundIOException() throws Exception {
        String urlString = "jar:file:" + File.separator + "target" + File.separator + "test-dependencies" + File.separator + "atlas-model.jar!/";
        Assertions.assertEquals((int)0, (int)AtlasUtil.findClassesFromJar(new URL(urlString)).size());
    }

    @Test
    public void testFindClassesFromJarClassCastException() throws Exception {
        Assertions.assertThrows(ClassCastException.class, () -> {
            URL url = Paths.get("target" + File.separator + "test-dependencies" + File.separator + "atlas-model.jar", new String[0]).toUri().toURL();
            AtlasUtil.findClassesFromJar(url);
        });
    }

    @Test
    public void testToAuditStatus() {
        Assertions.assertNotNull((Object)((Object)AtlasUtil.toAuditStatus(ValidationStatus.ERROR)));
        Assertions.assertNotNull((Object)((Object)AtlasUtil.toAuditStatus(ValidationStatus.WARN)));
        Assertions.assertNotNull((Object)((Object)AtlasUtil.toAuditStatus(ValidationStatus.INFO)));
        Assertions.assertNotNull((Object)((Object)AtlasUtil.toAuditStatus(ValidationStatus.ALL)));
        Assertions.assertNotNull((Object)((Object)AtlasUtil.toAuditStatus(ValidationStatus.NONE)));
    }
}

