/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.core;

import io.atlasmap.api.AtlasException;
import io.atlasmap.core.AtlasPath;
import io.atlasmap.core.DefaultAtlasFieldActionService;
import io.atlasmap.spi.AtlasCollectionHelper;
import io.atlasmap.spi.AtlasFieldActionService;
import io.atlasmap.v2.Action;
import io.atlasmap.v2.ActionDetail;
import io.atlasmap.v2.CollectionType;
import io.atlasmap.v2.Field;
import io.atlasmap.v2.FieldGroup;
import io.atlasmap.v2.Multiplicity;
import java.util.List;

public class DefaultAtlasCollectionHelper
implements AtlasCollectionHelper {
    private AtlasFieldActionService fieldActionService;

    public DefaultAtlasCollectionHelper() {
        this.fieldActionService = DefaultAtlasFieldActionService.getInstance();
    }

    public DefaultAtlasCollectionHelper(AtlasFieldActionService fieldActionService) {
        this.fieldActionService = fieldActionService;
    }

    protected AtlasPath createTargetAtlasPath(String path) {
        return new AtlasPath(path);
    }

    @Override
    public int determineTargetCollectionCount(Field targetField) {
        AtlasPath targetPath = this.createTargetAtlasPath(targetField.getPath());
        int targetCollectionCount = targetPath.getCollectionSegmentCount();
        if (targetField.getIndex() != null) {
            ++targetCollectionCount;
        }
        return targetCollectionCount;
    }

    @Override
    public int determineSourceCollectionCount(Field sourceParentField, Field sourceField) {
        AtlasPath sourcePath = new AtlasPath(sourceField.getPath());
        int sourceCollectionCount = sourcePath.getCollectionSegmentCount();
        sourceCollectionCount += this.getCollectionCountAdjustmentForActions(sourceParentField);
        sourceCollectionCount += this.getCollectionCountAdjustmentForActions(sourceField);
        if (sourceField.getIndex() != null) {
            --sourceCollectionCount;
        }
        return sourceCollectionCount;
    }

    private int getCollectionCountAdjustmentForActions(Field sourceField) {
        int sourceCollectionCount = 0;
        if (sourceField != null && sourceField.getActions() != null) {
            for (Action action : sourceField.getActions()) {
                ActionDetail actionDetail = null;
                try {
                    actionDetail = this.fieldActionService.findActionDetail(action, sourceField.getFieldType());
                }
                catch (AtlasException e) {
                    throw new RuntimeException(e);
                }
                if (actionDetail == null) continue;
                if (Multiplicity.ONE_TO_MANY.equals((Object)actionDetail.getMultiplicity())) {
                    ++sourceCollectionCount;
                    continue;
                }
                if (!Multiplicity.MANY_TO_ONE.equals((Object)actionDetail.getMultiplicity())) continue;
                --sourceCollectionCount;
            }
        }
        return sourceCollectionCount;
    }

    @Override
    public void copyCollectionIndexes(Field sourceParentField, Field sourceField, Field targetField, Field previousTargetField) {
        AtlasPath sourcePath = new AtlasPath(sourceField.getPath());
        AtlasPath targetPath = this.createTargetAtlasPath(targetField.getPath());
        int targetCollectionCount = this.determineTargetCollectionCount(targetField);
        int sourceCollectionCount = this.determineSourceCollectionCount(sourceParentField, sourceField);
        int targetIndex = 0;
        int collectionCount = 0;
        List<AtlasPath.SegmentContext> targetSegments = targetPath.getSegments(true);
        if (targetCollectionCount > sourceCollectionCount) {
            while (collectionCount < targetCollectionCount - sourceCollectionCount) {
                AtlasPath.SegmentContext targetSegment = targetSegments.get(targetIndex);
                if (targetSegment.getCollectionType() != CollectionType.NONE) {
                    targetPath.setCollectionIndex(targetIndex, 0);
                    ++collectionCount;
                }
                ++targetIndex;
            }
        }
        AtlasPath previousTargetPath = previousTargetField != null ? this.createTargetAtlasPath(previousTargetField.getPath()) : null;
        List<AtlasPath.SegmentContext> sourceCollectionSegments = sourcePath.getCollectionSegments(true);
        AtlasPath.SegmentContext lastSourceSegment = sourcePath.getLastSegment();
        AtlasPath.SegmentContext lastTargetCollectionSegment = targetPath.getLastCollectionSegment();
        block1: for (AtlasPath.SegmentContext sourceSegment : sourcePath.getSegments(true)) {
            if (sourceSegment.getCollectionType() == CollectionType.NONE && sourceSegment != lastSourceSegment) continue;
            while (targetSegments.size() > targetIndex) {
                AtlasPath.SegmentContext targetSegment = targetSegments.get(targetIndex);
                if (targetSegment.getCollectionType() != CollectionType.NONE) {
                    int nextCollectionIndex;
                    ++collectionCount;
                    if (sourceSegment.getCollectionIndex() != null) {
                        if (sourceCollectionCount > targetCollectionCount && targetCollectionCount == collectionCount) {
                            nextCollectionIndex = this.determineNextCollectionIndex(previousTargetPath, sourceCollectionSegments);
                            targetPath.setCollectionIndex(targetIndex, nextCollectionIndex);
                        } else {
                            targetPath.setCollectionIndex(targetIndex, sourceSegment.getCollectionIndex());
                        }
                        ++targetIndex;
                        continue block1;
                    }
                    if (targetSegment == lastTargetCollectionSegment && sourceParentField instanceof FieldGroup) {
                        nextCollectionIndex = this.determineNextCollectionIndex(previousTargetPath, sourceCollectionSegments);
                        targetPath.setCollectionIndex(targetIndex, nextCollectionIndex);
                        ++targetIndex;
                        continue block1;
                    }
                }
                ++targetIndex;
            }
        }
        targetField.setPath(targetPath.toString());
    }

    private int determineNextCollectionIndex(AtlasPath previousTargetPath, List<AtlasPath.SegmentContext> sourceCollectionSegments) {
        int nextCollectionIndex = 0;
        if (previousTargetPath != null) {
            List<AtlasPath.SegmentContext> previousTargetCollectionSegments = previousTargetPath.getCollectionSegments(true);
            boolean parentIndexesChanged = false;
            for (int i = previousTargetCollectionSegments.size() - 2; i >= 0; --i) {
                if (previousTargetCollectionSegments.get(i).getCollectionIndex().equals(sourceCollectionSegments.get(i).getCollectionIndex())) continue;
                parentIndexesChanged = true;
                break;
            }
            if (!parentIndexesChanged) {
                nextCollectionIndex = previousTargetCollectionSegments.get(previousTargetCollectionSegments.size() - 1).getCollectionIndex();
                ++nextCollectionIndex;
            }
        }
        return nextCollectionIndex;
    }
}

