/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.core;

import io.atlasmap.core.DefaultAtlasSeparateStrategy;
import io.atlasmap.spi.AtlasSeparateStrategy;
import io.atlasmap.spi.StringDelimiter;
import java.util.List;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class DefaultAtlasSeparateStrategyTest {
    private AtlasSeparateStrategy separate = null;

    @BeforeEach
    public void setUp() {
        this.separate = new DefaultAtlasSeparateStrategy();
    }

    @AfterEach
    public void tearDown() {
        this.separate = null;
    }

    @Test
    public void testGetName() {
        Assertions.assertNotNull((Object)this.separate);
        Assertions.assertEquals((Object)"DefaultAtlasSeparateStrategy", (Object)this.separate.getName());
    }

    @Test
    public void testGetSetDelimiter() {
        Assertions.assertNotNull((Object)this.separate);
        Assertions.assertNotNull((Object)((Object)this.separate.getDelimiter()));
        Assertions.assertEquals((Object)((Object)DefaultAtlasSeparateStrategy.DEFAULT_SEPARATE_DELIMITER), (Object)((Object)this.separate.getDelimiter()));
        this.separate.setDelimiter(StringDelimiter.COLON);
        Assertions.assertEquals((Object)((Object)StringDelimiter.COLON), (Object)((Object)this.separate.getDelimiter()));
        List<String> values = this.separate.separateValue("a:b:c:d");
        Assertions.assertNotNull(values);
        Assertions.assertEquals((Integer)4, (Integer)values.size());
        Assertions.assertEquals((Object)"a", (Object)values.get(0));
        Assertions.assertEquals((Object)"b", (Object)values.get(1));
        Assertions.assertEquals((Object)"c", (Object)values.get(2));
        Assertions.assertEquals((Object)"d", (Object)values.get(3));
    }

    @Test
    public void testGetSetLimit() {
        Assertions.assertNotNull((Object)this.separate);
        Assertions.assertNotNull((Object)((Object)this.separate.getDelimiter()));
        Assertions.assertEquals((Integer)DefaultAtlasSeparateStrategy.DEFAULT_SEPARATE_LIMIT, (Integer)this.separate.getLimit());
        this.separate.setLimit(2);
        List<String> values = this.separate.separateValue("a b c d");
        Assertions.assertNotNull(values);
        Assertions.assertEquals((Integer)2, (Integer)values.size());
        Assertions.assertEquals((Object)"a", (Object)values.get(0));
        Assertions.assertEquals((Object)"b c d", (Object)values.get(1));
    }

    @Test
    public void testSeparateValue() {
        Assertions.assertNotNull((Object)this.separate);
        List<String> values = this.separate.separateValue("a b c d e f");
        Assertions.assertNotNull(values);
        Assertions.assertEquals((Integer)6, (Integer)values.size());
        Assertions.assertEquals((Object)"a", (Object)values.get(0));
        Assertions.assertEquals((Object)"b", (Object)values.get(1));
        Assertions.assertEquals((Object)"c", (Object)values.get(2));
        Assertions.assertEquals((Object)"d", (Object)values.get(3));
        Assertions.assertEquals((Object)"e", (Object)values.get(4));
        Assertions.assertEquals((Object)"f", (Object)values.get(5));
    }

    @Test
    public void testSeparateValueNullDelimiter() {
        Assertions.assertNotNull((Object)this.separate);
        this.separate.setDelimiter(null);
        Assertions.assertNull((Object)((Object)this.separate.getDelimiter()));
        List<String> values = this.separate.separateValue("a b c d e f");
        Assertions.assertNotNull(values);
        Assertions.assertEquals((Integer)6, (Integer)values.size());
        Assertions.assertEquals((Object)"a", (Object)values.get(0));
        Assertions.assertEquals((Object)"b", (Object)values.get(1));
        Assertions.assertEquals((Object)"c", (Object)values.get(2));
        Assertions.assertEquals((Object)"d", (Object)values.get(3));
        Assertions.assertEquals((Object)"e", (Object)values.get(4));
        Assertions.assertEquals((Object)"f", (Object)values.get(5));
    }

    @Test
    public void testSeparateValueNullLimit() {
        Assertions.assertNotNull((Object)this.separate);
        this.separate.setLimit(null);
        Assertions.assertNull((Object)this.separate.getLimit());
        List<String> values = this.separate.separateValue("a b c d e f");
        Assertions.assertNotNull(values);
        Assertions.assertEquals((Integer)6, (Integer)values.size());
        Assertions.assertEquals((Object)"a", (Object)values.get(0));
        Assertions.assertEquals((Object)"b", (Object)values.get(1));
        Assertions.assertEquals((Object)"c", (Object)values.get(2));
        Assertions.assertEquals((Object)"d", (Object)values.get(3));
        Assertions.assertEquals((Object)"e", (Object)values.get(4));
        Assertions.assertEquals((Object)"f", (Object)values.get(5));
    }

    @Test
    public void testSeparateValueNullValue() {
        Assertions.assertNotNull((Object)this.separate);
        List<String> values = this.separate.separateValue(null);
        Assertions.assertNotNull(values);
        Assertions.assertTrue((boolean)values.isEmpty());
    }

    @Test
    public void testSeparateValueEmptyValue() {
        Assertions.assertNotNull((Object)this.separate);
        List<String> values = this.separate.separateValue("");
        Assertions.assertNotNull(values);
        Assertions.assertTrue((boolean)values.isEmpty());
    }
}

