/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.core;

import io.atlasmap.spi.StringDelimiter;
import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class StringDelimiterTest {
    @Test
    public void testGetNameRegexValue() {
        Assertions.assertEquals((Object)"Ampersand", (Object)StringDelimiter.AMPERSAND.getName());
        Assertions.assertEquals((Object)"&", (Object)StringDelimiter.AMPERSAND.getRegex());
        Assertions.assertEquals((Object)"&", (Object)StringDelimiter.AMPERSAND.getValue());
        Assertions.assertEquals((Object)"AtSign", (Object)StringDelimiter.AT_SIGN.getName());
        Assertions.assertEquals((Object)"@", (Object)StringDelimiter.AT_SIGN.getRegex());
        Assertions.assertEquals((Object)"@", (Object)StringDelimiter.AT_SIGN.getValue());
        Assertions.assertEquals((Object)"Backslash", (Object)StringDelimiter.BACKSLASH.getName());
        Assertions.assertEquals((Object)"\\\\", (Object)StringDelimiter.BACKSLASH.getRegex());
        Assertions.assertEquals((Object)"\\", (Object)StringDelimiter.BACKSLASH.getValue());
        Assertions.assertEquals((Object)"Colon", (Object)StringDelimiter.COLON.getName());
        Assertions.assertEquals((Object)":", (Object)StringDelimiter.COLON.getRegex());
        Assertions.assertEquals((Object)":", (Object)StringDelimiter.COLON.getValue());
        Assertions.assertEquals((Object)"Comma", (Object)StringDelimiter.COMMA.getName());
        Assertions.assertEquals((Object)",", (Object)StringDelimiter.COMMA.getRegex());
        Assertions.assertEquals((Object)",", (Object)StringDelimiter.COMMA.getValue());
        Assertions.assertEquals((Object)"Dash", (Object)StringDelimiter.DASH.getName());
        Assertions.assertEquals((Object)"-", (Object)StringDelimiter.DASH.getRegex());
        Assertions.assertEquals((Object)"-", (Object)StringDelimiter.DASH.getValue());
        Assertions.assertEquals((Object)"Equal", (Object)StringDelimiter.EQUAL.getName());
        Assertions.assertEquals((Object)"=", (Object)StringDelimiter.EQUAL.getRegex());
        Assertions.assertEquals((Object)"=", (Object)StringDelimiter.EQUAL.getValue());
        Assertions.assertEquals((Object)"Hash", (Object)StringDelimiter.HASH.getName());
        Assertions.assertEquals((Object)"#", (Object)StringDelimiter.HASH.getRegex());
        Assertions.assertEquals((Object)"#", (Object)StringDelimiter.HASH.getValue());
        Assertions.assertEquals((Object)"MultiSpace", (Object)StringDelimiter.MULTI_SPACE.getName());
        Assertions.assertEquals((Object)"\\s+", (Object)StringDelimiter.MULTI_SPACE.getRegex());
        Assertions.assertEquals((Object)"    ", (Object)StringDelimiter.MULTI_SPACE.getValue());
        Assertions.assertEquals((Object)"Period", (Object)StringDelimiter.PERIOD.getName());
        Assertions.assertEquals((Object)"\\.", (Object)StringDelimiter.PERIOD.getRegex());
        Assertions.assertEquals((Object)".", (Object)StringDelimiter.PERIOD.getValue());
        Assertions.assertEquals((Object)"Pipe", (Object)StringDelimiter.PIPE.getName());
        Assertions.assertEquals((Object)"\\|", (Object)StringDelimiter.PIPE.getRegex());
        Assertions.assertEquals((Object)"|", (Object)StringDelimiter.PIPE.getValue());
        Assertions.assertEquals((Object)"Semicolon", (Object)StringDelimiter.SEMICOLON.getName());
        Assertions.assertEquals((Object)";", (Object)StringDelimiter.SEMICOLON.getRegex());
        Assertions.assertEquals((Object)";", (Object)StringDelimiter.SEMICOLON.getValue());
        Assertions.assertEquals((Object)"Slash", (Object)StringDelimiter.SLASH.getName());
        Assertions.assertEquals((Object)"/", (Object)StringDelimiter.SLASH.getRegex());
        Assertions.assertEquals((Object)"/", (Object)StringDelimiter.SLASH.getValue());
        Assertions.assertEquals((Object)"Space", (Object)StringDelimiter.SPACE.getName());
        Assertions.assertEquals((Object)"\\s", (Object)StringDelimiter.SPACE.getRegex());
        Assertions.assertEquals((Object)" ", (Object)StringDelimiter.SPACE.getValue());
        Assertions.assertEquals((Object)"Underscore", (Object)StringDelimiter.UNDERSCORE.getName());
        Assertions.assertEquals((Object)"_", (Object)StringDelimiter.UNDERSCORE.getRegex());
        Assertions.assertEquals((Object)"_", (Object)StringDelimiter.UNDERSCORE.getValue());
    }

    @Test
    public void testFromName() {
        Assertions.assertEquals((Object)((Object)StringDelimiter.AMPERSAND), (Object)((Object)StringDelimiter.fromName("Ampersand")));
        Assertions.assertEquals((Object)((Object)StringDelimiter.AT_SIGN), (Object)((Object)StringDelimiter.fromName("AtSign")));
        Assertions.assertEquals((Object)((Object)StringDelimiter.BACKSLASH), (Object)((Object)StringDelimiter.fromName("Backslash")));
        Assertions.assertEquals((Object)((Object)StringDelimiter.COLON), (Object)((Object)StringDelimiter.fromName("Colon")));
        Assertions.assertEquals((Object)((Object)StringDelimiter.COMMA), (Object)((Object)StringDelimiter.fromName("Comma")));
        Assertions.assertEquals((Object)((Object)StringDelimiter.DASH), (Object)((Object)StringDelimiter.fromName("Dash")));
        Assertions.assertEquals((Object)((Object)StringDelimiter.EQUAL), (Object)((Object)StringDelimiter.fromName("Equal")));
        Assertions.assertEquals((Object)((Object)StringDelimiter.HASH), (Object)((Object)StringDelimiter.fromName("Hash")));
        Assertions.assertEquals((Object)((Object)StringDelimiter.MULTI_SPACE), (Object)((Object)StringDelimiter.fromName("MultiSpace")));
        Assertions.assertEquals((Object)((Object)StringDelimiter.PERIOD), (Object)((Object)StringDelimiter.fromName("Period")));
        Assertions.assertEquals((Object)((Object)StringDelimiter.PIPE), (Object)((Object)StringDelimiter.fromName("Pipe")));
        Assertions.assertEquals((Object)((Object)StringDelimiter.SEMICOLON), (Object)((Object)StringDelimiter.fromName("Semicolon")));
        Assertions.assertEquals((Object)((Object)StringDelimiter.SLASH), (Object)((Object)StringDelimiter.fromName("Slash")));
        Assertions.assertEquals((Object)((Object)StringDelimiter.SPACE), (Object)((Object)StringDelimiter.fromName("Space")));
        Assertions.assertEquals((Object)((Object)StringDelimiter.UNDERSCORE), (Object)((Object)StringDelimiter.fromName("Underscore")));
    }

    @Test
    public void testGetAllRegexes() {
        List<String> values = StringDelimiter.getAllRegexes();
        Assertions.assertNotNull(values);
        Assertions.assertEquals((Integer)new Integer(15), (Integer)new Integer(values.size()));
    }

    @Test
    public void testGetAllNames() {
        List<String> names = StringDelimiter.getAllNames();
        Assertions.assertNotNull(names);
        Assertions.assertEquals((Integer)new Integer(15), (Integer)new Integer(names.size()));
    }
}

