/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.core.validate;

import io.atlasmap.api.AtlasException;
import io.atlasmap.core.validate.BaseModuleValidationService;
import io.atlasmap.spi.AtlasConversionConcern;
import io.atlasmap.spi.AtlasConversionInfo;
import io.atlasmap.spi.AtlasConverter;
import io.atlasmap.v2.Action;
import io.atlasmap.v2.ActionDetail;
import io.atlasmap.v2.Field;
import io.atlasmap.v2.FieldGroup;
import io.atlasmap.v2.FieldType;
import io.atlasmap.v2.Validation;
import io.atlasmap.v2.ValidationScope;
import io.atlasmap.v2.ValidationStatus;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MappingFieldPairValidator {
    private static final Logger LOG = LoggerFactory.getLogger(MappingFieldPairValidator.class);
    private BaseModuleValidationService<?> service;

    public MappingFieldPairValidator(BaseModuleValidationService<?> service) {
        this.service = service;
    }

    public void validateFieldTypes(List<Validation> validations, String mappingId, FieldGroup sourceFieldGroup, Field targetField) {
        FieldType actionOutputType = this.getActionOutputFieldType(validations, mappingId, sourceFieldGroup);
        for (Field sourceField : sourceFieldGroup.getField()) {
            if (!this.service.matchDocIdOrNull(sourceField.getDocId())) {
                return;
            }
            this.doValidateFieldTypes(validations, mappingId, sourceField, targetField, actionOutputType != null ? actionOutputType : sourceField.getFieldType());
        }
    }

    public void validateFieldTypes(List<Validation> validations, String mappingId, List<Field> sourceFields, Field targetField) {
        for (Field sourceField : sourceFields) {
            if (!this.service.matchDocIdOrNull(sourceField.getDocId())) {
                return;
            }
            FieldType actionOutputType = this.getActionOutputFieldType(validations, mappingId, sourceField);
            this.doValidateFieldTypes(validations, mappingId, sourceField, targetField, actionOutputType != null ? actionOutputType : sourceField.getFieldType());
        }
    }

    public void validateFieldTypes(List<Validation> validations, String mappingId, Field sourceField, List<Field> targetFields) {
        if (!this.service.matchDocIdOrNull(sourceField.getDocId())) {
            return;
        }
        FieldType actionOutputType = this.getActionOutputFieldType(validations, mappingId, sourceField);
        for (Field targetField : targetFields) {
            this.doValidateFieldTypes(validations, mappingId, sourceField, targetField, actionOutputType != null ? actionOutputType : sourceField.getFieldType());
        }
    }

    public void validateFieldTypes(List<Validation> validations, String mappingId, Field sourceField, Field targetField) {
        FieldType actionOutputType = this.getActionOutputFieldType(validations, mappingId, sourceField);
        this.doValidateFieldTypes(validations, mappingId, sourceField, targetField, actionOutputType != null ? actionOutputType : sourceField.getFieldType());
    }

    protected void doValidateFieldTypes(List<Validation> validations, String mappingId, Field sourceField, Field targetField, FieldType sourceFieldType) {
        if (sourceField == null && targetField == null || sourceField.getFieldType() == targetField.getFieldType()) {
            return;
        }
        FieldType targetFieldType = targetField.getFieldType();
        if (sourceFieldType == null || targetFieldType == null) {
            return;
        }
        if (sourceFieldType == FieldType.ANY || targetFieldType == FieldType.ANY) {
            return;
        }
        if (sourceField.getFieldType() == FieldType.COMPLEX) {
            return;
        }
        Optional<AtlasConverter<?>> atlasConverter = this.service.getConversionService().findMatchingConverter(sourceFieldType, targetFieldType);
        if (!atlasConverter.isPresent()) {
            Validation validation = new Validation();
            validation.setScope(ValidationScope.MAPPING);
            validation.setId(mappingId);
            validation.setMessage(String.format("Conversion from '%s' to '%s' is required but no converter is available", new Object[]{sourceField.getFieldType(), targetField.getFieldType()}));
            validation.setStatus(ValidationStatus.ERROR);
            validations.add(validation);
        } else {
            FieldType sft = sourceFieldType;
            Method[] methods = atlasConverter.get().getClass().getMethods();
            AtlasConversionInfo conversionInfo = Arrays.stream(methods).map(method -> method.getAnnotation(AtlasConversionInfo.class)).filter(atlasConversionInfo -> atlasConversionInfo != null).filter(atlasConversionInfo -> atlasConversionInfo.sourceType().compareTo(sft) == 0 && atlasConversionInfo.targetType().compareTo(targetFieldType) == 0).findFirst().orElse(null);
            if (conversionInfo != null) {
                this.populateConversionConcerns(validations, mappingId, conversionInfo, this.service.getFieldName(sourceField), this.service.getFieldName(targetField));
            }
        }
    }

    private FieldType getActionOutputFieldType(List<Validation> validations, String mappingId, Field f) {
        ActionDetail detail;
        Action lastAction;
        block4: {
            if (f.getActions() == null || f.getActions().size() == 0) {
                return null;
            }
            lastAction = f.getActions().get(f.getActions().size() - 1);
            detail = null;
            try {
                detail = this.service.getFieldActionService().findActionDetail(lastAction, f.getFieldType());
            }
            catch (AtlasException e) {
                if (!LOG.isDebugEnabled()) break block4;
                LOG.error("ActionDetail not found", (Throwable)e);
            }
        }
        if (detail == null) {
            Validation validation = new Validation();
            validation.setScope(ValidationScope.MAPPING);
            validation.setId(mappingId);
            validation.setMessage(String.format("Couldn't find a metadata for transformation '%s'", lastAction.getDisplayName()));
            validation.setStatus(ValidationStatus.ERROR);
            validations.add(validation);
            return null;
        }
        return detail.getTargetType();
    }

    public void populateConversionConcerns(List<Validation> validations, String mappingId, AtlasConversionInfo converterAnno, String sourceFieldName, String targetFieldName) {
        if (converterAnno == null || converterAnno.concerns() == null) {
            return;
        }
        for (AtlasConversionConcern atlasConversionConcern : converterAnno.concerns()) {
            Validation validation;
            String message = atlasConversionConcern.getMessage(converterAnno);
            if (AtlasConversionConcern.NONE.equals((Object)atlasConversionConcern)) continue;
            if (atlasConversionConcern.equals((Object)AtlasConversionConcern.RANGE) || atlasConversionConcern.equals((Object)AtlasConversionConcern.FORMAT) || atlasConversionConcern.equals((Object)AtlasConversionConcern.FRACTIONAL_PART) || atlasConversionConcern.equals((Object)AtlasConversionConcern.TIMEZONE)) {
                validation = new Validation();
                validation.setScope(ValidationScope.MAPPING);
                validation.setId(mappingId);
                validation.setMessage(message);
                validation.setStatus(ValidationStatus.WARN);
                validations.add(validation);
                continue;
            }
            if (!atlasConversionConcern.equals((Object)AtlasConversionConcern.UNSUPPORTED)) continue;
            validation = new Validation();
            validation.setScope(ValidationScope.MAPPING);
            validation.setId(mappingId);
            validation.setMessage(message);
            validation.setStatus(ValidationStatus.ERROR);
            validations.add(validation);
        }
    }
}

