/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.core.validate;

import io.atlasmap.core.AtlasPath;
import io.atlasmap.core.validate.BaseModuleValidationService;
import io.atlasmap.spi.FieldDirection;
import io.atlasmap.v2.Field;
import io.atlasmap.v2.Validation;
import io.atlasmap.v2.ValidationScope;
import io.atlasmap.v2.ValidationStatus;
import java.util.List;

public class MultipleFieldSelectionValidator {
    private BaseModuleValidationService<?> service;

    public MultipleFieldSelectionValidator(BaseModuleValidationService<?> service) {
        this.service = service;
    }

    public void validate(List<Validation> validations, String mappingId, FieldDirection direction, List<Field> fields) {
        if (fields.size() <= 1) {
            return;
        }
        for (Field f : fields) {
            AtlasPath path;
            if (!this.service.matchDocIdOrNull(f.getDocId()) || !(path = new AtlasPath(f.getPath())).hasCollection()) continue;
            Validation validation = new Validation();
            validation.setScope(ValidationScope.MAPPING);
            validation.setId(mappingId);
            validation.setMessage(String.format("A %s field contained in a collection can not be selected with other %s field: ['%s']", direction.value(), direction.value(), f.getPath()));
            validation.setStatus(ValidationStatus.ERROR);
            validations.add(validation);
        }
    }
}

