/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.expression.internal;

import io.atlasmap.expression.ExpressionContext;
import io.atlasmap.expression.ExpressionException;
import io.atlasmap.expression.internal.BinaryExpression;
import io.atlasmap.expression.internal.BooleanExpression;
import io.atlasmap.v2.AtlasModelFactory;
import io.atlasmap.v2.Field;

public abstract class LogicExpression
extends BinaryExpression
implements BooleanExpression {
    public LogicExpression(BooleanExpression left, BooleanExpression right) {
        super(left, right);
    }

    public static BooleanExpression createOR(BooleanExpression lvalue, BooleanExpression rvalue) {
        return new LogicExpression(lvalue, rvalue){

            @Override
            public Field evaluate(ExpressionContext expressionContext) throws ExpressionException {
                Boolean lv = (Boolean)this.left.evaluate(expressionContext).getValue();
                if (lv != null && lv.booleanValue()) {
                    return AtlasModelFactory.wrapWithField(Boolean.TRUE);
                }
                Boolean rv = (Boolean)this.right.evaluate(expressionContext).getValue();
                return AtlasModelFactory.wrapWithField(rv == null ? null : rv);
            }

            @Override
            public String getExpressionSymbol() {
                return "||";
            }
        };
    }

    public static BooleanExpression createAND(BooleanExpression lvalue, BooleanExpression rvalue) {
        return new LogicExpression(lvalue, rvalue){

            @Override
            public Field evaluate(ExpressionContext expressionContext) throws ExpressionException {
                Boolean lv = (Boolean)this.left.evaluate(expressionContext).getValue();
                if (lv == null) {
                    return null;
                }
                if (!lv.booleanValue()) {
                    return AtlasModelFactory.wrapWithField(Boolean.FALSE);
                }
                Boolean rv = (Boolean)this.right.evaluate(expressionContext).getValue();
                return AtlasModelFactory.wrapWithField(rv == null ? null : rv);
            }

            @Override
            public String getExpressionSymbol() {
                return "&&";
            }
        };
    }

    @Override
    public abstract Field evaluate(ExpressionContext var1) throws ExpressionException;

    @Override
    public boolean matches(ExpressionContext message) throws ExpressionException {
        Object object = this.evaluate(message).getValue();
        return object != null && object == Boolean.TRUE;
    }
}

