/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.json.module;

import io.atlasmap.core.validate.BaseModuleValidationService;
import io.atlasmap.json.module.JsonModule;
import io.atlasmap.json.v2.JsonField;
import io.atlasmap.spi.AtlasConversionService;
import io.atlasmap.spi.AtlasFieldActionService;
import io.atlasmap.spi.AtlasModuleDetail;
import io.atlasmap.spi.AtlasValidator;
import io.atlasmap.spi.FieldDirection;
import io.atlasmap.v2.Validation;
import io.atlasmap.v2.ValidationScope;
import io.atlasmap.v2.ValidationStatus;
import io.atlasmap.validators.NonNullValidator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class JsonValidationService
extends BaseModuleValidationService<JsonField> {
    private static Map<String, AtlasValidator> validatorMap = new HashMap<String, AtlasValidator>();
    private AtlasModuleDetail moduleDetail = JsonModule.class.getAnnotation(AtlasModuleDetail.class);

    public JsonValidationService(AtlasConversionService conversionService, AtlasFieldActionService fieldActionService) {
        super(conversionService, fieldActionService);
        this.init();
    }

    public void init() {
        NonNullValidator javaFilePathNonNullValidator = new NonNullValidator(ValidationScope.MAPPING, "The path element must not be null nor empty");
        NonNullValidator inputFieldTypeNonNullValidator = new NonNullValidator(ValidationScope.MAPPING, "Field type should not be null nor empty");
        NonNullValidator outputFieldTypeNonNullValidator = new NonNullValidator(ValidationScope.MAPPING, "Field type should not be null nor empty");
        NonNullValidator fieldTypeNonNullValidator = new NonNullValidator(ValidationScope.MAPPING, "Filed type should not be null nor empty");
        validatorMap.put("json.field.type.not.null", fieldTypeNonNullValidator);
        validatorMap.put("json.field.path.not.null", javaFilePathNonNullValidator);
        validatorMap.put("input.field.type.not.null", inputFieldTypeNonNullValidator);
        validatorMap.put("output.field.type.not.null", outputFieldTypeNonNullValidator);
    }

    public void destroy() {
        validatorMap.clear();
    }

    @Override
    protected AtlasModuleDetail getModuleDetail() {
        return this.moduleDetail;
    }

    @Override
    protected Class<JsonField> getFieldType() {
        return JsonField.class;
    }

    @Override
    protected String getModuleFieldName(JsonField field) {
        return field.getName() != null ? field.getName() : field.getPath();
    }

    @Override
    protected void validateModuleField(String mappingId, JsonField field, FieldDirection direction, List<Validation> validations) {
        validatorMap.get("json.field.type.not.null").validate(field, validations, mappingId, ValidationStatus.WARN);
        if (field.getPath() == null) {
            validatorMap.get("json.field.path.not.null").validate(field.getPath(), validations, mappingId);
        }
    }
}

