/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.v2;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonRootName;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import com.fasterxml.jackson.module.jsonSchema.JsonSchema;
import com.fasterxml.jackson.module.jsonSchema.JsonSchemaGenerator;
import com.fasterxml.jackson.module.jsonSchema.types.ObjectSchema;
import io.atlasmap.v2.Action;
import io.atlasmap.v2.ActionParameters;
import io.atlasmap.v2.ActionResolver;
import io.atlasmap.v2.AtlasSchemaFactoryWrapper;
import io.atlasmap.v2.FieldType;
import io.atlasmap.v2.Multiplicity;
import java.io.Serializable;

@JsonRootName(value="ActionDetail")
public class ActionDetail
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected ActionParameters parameters;
    protected String name;
    protected Boolean custom;
    protected String className;
    protected String method;
    protected FieldType sourceType;
    protected FieldType targetType;
    protected Multiplicity multiplicity;
    protected ObjectSchema actionSchema;

    public ActionParameters getParameters() {
        return this.parameters;
    }

    public void setParameters(ActionParameters value) {
        this.parameters = value;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String value) {
        this.name = value;
    }

    public Boolean isCustom() {
        return this.custom;
    }

    public void setCustom(Boolean value) {
        this.custom = value;
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String value) {
        this.className = value;
    }

    public String getMethod() {
        return this.method;
    }

    public void setMethod(String value) {
        this.method = value;
    }

    public FieldType getSourceType() {
        return this.sourceType;
    }

    public void setSourceType(FieldType value) {
        this.sourceType = value;
    }

    public FieldType getTargetType() {
        return this.targetType;
    }

    public void setTargetType(FieldType value) {
        this.targetType = value;
    }

    public Multiplicity getMultiplicity() {
        return this.multiplicity;
    }

    public void setMultiplicity(Multiplicity value) {
        this.multiplicity = value;
    }

    public JsonSchema getActionSchema() {
        return this.actionSchema;
    }

    public void setActionSchema(ObjectSchema actionSchema) {
        this.actionSchema = actionSchema;
    }

    @JsonProperty(value="actionSchema")
    public void setActionSchema(Class<? extends Action> clazz) throws JsonMappingException {
        if (clazz == null) {
            this.setActionSchema((ObjectSchema)null);
            return;
        }
        this.setClassName(clazz.getName());
        ObjectMapper mapper = new ObjectMapper().enable(MapperFeature.BLOCK_UNSAFE_POLYMORPHIC_BASE_TYPES);
        JsonSchemaGenerator schemaGen = new JsonSchemaGenerator(mapper);
        AtlasSchemaFactoryWrapper visitor = new AtlasSchemaFactoryWrapper();
        mapper.acceptJsonFormatVisitor(clazz, (JsonFormatVisitorWrapper)visitor);
        JsonSchema schema = visitor.finalSchema();
        ObjectSchema objectSchema = schema.asObjectSchema();
        String id = ActionResolver.getInstance().toId(clazz);
        objectSchema.setId(id);
        AtlasSchemaFactoryWrapper.ExtendedJsonSchema keyField = (AtlasSchemaFactoryWrapper.ExtendedJsonSchema)((Object)objectSchema.getProperties().get("@type"));
        keyField.getMetadata().put("const", id);
        this.setActionSchema(objectSchema);
    }
}

