/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.v2;

import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.atlasmap.v2.Action;
import io.atlasmap.v2.AtlasMapping;
import io.atlasmap.v2.BaseMapping;
import io.atlasmap.v2.Collection;
import io.atlasmap.v2.CollectionType;
import io.atlasmap.v2.Field;
import io.atlasmap.v2.FieldGroup;
import io.atlasmap.v2.FieldStatus;
import io.atlasmap.v2.FieldType;
import io.atlasmap.v2.Fields;
import io.atlasmap.v2.LookupTables;
import io.atlasmap.v2.Mapping;
import io.atlasmap.v2.MappingType;
import io.atlasmap.v2.Mappings;
import io.atlasmap.v2.MockDocument;
import io.atlasmap.v2.MockField;
import io.atlasmap.v2.Properties;
import io.atlasmap.v2.PropertyField;
import io.atlasmap.v2.SimpleField;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;

public class AtlasModelFactory {
    public static final String GENERATED_PATH = "$ATLASMAP";

    private AtlasModelFactory() {
    }

    public static <T extends BaseMapping> T createMapping() {
        return AtlasModelFactory.createMapping(MappingType.MAP);
    }

    public static <T extends BaseMapping> T createMapping(MappingType type) {
        BaseMapping fm = null;
        if (type == null) {
            return null;
        }
        switch (type) {
            case COLLECTION: {
                fm = new Collection();
                fm.setMappingType(type);
                return (T)fm;
            }
            case COMBINE: 
            case LOOKUP: 
            case MAP: 
            case SEPARATE: {
                fm = new Mapping();
                ((Mapping)fm).setMappingType(type);
                return (T)fm;
            }
        }
        throw new IllegalStateException(String.format("Unsupported mappingType=%s", type.value()));
    }

    public static AtlasMapping createAtlasMapping() {
        AtlasMapping mapping = new AtlasMapping();
        mapping.setMappings(new Mappings());
        mapping.setProperties(new Properties());
        mapping.setLookupTables(new LookupTables());
        return mapping;
    }

    public static Collection createCollection() {
        Collection collectionMapping = new Collection();
        collectionMapping.setMappings(new Mappings());
        collectionMapping.setMappingType(MappingType.COLLECTION);
        return collectionMapping;
    }

    public static MockDocument createMockDocument() {
        MockDocument mockDocument = new MockDocument();
        mockDocument.setFields(new Fields());
        return mockDocument;
    }

    public static MockField createMockField() {
        return new MockField();
    }

    public static PropertyField createPropertyField() {
        return new PropertyField();
    }

    public static BaseMapping cloneMapping(BaseMapping baseMapping, boolean deepClone) {
        if (baseMapping.getMappingType().equals((Object)MappingType.COLLECTION)) {
            Collection mapping = (Collection)baseMapping;
            Collection clone = new Collection();
            clone.setAlias(mapping.getAlias());
            clone.setDescription(mapping.getDescription());
            clone.setMappingType(mapping.getMappingType());
            if (deepClone) {
                clone.setMappings(new Mappings());
                for (BaseMapping m : mapping.getMappings().getMapping()) {
                    clone.getMappings().getMapping().add(AtlasModelFactory.cloneMapping(m, deepClone));
                }
            }
            return clone;
        }
        Mapping mapping = (Mapping)baseMapping;
        Mapping clone = new Mapping();
        clone.setAlias(mapping.getAlias());
        clone.setDelimiter(mapping.getDelimiter());
        clone.setDelimiterString(mapping.getDelimiterString());
        clone.setDescription(mapping.getDescription());
        clone.setLookupTableName(mapping.getLookupTableName());
        if (mapping.getMappingType() != null) {
            clone.setMappingType(MappingType.fromValue(mapping.getMappingType().value()));
        }
        clone.setStrategy(mapping.getStrategy());
        clone.setStrategyClassName(mapping.getStrategyClassName());
        if (deepClone) {
            for (Field f : mapping.getInputField()) {
                clone.getInputField().add(AtlasModelFactory.cloneField(f));
            }
            for (Field f : mapping.getOutputField()) {
                clone.getOutputField().add(AtlasModelFactory.cloneField(f));
            }
        }
        return clone;
    }

    public static Field cloneField(Field f) {
        throw new IllegalArgumentException("Use module specific factories to clone fields");
    }

    public static FieldGroup copyFieldGroup(FieldGroup fg) {
        if (fg == null) {
            return null;
        }
        FieldGroup newfg = new FieldGroup();
        AtlasModelFactory.copyField(fg, newfg, true);
        return newfg;
    }

    public static SimpleField cloneFieldToSimpleField(Field field) {
        if (field == null) {
            return null;
        }
        SimpleField f = new SimpleField();
        AtlasModelFactory.copyField(field, f, true);
        return f;
    }

    public static void copyField(Field from, Field to, boolean withActions) {
        if (withActions) {
            to.setActions(AtlasModelFactory.cloneFieldActions(from.getActions()));
        }
        if (from.getArrayDimensions() != null) {
            to.setArrayDimensions((int)from.getArrayDimensions());
        }
        if (from.getArraySize() != null) {
            to.setArraySize((int)from.getArraySize());
        }
        if (from.getCollectionType() != null) {
            to.setCollectionType(CollectionType.fromValue(from.getCollectionType().value()));
        }
        if (from.getDocId() != null) {
            to.setDocId(from.getDocId());
        }
        if (from.getFieldType() != null) {
            to.setFieldType(FieldType.fromValue(from.getFieldType().value()));
        }
        if (from.getIndex() != null) {
            to.setIndex((int)from.getIndex());
        }
        if (from.getPath() != null) {
            to.setPath(from.getPath());
        }
        if (from.isRequired() != null) {
            to.setRequired((boolean)from.isRequired());
        }
        if (from.getStatus() != null) {
            to.setStatus(FieldStatus.fromValue(from.getStatus().value()));
        }
        if (from.getName() != null) {
            to.setName(from.getName());
        }
    }

    public static FieldGroup createFieldGroupFrom(Field field, boolean withActions) {
        FieldGroup answer = new FieldGroup();
        AtlasModelFactory.copyField(field, answer, withActions);
        return answer;
    }

    public static ArrayList<Action> cloneFieldActions(ArrayList<Action> actions) {
        if (actions == null) {
            return null;
        }
        ArrayList<Action> n = new ArrayList<Action>();
        if (actions == null || actions.isEmpty()) {
            return n;
        }
        for (Action a : actions) {
            n.add(AtlasModelFactory.cloneAction(a));
        }
        return n;
    }

    public static Action cloneAction(Action action) {
        if (action == null) {
            return null;
        }
        try {
            ObjectMapper mapper = new ObjectMapper().enable(MapperFeature.BLOCK_UNSAFE_POLYMORPHIC_BASE_TYPES);
            String s = mapper.writeValueAsString(action);
            System.out.println(s);
            return (Action)mapper.readerFor(Action.class).readValue(s);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected static String baseFieldToString(Field f) {
        if (f == null) {
            return "";
        }
        StringBuilder tmp = new StringBuilder();
        tmp.append(" arrayDimensions=" + f.getArrayDimensions());
        tmp.append(" arraySize=" + f.getArraySize());
        tmp.append(" collectionType=" + (f.getCollectionType() != null ? f.getCollectionType().value() : null));
        tmp.append(" docId=" + f.getDocId());
        if (f.getActions() != null && f.getActions() != null) {
            if (!f.getActions().isEmpty()) {
                tmp.append(" fieldActions#=" + f.getActions().size());
            } else {
                tmp.append(" fieldActions#=0");
            }
        } else {
            tmp.append(" fieldActions#=");
        }
        tmp.append(" fieldType=" + (f.getFieldType() != null ? f.getFieldType().value() : null));
        tmp.append(" index=" + f.getIndex());
        tmp.append(" path=" + f.getPath());
        tmp.append(" fieldStatus=" + (f.getStatus() != null ? f.getStatus().value() : null));
        tmp.append(" value=" + f.getValue());
        return tmp.toString();
    }

    public static String toString(PropertyField f) {
        StringBuilder tmp = new StringBuilder("PropertyField [name=");
        if (f != null && f.getName() != null) {
            tmp.append(f.getName());
        }
        tmp.append(AtlasModelFactory.baseFieldToString(f));
        tmp.append("]");
        return tmp.toString();
    }

    public static String toString(Field f) {
        StringBuilder tmp = new StringBuilder("Field [name=");
        if (f != null) {
            tmp.append(f.getClass().getSimpleName());
        }
        tmp.append(AtlasModelFactory.baseFieldToString(f));
        tmp.append("]");
        return tmp.toString();
    }

    public static Field wrapWithField(Object val) {
        return AtlasModelFactory.wrapWithField(val, "/");
    }

    public static Field wrapWithField(Object val, String parentPath) {
        if (val instanceof java.util.Collection) {
            Object[] collection = ((java.util.Collection)val).toArray();
            FieldGroup group2 = new FieldGroup();
            group2.setPath(parentPath + GENERATED_PATH);
            for (int i = 0; i < collection.length; ++i) {
                Field sub = AtlasModelFactory.wrapWithField(collection[i], group2.getPath());
                sub.setPath(sub.getPath() + "[" + i + "]");
                group2.getField().add(sub);
            }
            return group2;
        }
        SimpleField answer = new SimpleField();
        answer.setPath(GENERATED_PATH);
        answer.setValue(val);
        return answer;
    }

    public static Object unwrapField(Field f) {
        if (f == null) {
            return null;
        }
        if (f instanceof FieldGroup) {
            LinkedList<Object> l = new LinkedList<Object>();
            for (Field sub : ((FieldGroup)f).getField()) {
                l.add(AtlasModelFactory.unwrapField(sub));
            }
            return l;
        }
        return f.getValue();
    }
}

