/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.v2;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.module.jsonSchema.factories.JsonSchemaFactory;
import com.fasterxml.jackson.module.jsonSchema.factories.SchemaFactoryWrapper;
import com.fasterxml.jackson.module.jsonSchema.factories.VisitorContext;
import com.fasterxml.jackson.module.jsonSchema.factories.WrapperFactory;
import com.fasterxml.jackson.module.jsonSchema.types.SimpleTypeSchema;
import com.fasterxml.jackson.module.jsonSchema.types.StringSchema;
import io.atlasmap.v2.AtlasActionProperty;
import io.atlasmap.v2.FieldType;
import java.util.HashMap;

public class AtlasSchemaFactoryWrapper
extends SchemaFactoryWrapper {
    public AtlasSchemaFactoryWrapper() {
        super(new AtlasWrapperFactory());
        this.schemaProvider = new JsonSchemaFactory(){
            @JsonProperty
            protected FieldType atlasFieldType;

            public FieldType getAtlasFieldType() {
                return this.atlasFieldType;
            }

            public void setAtlasFieldType(FieldType atlasFieldType) {
                this.atlasFieldType = atlasFieldType;
            }

            @Override
            public StringSchema stringSchema() {
                return new ExtendedStringSchema();
            }
        };
    }

    private static void enrichMetadata(SimpleTypeSchema schema, BeanProperty property, HashMap<String, Object> metadata) {
        AtlasActionProperty atlasField = property.getAnnotation(AtlasActionProperty.class);
        if (atlasField != null) {
            schema.setTitle(atlasField.title());
            metadata.put("atlas-field-type", (Object)atlasField.type());
            metadata.put("atlas-collection-type", (Object)atlasField.collectionType());
        }
    }

    private static class ExtendedStringSchema
    extends StringSchema
    implements ExtendedJsonSchema {
        HashMap<String, Object> metadata = new HashMap();

        private ExtendedStringSchema() {
        }

        @Override
        @JsonAnyGetter
        public HashMap<String, Object> getMetadata() {
            return this.metadata;
        }

        @Override
        public void enrichWithBeanProperty(BeanProperty beanProperty) {
            AtlasSchemaFactoryWrapper.enrichMetadata(this, beanProperty, this.metadata);
            super.enrichWithBeanProperty(beanProperty);
        }
    }

    static interface ExtendedJsonSchema {
        @JsonAnyGetter
        public HashMap<String, Object> getMetadata();

        @JsonAnySetter
        default public void setMetadata(String name, Object value) {
            this.getMetadata().put(name, value);
        }
    }

    private static class AtlasWrapperFactory
    extends WrapperFactory {
        private AtlasWrapperFactory() {
        }

        @Override
        public SchemaFactoryWrapper getWrapper(SerializerProvider p) {
            AtlasSchemaFactoryWrapper wrapper = new AtlasSchemaFactoryWrapper();
            if (p != null) {
                wrapper.setProvider(p);
            }
            return wrapper;
        }

        @Override
        public SchemaFactoryWrapper getWrapper(SerializerProvider p, VisitorContext rvc) {
            AtlasSchemaFactoryWrapper wrapper = new AtlasSchemaFactoryWrapper();
            if (p != null) {
                wrapper.setProvider(p);
            }
            wrapper.setVisitorContext(rvc);
            return wrapper;
        }
    }
}

