/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.validators;

import io.atlasmap.v2.Validation;
import io.atlasmap.v2.ValidationScope;
import io.atlasmap.v2.ValidationStatus;
import io.atlasmap.validators.AtlasValidationHelper;
import io.atlasmap.validators.DefaultAtlasValidationsHelper;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class AtlasValidationHelperTest {
    private AtlasValidationHelper validations = null;
    private AtlasValidationHelper atlasValidationHelper = null;
    private Validation error = null;
    private Validation warning = null;
    private Validation info = null;

    @BeforeEach
    public void setUp() {
        this.validations = new DefaultAtlasValidationsHelper();
        this.error = new Validation();
        this.error.setScope(ValidationScope.ALL);
        this.error.setMessage("Error message");
        this.error.setStatus(ValidationStatus.ERROR);
        this.validations.addValidation(this.error);
        this.warning = new Validation();
        this.warning.setScope(ValidationScope.DATA_SOURCE);
        this.warning.setId("atlas:testDataSource");
        this.warning.setMessage("Warning message");
        this.warning.setStatus(ValidationStatus.WARN);
        this.validations.addValidation(this.warning);
        this.info = new Validation();
        this.info.setScope(ValidationScope.MAPPING);
        this.info.setId("0001");
        this.info.setMessage("Information message");
        this.info.setStatus(ValidationStatus.INFO);
        this.validations.addValidation(this.info);
        this.atlasValidationHelper = new DefaultAtlasValidationsHelper();
    }

    @AfterEach
    public void tearDown() {
        this.validations = null;
        this.error = null;
        this.warning = null;
        this.info = null;
        this.atlasValidationHelper = null;
    }

    @Test
    public void testGetScope() {
        Assertions.assertEquals((Object)((Object)ValidationScope.ALL), (Object)((Object)this.error.getScope()));
        Assertions.assertEquals((Object)((Object)ValidationScope.DATA_SOURCE), (Object)((Object)this.warning.getScope()));
        Assertions.assertEquals((Object)((Object)ValidationScope.MAPPING), (Object)((Object)this.info.getScope()));
    }

    @Test
    public void testGetId() {
        Assertions.assertNull((Object)this.error.getId());
        Assertions.assertEquals((Object)"atlas:testDataSource", (Object)this.warning.getId());
        Assertions.assertEquals((Object)"0001", (Object)this.info.getId());
    }

    @Test
    public void testGetDefaultMessage() {
        Assertions.assertTrue((boolean)this.error.getMessage().equals("Error message"));
        Assertions.assertTrue((boolean)this.warning.getMessage().equals("Warning message"));
        Assertions.assertTrue((boolean)this.info.getMessage().equals("Information message"));
    }

    @Test
    public void testGetLevel() {
        Assertions.assertTrue((this.error.getStatus().compareTo(ValidationStatus.ERROR) == 0 ? 1 : 0) != 0);
        Assertions.assertTrue((this.warning.getStatus().compareTo(ValidationStatus.WARN) == 0 ? 1 : 0) != 0);
        Assertions.assertTrue((this.info.getStatus().compareTo(ValidationStatus.INFO) == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testToString() {
        Assertions.assertEquals((Object)((Object)ValidationScope.ALL), (Object)((Object)this.error.getScope()));
        Assertions.assertNull((Object)this.error.getId());
        Assertions.assertEquals((Object)"Error message", (Object)this.error.getMessage());
        Assertions.assertEquals((Object)((Object)ValidationStatus.ERROR), (Object)((Object)this.error.getStatus()));
        Assertions.assertEquals((Object)((Object)ValidationScope.DATA_SOURCE), (Object)((Object)this.warning.getScope()));
        Assertions.assertEquals((Object)"atlas:testDataSource", (Object)this.warning.getId());
        Assertions.assertEquals((Object)"Warning message", (Object)this.warning.getMessage());
        Assertions.assertEquals((Object)((Object)ValidationStatus.WARN), (Object)((Object)this.warning.getStatus()));
        Assertions.assertEquals((Object)((Object)ValidationScope.MAPPING), (Object)((Object)this.info.getScope()));
        Assertions.assertEquals((Object)"0001", (Object)this.info.getId());
        Assertions.assertEquals((Object)"Information message", (Object)this.info.getMessage());
        Assertions.assertEquals((Object)((Object)ValidationStatus.INFO), (Object)((Object)this.info.getStatus()));
    }

    @Test
    public void testEquals() {
        Assertions.assertFalse((boolean)this.error.equals(this.info));
    }

    @Test
    public void testGetAllValidations() {
        Assertions.assertNotNull(this.validations.getAllValidations());
    }

    @Test
    public void testHasErrors() {
        Assertions.assertTrue((boolean)this.validations.hasErrors());
        Assertions.assertFalse((boolean)this.atlasValidationHelper.hasErrors());
    }

    @Test
    public void testHasWarnings() {
        Assertions.assertTrue((boolean)this.validations.hasWarnings());
        Assertions.assertFalse((boolean)this.atlasValidationHelper.hasWarnings());
    }

    @Test
    public void testHasInfos() {
        Assertions.assertTrue((boolean)this.validations.hasInfos());
        Assertions.assertFalse((boolean)this.atlasValidationHelper.hasInfos());
    }

    @Test
    public void testGetCount() {
        Assertions.assertEquals((int)3, (int)this.validations.getCount());
        Assertions.assertEquals((int)0, (int)this.atlasValidationHelper.getCount());
    }

    @Test
    public void testValidationToString() {
        Assertions.assertNotNull((Object)DefaultAtlasValidationsHelper.validationToString(null));
        Assertions.assertNotNull((Object)DefaultAtlasValidationsHelper.validationToString(this.info));
    }
}

