/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.validators;

import io.atlasmap.v2.Validation;
import io.atlasmap.v2.ValidationStatus;
import io.atlasmap.v2.Validations;
import java.util.List;

public class AtlasValidationTestHelper
extends Validations {
    private static final long serialVersionUID = -7993298271986178508L;

    public void addValidation(Validation validation) {
        this.getValidation().add(validation);
    }

    public List<Validation> getAllValidations() {
        return this.validation;
    }

    public boolean hasErrors() {
        if (this.getValidation() != null && !this.getValidation().isEmpty()) {
            for (Validation validation : this.getValidation()) {
                if (ValidationStatus.ERROR.compareTo(validation.getStatus()) != 0) continue;
                return true;
            }
        }
        return false;
    }

    public boolean hasWarnings() {
        if (this.getValidation() != null && !this.getValidation().isEmpty()) {
            for (Validation validation : this.getValidation()) {
                if (ValidationStatus.WARN.compareTo(validation.getStatus()) != 0) continue;
                return true;
            }
        }
        return false;
    }

    public boolean hasInfos() {
        if (this.getValidation() != null && !this.getValidation().isEmpty()) {
            for (Validation validation : this.getValidation()) {
                if (ValidationStatus.INFO.compareTo(validation.getStatus()) != 0) continue;
                return true;
            }
        }
        return false;
    }

    public int getCount() {
        if (this.getValidation() != null && !this.getValidation().isEmpty()) {
            return this.getValidation().size();
        }
        return 0;
    }

    public String allValidationsToString() {
        StringBuilder buf = new StringBuilder("[Validations ");
        this.getAllValidations().forEach(v -> buf.append(AtlasValidationTestHelper.validationToString(v)));
        return buf.append("]").toString();
    }

    public static String validationToString(Validation validation) {
        String output = "[Validation ";
        if (validation == null) {
            return output + ">null< ]";
        }
        if (validation.getScope() != null) {
            output = output + " scope=" + validation.getScope().value();
        }
        if (validation.getId() != null) {
            output = output + " id=" + validation.getId();
        }
        if (validation.getStatus() != null) {
            output = output + " status=" + validation.getStatus().value();
        }
        if (validation.getMessage() != null) {
            output = output + " msg=" + validation.getMessage();
        }
        return output + "]";
    }
}

