/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.validators;

import io.atlasmap.spi.AtlasValidator;
import io.atlasmap.v2.LookupTable;
import io.atlasmap.v2.LookupTables;
import io.atlasmap.v2.Validation;
import io.atlasmap.v2.ValidationScope;
import io.atlasmap.v2.ValidationStatus;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class LookupTableNameValidator
implements AtlasValidator {
    private String violationMessage;

    public LookupTableNameValidator(String violationMessage) {
        this.violationMessage = violationMessage;
    }

    @Override
    public boolean supports(Class<?> clazz) {
        return LookupTables.class.isAssignableFrom(clazz);
    }

    @Override
    public void validate(Object target, List<Validation> validations, String id) {
        this.validate(target, validations, id, ValidationStatus.ERROR);
    }

    @Override
    public void validate(Object target, List<Validation> validations, String id, ValidationStatus status) {
        LookupTables lookupTables = (LookupTables)target;
        List<LookupTable> tables = lookupTables.getLookupTable();
        List deduped = Collections.unmodifiableList(tables).stream().filter(LookupTableNameValidator.distinctByKey(LookupTable::getName)).collect(Collectors.toList());
        if (deduped.size() != tables.size()) {
            String dupedName = this.findDuplicatedName(tables);
            Validation validation = new Validation();
            validation.setScope(ValidationScope.LOOKUP_TABLE);
            validation.setId(id);
            validation.setMessage(String.format(this.violationMessage, dupedName));
            validation.setStatus(status);
            validations.add(validation);
        }
    }

    private String findDuplicatedName(List<LookupTable> tables) {
        ArrayList<String> names = new ArrayList<String>();
        for (LookupTable table : tables) {
            names.add(table.getName());
        }
        HashSet uniqueSet = new HashSet(names);
        for (String s : uniqueSet) {
            if (Collections.frequency(names, s) <= 1) continue;
            return s;
        }
        return null;
    }

    private static <T> Predicate<T> distinctByKey(Function<? super T, ?> keyExtractor) {
        ConcurrentHashMap seen = new ConcurrentHashMap();
        return t -> seen.putIfAbsent(keyExtractor.apply(t), Boolean.TRUE) == null;
    }
}

