/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.validators;

import io.atlasmap.v2.ValidationScope;
import io.atlasmap.validators.BaseValidatorTest;
import io.atlasmap.validators.StringPatternValidator;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class StringPatternValidatorTest
extends BaseValidatorTest {
    @Override
    @AfterEach
    public void tearDown() {
        super.tearDown();
        this.validator = null;
    }

    @Test
    public void testSupported() {
        this.validator = new StringPatternValidator(ValidationScope.ALL, "Must match .*", ".*");
        Assertions.assertTrue((boolean)this.validator.supports(String.class));
    }

    @Test
    public void testUnsupported() {
        this.validator = new StringPatternValidator(ValidationScope.DATA_SOURCE, "Must match [0-9_.]", "[0-9_.]");
        Assertions.assertFalse((boolean)this.validator.supports(Double.class));
    }

    @Test
    public void testValidate() {
        this.validator = new StringPatternValidator(ValidationScope.MAPPING, "Must match [^A-Za-z0-9_.]", "[^A-Za-z0-9_.]");
        this.validator.validate("This. &* should result in an error", this.validations, "testValidate");
        Assertions.assertTrue((boolean)this.validationHelper.hasErrors());
        this.validations.clear();
        Assertions.assertFalse((boolean)this.validationHelper.hasErrors());
        this.validator.validate("This_isafineexample.whatever1223", this.validations, "testValidate-2");
        Assertions.assertFalse((boolean)this.validationHelper.hasErrors());
    }

    @Test
    public void testValidateUsingMatch() {
        this.validator = new StringPatternValidator(ValidationScope.LOOKUP_TABLE, "Must match [0-9]+", "[0-9]+", true);
        this.validator.validate("0333", this.validations, "testValidateUsingMatch");
        Assertions.assertFalse((boolean)this.validationHelper.hasErrors());
        this.validator = new StringPatternValidator(ValidationScope.PROPERTY, "Must match [0-9]", "[0-9]", true);
        this.validator.validate("This_isafineexample.whatever", this.validations, "testValidateUsingMatch-2");
        Assertions.assertTrue((boolean)this.validationHelper.hasErrors());
    }
}

