/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.xml.core.schema;

import com.sun.xml.xsom.XSAnnotation;
import com.sun.xml.xsom.XSAttGroupDecl;
import com.sun.xml.xsom.XSAttributeDecl;
import com.sun.xml.xsom.XSAttributeUse;
import com.sun.xml.xsom.XSComplexType;
import com.sun.xml.xsom.XSContentType;
import com.sun.xml.xsom.XSElementDecl;
import com.sun.xml.xsom.XSFacet;
import com.sun.xml.xsom.XSIdentityConstraint;
import com.sun.xml.xsom.XSModelGroup;
import com.sun.xml.xsom.XSModelGroupDecl;
import com.sun.xml.xsom.XSNotation;
import com.sun.xml.xsom.XSParticle;
import com.sun.xml.xsom.XSSchema;
import com.sun.xml.xsom.XSSimpleType;
import com.sun.xml.xsom.XSTerm;
import com.sun.xml.xsom.XSType;
import com.sun.xml.xsom.XSWildcard;
import com.sun.xml.xsom.XSXPath;
import com.sun.xml.xsom.visitor.XSVisitor;
import java.util.LinkedList;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class AtlasRewritingXSVisitor
implements XSVisitor {
    private final Node source;
    private final Node target;

    public AtlasRewritingXSVisitor(Node source, Node target) {
        this.source = source;
        this.target = target;
    }

    @Override
    public void attributeUse(XSAttributeUse use) {
        this.attributeDecl(use.getDecl());
    }

    @Override
    public void modelGroupDecl(XSModelGroupDecl decl) {
        this.modelGroup(decl.getModelGroup());
    }

    @Override
    public void modelGroup(XSModelGroup model) {
        for (XSParticle term : model.getChildren()) {
            term.visit(this);
        }
    }

    @Override
    public void particle(XSParticle particle2) {
        XSTerm term = particle2.getTerm();
        term.visit(this);
    }

    @Override
    public void complexType(XSComplexType complex) {
        for (XSAttributeUse xSAttributeUse : complex.getAttributeUses()) {
            this.attributeUse(xSAttributeUse);
        }
        XSContentType contentType = complex.getContentType();
        contentType.visit(this);
    }

    @Override
    public void elementDecl(XSElementDecl decl) {
        String namespaceUri = decl.getTargetNamespace();
        String localName = decl.getName();
        try {
            for (Element child : this.getChildElements(this.source, namespaceUri, localName)) {
                Document targetDoc = this.target instanceof Document ? (Document)this.target : this.target.getOwnerDocument();
                Element targetChild = namespaceUri == null ? targetDoc.createElement(localName) : targetDoc.createElementNS(namespaceUri, localName);
                this.target.appendChild(targetChild);
                XSType type = decl.getType();
                type.visit(new AtlasRewritingXSVisitor(child, targetChild));
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void attributeDecl(XSAttributeDecl decl) {
        String localName;
        String namespaceUri = decl.getTargetNamespace();
        String attribute = this.getAttribute(this.source, namespaceUri, localName = decl.getName());
        if (attribute != null) {
            try {
                if (namespaceUri == null || "".equals(namespaceUri)) {
                    ((Element)this.target).setAttribute(localName, attribute);
                } else {
                    ((Element)this.target).setAttributeNS(namespaceUri, localName, attribute);
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public void simpleType(XSSimpleType simpleType2) {
        String value = this.source.getTextContent();
        if (value != null) {
            try {
                this.target.setTextContent(value);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public void empty(XSContentType empty) {
    }

    @Override
    public void facet(XSFacet facet2) {
    }

    @Override
    public void annotation(XSAnnotation ann) {
    }

    @Override
    public void schema(XSSchema schema) {
    }

    @Override
    public void notation(XSNotation notation2) {
    }

    @Override
    public void identityConstraint(XSIdentityConstraint decl) {
    }

    @Override
    public void xpath(XSXPath xp) {
    }

    @Override
    public void wildcard(XSWildcard wc) {
    }

    @Override
    public void attGroupDecl(XSAttGroupDecl decl) {
    }

    private List<Element> getChildElements(Node node, String namespaceUri, String localName) {
        LinkedList<Element> answer = new LinkedList<Element>();
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node n = nodeList.item(i);
            if (n.getNodeType() != 1) continue;
            Element e = (Element)n;
            if ((namespaceUri == null || "".equals(namespaceUri)) && (e.getNamespaceURI() == null || "".equals(e.getNamespaceURI()))) {
                if (localName == null || !localName.equals(e.getTagName())) continue;
                answer.add(e);
                continue;
            }
            if (namespaceUri == null || !namespaceUri.equals(e.getNamespaceURI()) || localName == null || !localName.equals(e.getLocalName())) continue;
            answer.add(e);
        }
        return answer;
    }

    private String getAttribute(Node node, String namespaceUri, String localName) {
        Node attr;
        NamedNodeMap attrMap;
        if (namespaceUri == null) {
            namespaceUri = "";
        }
        if ((attrMap = node.getAttributes()) == null) {
            return null;
        }
        if ("".equals(namespaceUri) && (attr = attrMap.getNamedItem(localName)) != null) {
            return attr.getNodeValue();
        }
        attr = attrMap.getNamedItemNS(namespaceUri, localName);
        return attr != null ? attr.getNodeValue() : null;
    }
}

