/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.xml.core.schema;

import com.sun.xml.xsom.XSSchemaSet;
import com.sun.xml.xsom.parser.XSOMParser;
import com.sun.xml.xsom.util.DomAnnotationParserFactory;
import io.atlasmap.api.AtlasException;
import io.atlasmap.xml.core.AtlasXmlNamespaceContext;
import io.atlasmap.xml.core.schema.XSOMClasspathEntityResolver;
import io.atlasmap.xml.core.schema.XSOMErrorHandler;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.LinkedList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class AtlasXmlSchemaSetParser {
    private static final Logger LOG = LoggerFactory.getLogger(AtlasXmlSchemaSetParser.class);
    private ClassLoader classLoader;
    private AtlasXmlNamespaceContext namespaceContext;
    private String rootNamespace;
    private SAXParserFactory saxParserFactory;
    private Transformer transformer;
    private DocumentBuilder documentBuilder;

    public AtlasXmlSchemaSetParser(ClassLoader cl) throws AtlasException {
        this.classLoader = cl;
        this.namespaceContext = new AtlasXmlNamespaceContext();
        this.saxParserFactory = SAXParserFactory.newInstance();
        try {
            this.transformer = TransformerFactory.newInstance().newTransformer();
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(true);
            this.documentBuilder = dbf.newDocumentBuilder();
        }
        catch (Exception e) {
            throw new AtlasException(e);
        }
    }

    public XSSchemaSet parse(Document doc) throws AtlasException {
        XSOMParser xsomParser = this.createXSOMParser();
        this.parseInternal(doc, n -> {
            try {
                xsomParser.parse(this.toInputStream(n));
            }
            catch (Exception e) {
                throw new AtlasException(e);
            }
        });
        try {
            return xsomParser.getResult();
        }
        catch (Exception e) {
            throw new AtlasException(e);
        }
    }

    public XSSchemaSet parse(InputStream in) throws AtlasException {
        try {
            Document doc = this.documentBuilder.parse(in);
            return this.parse(doc);
        }
        catch (Exception e) {
            throw new AtlasException(e);
        }
    }

    public Schema createSchema(InputStream in) throws AtlasException {
        SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        LinkedList schemaSources = new LinkedList();
        try {
            Document doc = this.documentBuilder.parse(in);
            this.parseInternal(doc, n -> {
                DOMSource s = new DOMSource(n);
                schemaSources.add(s);
            });
            factory.setErrorHandler(new NoopErrorHandler());
            return factory.newSchema(schemaSources.toArray(new Source[0]));
        }
        catch (AtlasException e) {
            throw e;
        }
        catch (Exception e2) {
            throw new AtlasException(e2);
        }
    }

    public void setNamespaceContext(AtlasXmlNamespaceContext nsc) {
        this.namespaceContext = nsc;
    }

    public AtlasXmlNamespaceContext getNamespaceContext() {
        return this.namespaceContext;
    }

    public void setRootNamespace(String rootns) {
        this.rootNamespace = rootns;
    }

    public String getRootNamespace() {
        return this.rootNamespace;
    }

    private String getTargetNamespace(Node n) {
        NamedNodeMap attributes = n.getAttributes();
        if (attributes == null) {
            return "";
        }
        Attr tns = (Attr)attributes.getNamedItem("targetNamespace");
        return tns != null ? tns.getValue() : "";
    }

    private void parseInternal(Document doc, ParserCallback callback) throws AtlasException {
        block8: {
            try {
                Element root = doc.getDocumentElement();
                if ("SchemaSet".equals(root.getLocalName())) {
                    XPath xpath2 = XPathFactory.newInstance().newXPath();
                    xpath2.setNamespaceContext(this.namespaceContext);
                    NodeList subSchemas = (NodeList)xpath2.evaluate(String.format("/%s:SchemaSet/%s:AdditionalSchemas/%s:schema", "ss", "ss", "xs"), root, XPathConstants.NODESET);
                    for (int i = 0; i < subSchemas.getLength(); ++i) {
                        Element e = (Element)subSchemas.item(i);
                        this.inheritNamespaces(e, false);
                        callback.addSchema(e);
                    }
                    Element rootSchema = (Element)xpath2.evaluate(String.format("/%s:SchemaSet/%s:schema", "ss", "xs"), root, XPathConstants.NODE);
                    if (rootSchema == null) {
                        throw new AtlasException("The root schema '/SchemaSet/schema' must be specified once and only once");
                    }
                    this.rootNamespace = this.getTargetNamespace(rootSchema);
                    if (this.rootNamespace != null && !this.rootNamespace.isEmpty()) {
                        this.namespaceContext.add("tns", this.rootNamespace);
                    }
                    this.inheritNamespaces(rootSchema, true);
                    callback.addSchema(rootSchema);
                    break block8;
                }
                if ("schema".equals(root.getLocalName())) {
                    callback.addSchema(root);
                    this.rootNamespace = this.getTargetNamespace(root);
                    if (this.rootNamespace != null && !this.rootNamespace.isEmpty()) {
                        this.namespaceContext.add("tns", this.rootNamespace);
                    }
                    break block8;
                }
                throw new AtlasException(String.format("Unsupported document element '%s': root element must be 'schema' or 'SchemaSet'", root.getLocalName()));
            }
            catch (Exception e) {
                throw new AtlasException(e);
            }
        }
    }

    private XSOMParser createXSOMParser() {
        XSOMParser parser = new XSOMParser(this.saxParserFactory);
        parser.setEntityResolver(new XSOMClasspathEntityResolver(this.classLoader));
        parser.setAnnotationParser(new DomAnnotationParserFactory());
        parser.setErrorHandler(new XSOMErrorHandler());
        return parser;
    }

    private void inheritNamespaces(Element element, boolean updateContext) {
        for (Node target = element.getParentNode(); target != null; target = target.getParentNode()) {
            NamedNodeMap attributes = target.getAttributes();
            if (attributes == null) continue;
            for (int i = 0; i < attributes.getLength(); ++i) {
                Attr attr = (Attr)attributes.item(i);
                if (!"xmlns".equals(attr.getPrefix()) || "xmlns".equals(attr.getLocalName())) continue;
                element.setAttribute(attr.getName(), attr.getValue());
                if (!updateContext) continue;
                this.namespaceContext.add(attr.getLocalName(), attr.getValue());
            }
        }
    }

    private ByteArrayInputStream toInputStream(Node n) throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.transformer.transform(new DOMSource(n), new StreamResult(baos));
        byte[] output = baos.toByteArray();
        if (LOG.isTraceEnabled()) {
            LOG.trace(">>> {}", (Object)new String(output));
        }
        return new ByteArrayInputStream(output);
    }

    private class NoopErrorHandler
    implements ErrorHandler {
        private NoopErrorHandler() {
        }

        @Override
        public void warning(SAXParseException e) throws SAXException {
            if (LOG.isDebugEnabled()) {
                LOG.debug("warning", (Throwable)e);
            }
        }

        @Override
        public void error(SAXParseException e) throws SAXException {
            if (LOG.isDebugEnabled()) {
                LOG.debug("error", (Throwable)e);
            }
        }

        @Override
        public void fatalError(SAXParseException e) throws SAXException {
            if (LOG.isDebugEnabled()) {
                LOG.debug("fatalError", (Throwable)e);
            }
        }
    }

    @FunctionalInterface
    private static interface ParserCallback {
        public void addSchema(Node var1) throws AtlasException;
    }
}

