/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.xml.inspect;

import com.sun.xml.xsom.XSAttributeDecl;
import com.sun.xml.xsom.XSAttributeUse;
import com.sun.xml.xsom.XSComplexType;
import com.sun.xml.xsom.XSDeclaration;
import com.sun.xml.xsom.XSElementDecl;
import com.sun.xml.xsom.XSFacet;
import com.sun.xml.xsom.XSModelGroup;
import com.sun.xml.xsom.XSModelGroupDecl;
import com.sun.xml.xsom.XSParticle;
import com.sun.xml.xsom.XSRestrictionSimpleType;
import com.sun.xml.xsom.XSSchema;
import com.sun.xml.xsom.XSSchemaSet;
import com.sun.xml.xsom.XSSimpleType;
import com.sun.xml.xsom.XSTerm;
import com.sun.xml.xsom.XSType;
import io.atlasmap.v2.CollectionType;
import io.atlasmap.v2.FieldStatus;
import io.atlasmap.v2.FieldType;
import io.atlasmap.v2.Fields;
import io.atlasmap.xml.core.AtlasXmlNamespaceContext;
import io.atlasmap.xml.core.XmlComplexTypeFactory;
import io.atlasmap.xml.core.schema.AtlasXmlSchemaSetParser;
import io.atlasmap.xml.inspect.SimpleTypeRestriction;
import io.atlasmap.xml.inspect.XmlInspectionException;
import io.atlasmap.xml.v2.AtlasXmlModelFactory;
import io.atlasmap.xml.v2.Restriction;
import io.atlasmap.xml.v2.RestrictionType;
import io.atlasmap.xml.v2.Restrictions;
import io.atlasmap.xml.v2.XmlComplexType;
import io.atlasmap.xml.v2.XmlDocument;
import io.atlasmap.xml.v2.XmlEnumField;
import io.atlasmap.xml.v2.XmlEnumFields;
import io.atlasmap.xml.v2.XmlField;
import io.atlasmap.xml.v2.XmlFields;
import io.atlasmap.xml.v2.XmlNamespace;
import io.atlasmap.xml.v2.XmlNamespaces;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XmlSchemaInspector {
    static final Logger LOG = LoggerFactory.getLogger(XmlSchemaInspector.class);
    private static final Map<String, FieldType> XS_TYPE_TO_FIELD_TYPE_MAP = new HashMap<String, FieldType>();
    private static final Map<String, FieldType> EXCLUDED_TYPES;
    private XmlDocument xmlDocument;
    private AtlasXmlNamespaceContext namespaceContext;
    private String rootNamespace;
    private ClassLoader classLoader;

    public void setClassLoader(ClassLoader loader) {
        this.classLoader = loader;
    }

    public XmlDocument getXmlDocument() {
        return this.xmlDocument;
    }

    public void inspect(File schemaFile) throws XmlInspectionException {
        try {
            this.doInspect(new FileInputStream(schemaFile));
        }
        catch (Exception e) {
            throw new XmlInspectionException(e);
        }
    }

    public void inspect(String schemaAsString) throws XmlInspectionException {
        try {
            this.doInspect(new ByteArrayInputStream(schemaAsString.getBytes("UTF-8")));
        }
        catch (Exception e) {
            throw new XmlInspectionException(e);
        }
    }

    private void doInspect(InputStream is) throws Exception {
        this.xmlDocument = AtlasXmlModelFactory.createXmlDocument();
        Fields fields = new Fields();
        this.xmlDocument.setFields(fields);
        AtlasXmlSchemaSetParser parser = new AtlasXmlSchemaSetParser(this.classLoader);
        XSSchemaSet schemaSet = parser.parse(is);
        this.namespaceContext = parser.getNamespaceContext();
        this.rootNamespace = parser.getRootNamespace();
        this.printSchemaSet(schemaSet);
        this.populateNamespaces();
    }

    private String getNameNS(XSDeclaration decl) {
        if (decl.getName() == null) {
            return null;
        }
        String targetNamespace = decl.getTargetNamespace();
        if (targetNamespace != null && !targetNamespace.isEmpty()) {
            String prefix = this.namespaceContext.getPrefix(targetNamespace);
            if (prefix == null || prefix.isEmpty()) {
                prefix = this.namespaceContext.addWithIndex(targetNamespace);
            }
            return String.format("%s:%s", prefix, decl.getName());
        }
        return decl.getName();
    }

    private void populateNamespaces() {
        for (Map.Entry<String, String> entry : this.namespaceContext.getNamespaceMap().entrySet()) {
            String prefix = entry.getKey();
            String uri = entry.getValue();
            if ("http://www.w3.org/2001/XMLSchema".equals(uri) || "http://atlasmap.io/xml/schemaset/v2".equals(uri)) continue;
            if (LOG.isTraceEnabled()) {
                LOG.trace("adding a namespace >>> prefix={}, uri={}", (Object)prefix, (Object)uri);
            }
            if (this.xmlDocument.getXmlNamespaces() == null) {
                this.xmlDocument.setXmlNamespaces(new XmlNamespaces());
            }
            XmlNamespace namespace = new XmlNamespace();
            namespace.setAlias(prefix);
            namespace.setUri(uri);
            this.xmlDocument.getXmlNamespaces().getXmlNamespace().add(namespace);
        }
    }

    private void printSchemaSet(XSSchemaSet schemaSet) throws Exception {
        if (schemaSet == null) {
            throw new XmlInspectionException("Schema set is null");
        }
        XSSchema schema = this.rootNamespace != null ? schemaSet.getSchema(this.rootNamespace) : schemaSet.getSchema("");
        Iterator<XSElementDecl> jtr = schema.iterateElementDecls();
        while (jtr.hasNext()) {
            XSElementDecl e = jtr.next();
            String rootName = this.getNameNS(e);
            if (e.getType().isComplexType()) {
                XmlComplexType rootComplexType = this.getXmlComplexType();
                rootComplexType.setName(rootName);
                rootComplexType.setPath("/" + rootName);
                rootComplexType.setFieldType(FieldType.COMPLEX);
                this.xmlDocument.getFields().getField().add(rootComplexType);
                this.printComplexType(e.getType().asComplexType(), rootComplexType, new HashSet<String>());
                continue;
            }
            if (!e.getType().isSimpleType()) continue;
            XmlField xmlField = AtlasXmlModelFactory.createXmlField();
            xmlField.setName(rootName);
            xmlField.setPath("/" + rootName);
            this.xmlDocument.getFields().getField().add(xmlField);
            this.printSimpleType(e.getType().asSimpleType(), xmlField);
        }
    }

    private void printComplexType(XSComplexType complexType2, XmlComplexType parentXmlComplexType, Set<String> cachedComplexType) throws Exception {
        this.printAttributes(complexType2, parentXmlComplexType);
        XSParticle particle2 = complexType2.getContentType().asParticle();
        if (particle2 != null) {
            this.printParticle(particle2, parentXmlComplexType, cachedComplexType);
        }
    }

    private void printParticle(XSParticle particle2, XmlComplexType parentXmlComplexType, Set<String> cachedComplexType) throws Exception {
        XSTerm term = particle2.getTerm();
        if (term.isModelGroup()) {
            XSModelGroup group2 = term.asModelGroup();
            this.printGroup(group2, parentXmlComplexType, cachedComplexType);
        } else if (term.isModelGroupDecl()) {
            this.printGroupDecl(term.asModelGroupDecl(), parentXmlComplexType, cachedComplexType);
        } else if (term.isElementDecl()) {
            CollectionType collectionType = this.getCollectionType(particle2);
            this.printElement(term.asElementDecl(), parentXmlComplexType, collectionType, cachedComplexType);
        }
    }

    private void printGroup(XSModelGroup modelGroup, XmlComplexType parentXmlComplexType, Set<String> cachedComplexType) throws Exception {
        for (XSParticle particle2 : modelGroup.getChildren()) {
            HashSet<String> cachedTypeCopy = new HashSet<String>(cachedComplexType);
            this.printParticle(particle2, parentXmlComplexType, cachedTypeCopy);
        }
    }

    private void printGroupDecl(XSModelGroupDecl modelGroupDecl, XmlComplexType parentXmlComplexType, Set<String> cachedComplexType) throws Exception {
        this.printGroup(modelGroupDecl.getModelGroup(), parentXmlComplexType, cachedComplexType);
    }

    private void printElement(XSElementDecl element, XmlComplexType parentXmlComplexType, CollectionType collectionType, Set<String> cachedComplexType) throws Exception {
        String parentPath = parentXmlComplexType.getPath();
        String elementName = this.getNameNS(element);
        String typeName = this.getNameNS(element.getType());
        XSType elementType = element.getType();
        if (elementType == null) {
            return;
        }
        if (elementType.isComplexType()) {
            XmlComplexType complexType2 = this.getXmlComplexType();
            String path = parentPath + "/" + elementName + this.getCollectionPathSuffix(collectionType);
            complexType2.setName(elementName);
            complexType2.setPath(path);
            complexType2.setCollectionType(collectionType);
            parentXmlComplexType.getXmlFields().getXmlField().add(complexType2);
            if (typeName != null && !typeName.isEmpty() && cachedComplexType.contains(typeName)) {
                complexType2.setStatus(FieldStatus.CACHED);
            } else if (typeName != null) {
                cachedComplexType.add(typeName);
            }
            if (complexType2.getStatus() != FieldStatus.CACHED) {
                this.printComplexType(element.getType().asComplexType(), complexType2, cachedComplexType);
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Element: {}/{}", (Object)parentPath, (Object)this.getNameNS(element));
                }
            }
        } else if (elementType.asSimpleType() != null) {
            XSRestrictionSimpleType restrictionType;
            List<XSFacet> enumerations;
            if (LOG.isTraceEnabled()) {
                LOG.trace("Element: {}/{}", (Object)parentPath, (Object)this.getNameNS(element));
            }
            List<XSFacet> list = enumerations = (restrictionType = elementType.asSimpleType().asRestriction()) != null ? restrictionType.getFacets("enumeration") : null;
            if (enumerations != null && !enumerations.isEmpty()) {
                XmlComplexType complexType3 = this.getXmlComplexType();
                String path = parentPath + "/" + elementName + this.getCollectionPathSuffix(collectionType);
                complexType3.setName(elementName);
                complexType3.setPath(path);
                complexType3.setCollectionType(collectionType);
                complexType3.setEnumeration(true);
                parentXmlComplexType.getXmlFields().getXmlField().add(complexType3);
                XmlEnumFields enums = new XmlEnumFields();
                complexType3.setXmlEnumFields(enums);
                for (XSFacet enumFacet : enumerations) {
                    XmlEnumField f = new XmlEnumField();
                    f.setName(enumFacet.getValue().toString());
                    enums.getXmlEnumField().add(f);
                }
                return;
            }
            XmlField xmlField = AtlasXmlModelFactory.createXmlField();
            xmlField.setName(elementName);
            xmlField.setPath(parentPath + "/" + elementName + this.getCollectionPathSuffix(collectionType));
            xmlField.setCollectionType(collectionType);
            parentXmlComplexType.getXmlFields().getXmlField().add(xmlField);
            if (element.getDefaultValue() != null) {
                xmlField.setValue(element.getDefaultValue());
            } else if (element.getFixedValue() != null) {
                xmlField.setValue(element.getFixedValue());
            }
            XSRestrictionSimpleType typeRestriction = element.getType().asSimpleType().asRestriction();
            if (typeRestriction != null) {
                xmlField.setFieldType(XS_TYPE_TO_FIELD_TYPE_MAP.get(typeRestriction.getBaseType().getName()));
                this.mapRestrictions(xmlField, typeRestriction);
            }
            this.printSimpleType(element.getType().asSimpleType(), xmlField);
        }
    }

    private String getCollectionPathSuffix(CollectionType type) {
        if (type == null) {
            return "";
        }
        switch (type) {
            case ARRAY: {
                return "[]";
            }
            case LIST: {
                return "<>";
            }
            case MAP: {
                return "{}";
            }
        }
        return "";
    }

    private void printAttributes(XSComplexType xsComplexType, XmlComplexType parentXmlComplexType) {
        Collection<? extends XSAttributeUse> c = xsComplexType.getDeclaredAttributeUses();
        for (XSAttributeUse xSAttributeUse : c) {
            XmlField xmlField = AtlasXmlModelFactory.createXmlField();
            XSAttributeDecl attributeDecl = xSAttributeUse.getDecl();
            xmlField.setName(this.getNameNS(attributeDecl));
            xmlField.setAttribute(true);
            if (attributeDecl.getDefaultValue() != null) {
                xmlField.setValue(attributeDecl.getDefaultValue().value);
            } else if (attributeDecl.getFixedValue() != null) {
                xmlField.setValue(attributeDecl.getFixedValue().value);
            }
            xmlField.setPath(parentXmlComplexType.getPath() + "/@" + this.getNameNS(attributeDecl));
            FieldType attrType = this.getFieldType(attributeDecl.getType().getName());
            xmlField.setFieldType(attrType);
            if (xmlField.getFieldType() == null) {
                XSSimpleType simpleType2 = xsComplexType.getRoot().getSimpleType(xsComplexType.getTargetNamespace(), attributeDecl.getType().getName());
                if (simpleType2 != null) {
                    FieldType fieldType = this.getFieldType(simpleType2.getBaseType().getName());
                    xmlField.setFieldType(fieldType);
                    xmlField.setTypeName(attributeDecl.getType().getName());
                    if (simpleType2.asRestriction() != null) {
                        this.mapRestrictions(xmlField, simpleType2.asRestriction());
                    }
                } else {
                    xmlField.setFieldType(FieldType.UNSUPPORTED);
                }
            }
            parentXmlComplexType.getXmlFields().getXmlField().add(xmlField);
        }
    }

    private void printSimpleType(XSSimpleType simpleType2, XmlField xmlField) {
        if (xmlField.getFieldType() == null) {
            FieldType attrType = this.getFieldType(simpleType2.getName());
            xmlField.setFieldType(attrType);
        }
    }

    private void mapRestrictions(XmlField xmlField, XSRestrictionSimpleType restrictionSimpleType) {
        SimpleTypeRestriction simpleTypeRestriction = new SimpleTypeRestriction();
        simpleTypeRestriction.initRestrictions(restrictionSimpleType);
        Restrictions restrictions = new Restrictions();
        xmlField.setRestrictions(restrictions);
        this.mapSimpleRestrictionToRestriction(simpleTypeRestriction, xmlField);
    }

    private XmlComplexType getXmlComplexType() {
        XmlComplexType rootComplexType = XmlComplexTypeFactory.createXmlComlexField();
        rootComplexType.setFieldType(FieldType.COMPLEX);
        rootComplexType.setXmlFields(new XmlFields());
        return rootComplexType;
    }

    private FieldType getFieldType(String name) {
        FieldType attrType = EXCLUDED_TYPES.get(name);
        if (attrType == null) {
            attrType = XS_TYPE_TO_FIELD_TYPE_MAP.get(name);
        }
        return attrType;
    }

    private CollectionType getCollectionType(XSParticle particle2) {
        if (!particle2.isRepeated()) {
            return null;
        }
        if (particle2.isRepeated() && particle2.getMaxOccurs().intValue() == -1) {
            return CollectionType.LIST;
        }
        if (particle2.isRepeated() && particle2.getMaxOccurs().intValue() > 1) {
            return CollectionType.ARRAY;
        }
        return null;
    }

    private void mapSimpleRestrictionToRestriction(SimpleTypeRestriction simpleTypeRestriction, XmlField xmlField) {
        for (Field field : SimpleTypeRestriction.class.getDeclaredFields()) {
            field.setAccessible(true);
            try {
                if (!this.typeRestrictionExists(field.getName())) continue;
                Object value = field.get(simpleTypeRestriction);
                if (value instanceof String[]) {
                    String[] values;
                    for (String v : values = (String[])value) {
                        Restriction restriction = new Restriction();
                        restriction.setValue(v.toString());
                        restriction.setType(RestrictionType.fromValue(field.getName()));
                        xmlField.getRestrictions().getRestriction().add(restriction);
                    }
                    continue;
                }
                if (value == null) continue;
                Restriction restriction = new Restriction();
                restriction.setValue(value.toString());
                restriction.setType(RestrictionType.fromValue(field.getName()));
                xmlField.getRestrictions().getRestriction().add(restriction);
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
    }

    private boolean typeRestrictionExists(String name) {
        for (RestrictionType restrictionType : RestrictionType.values()) {
            if (!name.equals(restrictionType.value())) continue;
            return true;
        }
        return false;
    }

    static {
        XS_TYPE_TO_FIELD_TYPE_MAP.put("int", FieldType.INTEGER);
        XS_TYPE_TO_FIELD_TYPE_MAP.put("integer", FieldType.BIG_INTEGER);
        XS_TYPE_TO_FIELD_TYPE_MAP.put("negativeInteger", FieldType.BIG_INTEGER);
        XS_TYPE_TO_FIELD_TYPE_MAP.put("nonNegativeInteger", FieldType.BIG_INTEGER);
        XS_TYPE_TO_FIELD_TYPE_MAP.put("positiveInteger", FieldType.BIG_INTEGER);
        XS_TYPE_TO_FIELD_TYPE_MAP.put("nonPositiveInteger", FieldType.BIG_INTEGER);
        XS_TYPE_TO_FIELD_TYPE_MAP.put("string", FieldType.STRING);
        XS_TYPE_TO_FIELD_TYPE_MAP.put("short", FieldType.SHORT);
        XS_TYPE_TO_FIELD_TYPE_MAP.put("long", FieldType.LONG);
        XS_TYPE_TO_FIELD_TYPE_MAP.put("double", FieldType.DOUBLE);
        XS_TYPE_TO_FIELD_TYPE_MAP.put("float", FieldType.FLOAT);
        XS_TYPE_TO_FIELD_TYPE_MAP.put("boolean", FieldType.BOOLEAN);
        XS_TYPE_TO_FIELD_TYPE_MAP.put("date", FieldType.DATE);
        XS_TYPE_TO_FIELD_TYPE_MAP.put("dateTime", FieldType.DATE_TIME);
        XS_TYPE_TO_FIELD_TYPE_MAP.put("decimal", FieldType.DECIMAL);
        XS_TYPE_TO_FIELD_TYPE_MAP.put("float", FieldType.FLOAT);
        XS_TYPE_TO_FIELD_TYPE_MAP.put("unsignedLong", FieldType.UNSIGNED_LONG);
        XS_TYPE_TO_FIELD_TYPE_MAP.put("unsignedInt", FieldType.UNSIGNED_INTEGER);
        XS_TYPE_TO_FIELD_TYPE_MAP.put("unsignedLong", FieldType.UNSIGNED_LONG);
        XS_TYPE_TO_FIELD_TYPE_MAP.put("unsignedShort", FieldType.UNSIGNED_SHORT);
        XS_TYPE_TO_FIELD_TYPE_MAP.put("NMTOKEN", FieldType.STRING);
        XS_TYPE_TO_FIELD_TYPE_MAP.put("anyURI", FieldType.STRING);
        XS_TYPE_TO_FIELD_TYPE_MAP.put("base64Binary", FieldType.STRING);
        XS_TYPE_TO_FIELD_TYPE_MAP.put("hexBinary", FieldType.STRING);
        XS_TYPE_TO_FIELD_TYPE_MAP.put("QName", FieldType.STRING);
        EXCLUDED_TYPES = new HashMap<String, FieldType>();
        EXCLUDED_TYPES.put("NOTATION", FieldType.UNSUPPORTED);
    }
}

