/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.xml.module;

import com.sun.xml.xsom.XSElementDecl;
import com.sun.xml.xsom.XSSchemaSet;
import io.atlasmap.api.AtlasException;
import io.atlasmap.api.AtlasValidationException;
import io.atlasmap.core.AtlasUtil;
import io.atlasmap.core.BaseAtlasModule;
import io.atlasmap.spi.AtlasCollectionHelper;
import io.atlasmap.spi.AtlasFieldActionService;
import io.atlasmap.spi.AtlasInternalSession;
import io.atlasmap.spi.AtlasModuleDetail;
import io.atlasmap.v2.AtlasModelFactory;
import io.atlasmap.v2.AuditStatus;
import io.atlasmap.v2.DataSource;
import io.atlasmap.v2.DataSourceType;
import io.atlasmap.v2.Field;
import io.atlasmap.v2.FieldGroup;
import io.atlasmap.v2.InspectionType;
import io.atlasmap.v2.Validation;
import io.atlasmap.xml.core.XmlCollectionHelper;
import io.atlasmap.xml.core.XmlFieldReader;
import io.atlasmap.xml.core.XmlFieldWriter;
import io.atlasmap.xml.core.XmlIOHelper;
import io.atlasmap.xml.core.XmlPath;
import io.atlasmap.xml.core.schema.AtlasRewritingXSVisitor;
import io.atlasmap.xml.core.schema.AtlasXmlSchemaSetParser;
import io.atlasmap.xml.module.XmlValidationService;
import io.atlasmap.xml.v2.AtlasXmlModelFactory;
import io.atlasmap.xml.v2.XmlDataSource;
import io.atlasmap.xml.v2.XmlEnumField;
import io.atlasmap.xml.v2.XmlField;
import io.atlasmap.xml.v2.XmlNamespace;
import io.atlasmap.xml.v2.XmlNamespaces;
import java.io.ByteArrayInputStream;
import java.util.HashMap;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

@AtlasModuleDetail(name="XmlModule", uri="atlas:xml", modes={"SOURCE", "TARGET"}, dataFormats={"xml"}, configPackages={"io.atlasmap.xml.v2"})
public class XmlModule
extends BaseAtlasModule {
    private static final Logger LOG = LoggerFactory.getLogger(XmlModule.class);
    private XmlIOHelper ioHelper;

    @Override
    public void init() throws AtlasException {
        super.init();
        this.ioHelper = new XmlIOHelper(this.getClassLoader());
    }

    @Override
    public void processPreValidation(AtlasInternalSession atlasSession) throws AtlasException {
        if (atlasSession == null || atlasSession.getMapping() == null) {
            LOG.error("Invalid session: Session and AtlasMapping must be specified");
            throw new AtlasValidationException("Invalid session");
        }
        List<Validation> xmlValidations = this.createValidationService().validateMapping(atlasSession.getMapping());
        atlasSession.getValidations().getValidation().addAll(xmlValidations);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Detected " + xmlValidations.size() + " xml validation notices");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("{}: processPreValidation completed", (Object)this.getDocId());
        }
    }

    protected XmlValidationService createValidationService() {
        XmlValidationService xmlValidationService = new XmlValidationService(this.getConversionService(), this.getFieldActionService());
        xmlValidationService.setMode(this.getMode());
        xmlValidationService.setDocId(this.getDocId());
        return xmlValidationService;
    }

    @Override
    public void processPreSourceExecution(AtlasInternalSession session) throws AtlasException {
        Object sourceDocument = session.getSourceDocument(this.getDocId());
        String sourceDocumentString = null;
        boolean enableNamespaces = false;
        if (sourceDocument == null || !(sourceDocument instanceof String)) {
            AtlasUtil.addAudit(session, this.getDocId(), String.format("Null or non-String source document: docId='%s'", this.getDocId()), AuditStatus.WARN, null);
        } else {
            enableNamespaces = true;
            String param = this.getUriParameters().get("disableNamespaces");
            if (param != null && "true".equalsIgnoreCase(param)) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Disabling namespace support");
                }
                enableNamespaces = false;
            }
            sourceDocumentString = (String)String.class.cast(sourceDocument);
        }
        Document sourceXmlDocument = this.convertToXmlDocument(sourceDocumentString, enableNamespaces);
        XmlFieldReader reader = new XmlFieldReader(this.getClassLoader(), this.getConversionService());
        reader.setDocument(sourceXmlDocument);
        session.setFieldReader(this.getDocId(), reader);
        if (LOG.isDebugEnabled()) {
            LOG.debug("{}: processPreSourceExecution completed", (Object)this.getDocId());
        }
    }

    protected Document convertToXmlDocument(String source, boolean namespaced) throws AtlasException {
        if (source == null || source.isEmpty()) {
            return null;
        }
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(namespaced);
            DocumentBuilder b = dbf.newDocumentBuilder();
            return b.parse(new ByteArrayInputStream(source.getBytes("UTF-8")));
        }
        catch (Exception e) {
            LOG.warn("Failed to parse XML document", (Throwable)e);
            return null;
        }
    }

    @Override
    public void processPreTargetExecution(AtlasInternalSession session) throws AtlasException {
        XmlNamespaces xmlNs = null;
        String template = null;
        for (DataSource dataSource : session.getMapping().getDataSource()) {
            if (!DataSourceType.TARGET.equals((Object)dataSource.getDataSourceType()) || !(dataSource instanceof XmlDataSource) || dataSource.getId() != null && !dataSource.getId().equals(this.getDocId())) continue;
            xmlNs = ((XmlDataSource)dataSource).getXmlNamespaces();
            template = ((XmlDataSource)dataSource).getTemplate();
        }
        HashMap<String, String> nsMap = new HashMap<String, String>();
        if (xmlNs != null && xmlNs.getXmlNamespace() != null && !xmlNs.getXmlNamespace().isEmpty()) {
            for (XmlNamespace ns : xmlNs.getXmlNamespace()) {
                nsMap.put(ns.getAlias(), ns.getUri());
            }
        }
        XmlFieldWriter xmlFieldWriter = new XmlFieldWriter(this.getClassLoader(), nsMap, template);
        session.setFieldWriter(this.getDocId(), xmlFieldWriter);
        if (LOG.isDebugEnabled()) {
            LOG.debug("{}: processPreTargetExcution completed", (Object)this.getDocId());
        }
    }

    @Override
    public void readSourceValue(AtlasInternalSession session) throws AtlasException {
        Field sourceField = session.head().getSourceField();
        XmlFieldReader reader = session.getFieldReader(this.getDocId(), XmlFieldReader.class);
        if (reader == null) {
            AtlasUtil.addAudit(session, sourceField, String.format("Source document '%s' doesn't exist", this.getDocId()), AuditStatus.ERROR, null);
            return;
        }
        reader.read(session);
        if (LOG.isDebugEnabled()) {
            LOG.debug("{}: processSourceFieldMapping completed: SourceField:[docId={}, path={}, type={}, value={}]", new Object[]{this.getDocId(), sourceField.getDocId(), sourceField.getPath(), sourceField.getFieldType(), sourceField.getValue()});
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void populateTargetField(AtlasInternalSession session) throws AtlasException {
        Field sourceField = session.head().getSourceField();
        Field targetField = session.head().getTargetField();
        XmlPath path = new XmlPath(targetField.getPath());
        FieldGroup targetFieldGroup = null;
        if (path.hasCollection() && !path.isIndexedCollection()) {
            targetFieldGroup = AtlasModelFactory.createFieldGroupFrom(targetField, true);
            session.head().setTargetField(targetFieldGroup);
        }
        if (targetField.getFieldType() == null && sourceField.getValue() != null) {
            targetField.setFieldType(this.getConversionService().fieldTypeFromClass(sourceField.getValue().getClass()));
        }
        if (targetFieldGroup == null) {
            List<Field> subFields;
            if (sourceField instanceof FieldGroup && (subFields = ((FieldGroup)sourceField).getField()) != null && subFields.size() > 0) {
                Integer index = targetField.getIndex();
                if (index != null) {
                    if (subFields.size() <= index) {
                        AtlasUtil.addAudit(session, this.getDocId(), String.format("The number of source fields (%s) is smaller than target index (%s) - ignoring", subFields.size(), index), AuditStatus.WARN, null);
                        return;
                    }
                    sourceField = subFields.get(index);
                } else {
                    sourceField = subFields.get(subFields.size() - 1);
                }
                session.head().setSourceField(sourceField);
            }
            super.populateTargetField(session);
        } else if (sourceField instanceof FieldGroup) {
            targetFieldGroup.setStatus(sourceField.getStatus());
            XmlField previousTargetSubField = null;
            for (int i = 0; i < ((FieldGroup)sourceField).getField().size(); ++i) {
                Field sourceSubField = ((FieldGroup)sourceField).getField().get(i);
                XmlField targetSubField = new XmlField();
                AtlasXmlModelFactory.copyField(targetField, targetSubField, false);
                this.getCollectionHelper().copyCollectionIndexes(sourceField, sourceSubField, targetSubField, previousTargetSubField);
                previousTargetSubField = targetSubField;
                if (targetSubField.getFieldType() == null && sourceSubField.getValue() != null) {
                    targetSubField.setFieldType(this.getConversionService().fieldTypeFromClass(sourceSubField.getValue().getClass()));
                }
                targetFieldGroup.getField().add(targetSubField);
                session.head().setSourceField(sourceSubField);
                session.head().setTargetField(targetSubField);
                super.populateTargetField(session);
            }
            session.head().setSourceField(sourceField);
            session.head().setTargetField(targetFieldGroup);
        } else {
            XmlField targetSubField = new XmlField();
            AtlasXmlModelFactory.copyField(targetField, targetSubField, false);
            path.setVacantCollectionIndex(0);
            targetSubField.setPath(path.toString());
            targetFieldGroup.getField().add(targetSubField);
            session.head().setTargetField(targetSubField);
            super.populateTargetField(session);
            session.head().setTargetField(targetFieldGroup);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("{}: processTargetFieldMapping completed: SourceField:[docId={}, path={}, type={}, value={}], TargetField:[docId={}, path={}, type={}, value={}]", new Object[]{this.getDocId(), sourceField.getDocId(), sourceField.getPath(), sourceField.getFieldType(), sourceField.getValue(), targetField.getDocId(), targetField.getPath(), targetField.getFieldType(), targetField.getValue()});
        }
    }

    @Override
    protected AtlasCollectionHelper createCollectionHelper(AtlasFieldActionService fieldActionService) {
        return new XmlCollectionHelper(fieldActionService);
    }

    @Override
    public void writeTargetValue(AtlasInternalSession session) throws AtlasException {
        FieldGroup targetFieldGroup;
        XmlFieldWriter writer = session.getFieldWriter(this.getDocId(), XmlFieldWriter.class);
        if (session.head().getTargetField() instanceof FieldGroup && (targetFieldGroup = (FieldGroup)session.head().getTargetField()).getField().size() > 0) {
            for (Field f : targetFieldGroup.getField()) {
                session.head().setTargetField(f);
                writer.write(session);
            }
            return;
        }
        writer.write(session);
    }

    @Override
    public void processPostSourceExecution(AtlasInternalSession session) throws AtlasException {
        session.removeFieldReader(this.getDocId());
        if (LOG.isDebugEnabled()) {
            LOG.debug("{}: processPostSourceExecution completed", (Object)this.getDocId());
        }
    }

    @Override
    public void processPostTargetExecution(AtlasInternalSession session) throws AtlasException {
        XmlFieldWriter writer = session.getFieldWriter(this.getDocId(), XmlFieldWriter.class);
        if (writer != null && writer.getDocument() != null) {
            Document doc = this.enforceSchema(writer.getDocument());
            String targetDocumentString = this.convertFromXmlDocument(doc);
            session.setTargetDocument(this.getDocId(), targetDocumentString);
        } else {
            AtlasUtil.addAudit(session, this.getDocId(), String.format("No target document created for DataSource:[id=%s, uri=%s]", this.getDocId(), this.getUri()), AuditStatus.WARN, null);
        }
        session.removeFieldWriter(this.getDocId());
        if (LOG.isDebugEnabled()) {
            LOG.debug("{}: processPostTargetExecution completed", (Object)this.getDocId());
        }
    }

    protected String convertFromXmlDocument(Document xml) throws AtlasException {
        return this.getXmlIOHelper().writeDocumentToString(false, xml);
    }

    @Override
    public Boolean isSupportedField(Field field) {
        if (super.isSupportedField(field).booleanValue()) {
            return true;
        }
        return field instanceof XmlField || field instanceof XmlEnumField;
    }

    @Override
    public Field cloneField(Field field) throws AtlasException {
        return AtlasXmlModelFactory.cloneField((XmlField)field, true);
    }

    @Override
    public XmlField createField() {
        return AtlasXmlModelFactory.createXmlField();
    }

    protected XmlIOHelper getXmlIOHelper() {
        return this.ioHelper;
    }

    private Document enforceSchema(Document doc) {
        if (this.getDataSourceMetadata() == null || this.getDataSourceMetadata().getInspectionType() != InspectionType.SCHEMA || this.getDataSourceMetadata().getSpecification() == null || this.getDataSourceMetadata().getSpecification().length == 0) {
            return doc;
        }
        try {
            XSElementDecl rootDecl;
            byte[] bytes = this.getDataSourceMetadata().getSpecification();
            AtlasXmlSchemaSetParser schemaParser = new AtlasXmlSchemaSetParser(this.getClassLoader());
            XSSchemaSet schemaSet = schemaParser.parse(new ByteArrayInputStream(bytes));
            Element sourceRoot = doc.getDocumentElement();
            String namespaceUri = sourceRoot.getNamespaceURI();
            if (namespaceUri == null) {
                namespaceUri = "";
            }
            String localName = sourceRoot.getLocalName();
            if ("".equals(namespaceUri)) {
                localName = sourceRoot.getTagName();
            }
            if ((rootDecl = schemaSet.getElementDecl(namespaceUri, localName)) == null) {
                LOG.warn("Declaration of the root element '{}' was not found in the schema", (Object)(namespaceUri != null ? namespaceUri + ":" + localName : localName));
                return doc;
            }
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(true);
            Document targetDoc = dbf.newDocumentBuilder().newDocument();
            rootDecl.visit(new AtlasRewritingXSVisitor(doc, targetDoc));
            return targetDoc;
        }
        catch (Exception e) {
            LOG.warn("Failed to load XML schema for the document '{}': {} - ignoring", (Object)this.getDocId(), (Object)e.getMessage());
            if (LOG.isDebugEnabled()) {
                LOG.debug("", (Throwable)e);
            }
            return doc;
        }
    }
}

