/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.xml.module;

import io.atlasmap.core.validate.BaseModuleValidationService;
import io.atlasmap.spi.AtlasConversionService;
import io.atlasmap.spi.AtlasFieldActionService;
import io.atlasmap.spi.AtlasModuleDetail;
import io.atlasmap.spi.AtlasValidator;
import io.atlasmap.spi.FieldDirection;
import io.atlasmap.v2.Validation;
import io.atlasmap.v2.ValidationScope;
import io.atlasmap.v2.ValidationStatus;
import io.atlasmap.validators.NonNullValidator;
import io.atlasmap.xml.module.XmlModule;
import io.atlasmap.xml.v2.XmlField;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class XmlValidationService
extends BaseModuleValidationService<XmlField> {
    private static Map<String, AtlasValidator> validatorMap = new HashMap<String, AtlasValidator>();
    private AtlasModuleDetail moduleDetail = XmlModule.class.getAnnotation(AtlasModuleDetail.class);

    public XmlValidationService(AtlasConversionService conversionService, AtlasFieldActionService fieldActionService) {
        super(conversionService, fieldActionService);
        this.init();
    }

    public void init() {
        NonNullValidator javaFileNameNonNullValidator = new NonNullValidator(ValidationScope.MAPPING, "The name element must not be null nor empty");
        NonNullValidator javaFilePathNonNullValidator = new NonNullValidator(ValidationScope.MAPPING, "The path element must not be null nor empty");
        NonNullValidator inputFieldTypeNonNullValidator = new NonNullValidator(ValidationScope.MAPPING, "Field type should not be null nor empty");
        NonNullValidator outputFieldTypeNonNullValidator = new NonNullValidator(ValidationScope.MAPPING, "Field type should not be null nor empty");
        NonNullValidator fieldTypeNonNullValidator = new NonNullValidator(ValidationScope.MAPPING, "Filed type should not be null nor empty");
        validatorMap.put("xml.field.type.not.null", fieldTypeNonNullValidator);
        validatorMap.put("xml.field.name.not.null", javaFileNameNonNullValidator);
        validatorMap.put("xml.field.path.not.null", javaFilePathNonNullValidator);
        validatorMap.put("input.field.type.not.null", inputFieldTypeNonNullValidator);
        validatorMap.put("output.field.type.not.null", outputFieldTypeNonNullValidator);
    }

    public void destroy() {
        validatorMap.clear();
    }

    @Override
    protected AtlasModuleDetail getModuleDetail() {
        return this.moduleDetail;
    }

    @Override
    protected Class<XmlField> getFieldType() {
        return XmlField.class;
    }

    @Override
    protected String getModuleFieldName(XmlField field) {
        return field.getName() != null ? field.getName() : field.getPath();
    }

    @Override
    protected void validateModuleField(String mappingId, XmlField field, FieldDirection direction, List<Validation> validations) {
        validatorMap.get("xml.field.type.not.null").validate(field, validations, mappingId, ValidationStatus.WARN);
        if (direction == FieldDirection.SOURCE) {
            if (field != null) {
                validatorMap.get("input.field.type.not.null").validate((Object)field.getFieldType(), validations, mappingId, ValidationStatus.WARN);
            }
        } else if (field != null) {
            validatorMap.get("output.field.type.not.null").validate((Object)field.getFieldType(), validations, mappingId, ValidationStatus.WARN);
        }
        if (field != null) {
            if (field.getName() == null && field.getPath() == null) {
                Validation validation = new Validation();
                validation.setScope(ValidationScope.MAPPING);
                validation.setId(mappingId);
                validation.setMessage("One of path or name must be specified");
                validation.setStatus(ValidationStatus.ERROR);
                validations.add(validation);
            } else if (field.getName() != null && field.getPath() == null) {
                validatorMap.get("xml.field.name.not.null").validate(field.getName(), validations, mappingId);
            } else if (field.getName() == null && field.getPath() != null) {
                validatorMap.get("xml.field.path.not.null").validate(field.getPath(), validations, mappingId);
            }
        }
    }
}

