/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.xml.v2;

import io.atlasmap.v2.AtlasModelFactory;
import io.atlasmap.v2.Field;
import io.atlasmap.v2.FieldGroup;
import io.atlasmap.v2.Fields;
import io.atlasmap.xml.v2.XmlDocument;
import io.atlasmap.xml.v2.XmlField;
import java.util.ArrayList;

public class AtlasXmlModelFactory {
    public static final String URI_FORMAT = "atlas:xml";

    public static XmlDocument createXmlDocument() {
        XmlDocument xmlDocument = new XmlDocument();
        xmlDocument.setFields(new Fields());
        return xmlDocument;
    }

    public static XmlField createXmlField() {
        XmlField xmlField = new XmlField();
        return xmlField;
    }

    public static XmlField cloneField(XmlField field, boolean withActions) {
        XmlField clone = new XmlField();
        AtlasXmlModelFactory.copyField(field, clone, withActions);
        return clone;
    }

    public static FieldGroup cloneFieldGroup(FieldGroup group2) {
        FieldGroup clone = AtlasModelFactory.copyFieldGroup(group2);
        ArrayList<Field> newChildren = new ArrayList<Field>();
        for (Field child : group2.getField()) {
            if (child instanceof FieldGroup) {
                newChildren.add(AtlasXmlModelFactory.cloneFieldGroup((FieldGroup)child));
                continue;
            }
            newChildren.add(AtlasXmlModelFactory.cloneField((XmlField)child, true));
        }
        clone.getField().addAll(newChildren);
        return clone;
    }

    public static void copyField(Field from, Field to, boolean withActions) {
        AtlasModelFactory.copyField(from, to, withActions);
        if (from instanceof XmlField && to instanceof XmlField) {
            XmlField fromXml = (XmlField)from;
            XmlField toXml = (XmlField)to;
            toXml.setAnnotations(fromXml.getAnnotations());
            toXml.setName(fromXml.getName());
            toXml.setNodeType(fromXml.getNodeType());
            toXml.setPrimitive(fromXml.isPrimitive());
            toXml.setRestrictions(fromXml.getRestrictions());
            toXml.setTypeName(fromXml.getTypeName());
            toXml.setUserCreated(fromXml.isUserCreated());
        }
    }
}

