/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.atlasmap;

import io.atlasmap.api.AtlasConversionException;
import io.atlasmap.api.AtlasSession;
import io.atlasmap.api.AtlasUnsupportedException;
import io.atlasmap.core.DefaultAtlasPropertyStrategy;
import io.atlasmap.v2.PropertyField;
import java.util.HashMap;
import java.util.Map;
import org.apache.camel.Exchange;
import org.apache.camel.Message;

public class CamelAtlasPropertyStrategy
extends DefaultAtlasPropertyStrategy {
    public static final String SCOPE_EXCHANGE_PROPERTY = "camelExchangeProperty";
    public static final String SCOPE_CURRENT_MESSAGE_HEADER = "current";
    private Exchange camelExchange;
    private Map<String, Message> sourceMessageMap = new HashMap<String, Message>();
    private Message camelTargetMessage;

    @Override
    public void readProperty(AtlasSession session, PropertyField propertyField) throws AtlasUnsupportedException, AtlasConversionException {
        String scope = propertyField.getScope();
        String key = propertyField.getName();
        Map<String, Object> target = null;
        if (scope == null && this.sourceMessageMap.containsKey(SCOPE_CURRENT_MESSAGE_HEADER)) {
            target = this.sourceMessageMap.get(SCOPE_CURRENT_MESSAGE_HEADER).getHeaders();
        } else if (SCOPE_EXCHANGE_PROPERTY.equals(scope)) {
            target = this.camelExchange.getProperties();
        } else if (this.sourceMessageMap.containsKey(scope)) {
            target = this.sourceMessageMap.get(scope).getHeaders();
        }
        if (target != null && target.containsKey(key)) {
            propertyField.setValue(target.get(key));
        } else {
            super.readProperty(session, propertyField);
        }
    }

    @Override
    public void writeProperty(AtlasSession session, PropertyField propertyField) {
        String scope = propertyField.getScope();
        String key = propertyField.getName();
        Object value = propertyField.getValue();
        if (SCOPE_EXCHANGE_PROPERTY.equals(scope)) {
            this.camelExchange.setProperty(key, value);
        } else {
            this.camelTargetMessage.setHeader(key, value);
        }
    }

    public void setExchange(Exchange ex) {
        this.camelExchange = ex;
    }

    public void setSourceMessage(String documentId, Message msg) {
        this.sourceMessageMap.put(documentId, msg);
    }

    public void setCurrentSourceMessage(Message msg) {
        this.sourceMessageMap.put(SCOPE_CURRENT_MESSAGE_HEADER, msg);
    }

    public void setTargetMessage(Message msg) {
        this.camelTargetMessage = msg;
    }
}

