/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support.language;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import org.apache.camel.CamelContext;
import org.apache.camel.Expression;
import org.apache.camel.Predicate;
import org.apache.camel.spi.Language;
import org.apache.camel.support.ObjectHelper;
import org.apache.camel.support.PredicateToExpressionAdapter;
import org.apache.camel.support.language.AnnotationExpressionFactory;
import org.apache.camel.support.language.LanguageAnnotation;

public class DefaultAnnotationExpressionFactory
implements AnnotationExpressionFactory {
    @Override
    public Expression createExpression(CamelContext camelContext, Annotation annotation2, LanguageAnnotation languageAnnotation, Class<?> expressionReturnType) {
        String languageName = languageAnnotation.language();
        Language language = camelContext.resolveLanguage(languageName);
        if (language == null) {
            throw new IllegalArgumentException("Cannot find the language: " + languageName + " on the classpath");
        }
        String expression = this.getExpressionFromAnnotation(annotation2);
        if (expressionReturnType == Boolean.class || expressionReturnType == Boolean.TYPE) {
            Predicate predicate = language.createPredicate(expression);
            return PredicateToExpressionAdapter.toExpression(predicate);
        }
        return language.createExpression(expression);
    }

    protected String getExpressionFromAnnotation(Annotation annotation2) {
        Object value = this.getAnnotationObjectValue(annotation2, "value");
        if (value == null) {
            throw new IllegalArgumentException("Cannot determine the expression from the annotation: " + annotation2);
        }
        return value.toString();
    }

    protected Object getAnnotationObjectValue(Annotation annotation2, String methodName) {
        try {
            Method method = annotation2.annotationType().getDeclaredMethod(methodName, new Class[0]);
            Object value = ObjectHelper.invokeMethod(method, annotation2, new Object[0]);
            return value;
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("Cannot determine the Object value of the annotation: " + annotation2 + " as it does not have the method: " + methodName + "() method", e);
        }
    }
}

