/*
 * Decompiled with CFR 0.152.
 */
package com.emc.atmos.api.bean;

import java.util.Date;
import java.util.List;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

@XmlRootElement(namespace="", name="policy")
@XmlType(propOrder={"expiration", "maxUploads", "maxDownloads", "source", "contentLengthRange", "formFieldList"})
public class AccessTokenPolicy {
    private Date expiration;
    private Source source;
    private int maxUploads;
    private int maxDownloads;
    private ContentLengthRange contentLengthRange;
    private List<FormField> formFieldList;

    @XmlElement(namespace="")
    public Date getExpiration() {
        return this.expiration;
    }

    @XmlElement(namespace="")
    public Source getSource() {
        return this.source;
    }

    @XmlElement(namespace="", name="max-uploads")
    public int getMaxUploads() {
        return this.maxUploads;
    }

    @XmlElement(namespace="", name="max-downloads")
    public int getMaxDownloads() {
        return this.maxDownloads;
    }

    @XmlElement(namespace="", name="content-length-range")
    public ContentLengthRange getContentLengthRange() {
        return this.contentLengthRange;
    }

    @XmlElement(namespace="", name="form-field")
    public List<FormField> getFormFieldList() {
        return this.formFieldList;
    }

    public void setExpiration(Date expiration) {
        long millis = expiration.getTime() % 1000L;
        this.expiration = new Date(expiration.getTime() - millis);
    }

    public void setSource(Source source) {
        this.source = source;
    }

    public void setMaxUploads(int maxUploads) {
        this.maxUploads = maxUploads;
    }

    public void setMaxDownloads(int maxDownloads) {
        this.maxDownloads = maxDownloads;
    }

    public void setContentLengthRange(ContentLengthRange contentLengthRange) {
        this.contentLengthRange = contentLengthRange;
    }

    public void setFormFieldList(List<FormField> formFieldList) {
        this.formFieldList = formFieldList;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AccessTokenPolicy)) {
            return false;
        }
        AccessTokenPolicy that = (AccessTokenPolicy)o;
        if (this.maxDownloads != that.maxDownloads) {
            return false;
        }
        if (this.maxUploads != that.maxUploads) {
            return false;
        }
        if (this.contentLengthRange != null ? !this.contentLengthRange.equals(that.contentLengthRange) : that.contentLengthRange != null) {
            return false;
        }
        if (this.expiration != null ? !this.expiration.equals(that.expiration) : that.expiration != null) {
            return false;
        }
        if (this.formFieldList != null ? !this.formFieldList.equals(that.formFieldList) : that.formFieldList != null) {
            return false;
        }
        return !(this.source != null ? !this.source.equals(that.source) : that.source != null);
    }

    public int hashCode() {
        int result = this.expiration != null ? this.expiration.hashCode() : 0;
        result = 31 * result + (this.source != null ? this.source.hashCode() : 0);
        result = 31 * result + this.maxUploads;
        result = 31 * result + this.maxDownloads;
        result = 31 * result + (this.contentLengthRange != null ? this.contentLengthRange.hashCode() : 0);
        result = 31 * result + (this.formFieldList != null ? this.formFieldList.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "AccessTokenPolicy{expiration=" + this.expiration + ", source=" + this.source + ", maxUploads=" + this.maxUploads + ", maxDownloads=" + this.maxDownloads + ", contentLengthRange=" + this.contentLengthRange + ", formFieldList=" + this.formFieldList + '}';
    }

    public static class FormField {
        private String name;
        private boolean optional;
        private String eq;
        private String startsWith;
        private String endsWith;
        private String contains;
        private String matches;

        @XmlAttribute
        public String getName() {
            return this.name;
        }

        @XmlAttribute
        public boolean isOptional() {
            return this.optional;
        }

        @XmlElement(namespace="")
        public String getEq() {
            return this.eq;
        }

        @XmlElement(namespace="", name="starts-with")
        public String getStartsWith() {
            return this.startsWith;
        }

        @XmlElement(namespace="", name="ends-with")
        public String getEndsWith() {
            return this.endsWith;
        }

        @XmlElement(namespace="")
        public String getContains() {
            return this.contains;
        }

        @XmlElement(namespace="")
        public String getMatches() {
            return this.matches;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setOptional(boolean optional) {
            this.optional = optional;
        }

        public void setEq(String eq) {
            this.eq = eq;
        }

        public void setStartsWith(String startsWith) {
            this.startsWith = startsWith;
        }

        public void setEndsWith(String endsWith) {
            this.endsWith = endsWith;
        }

        public void setContains(String contains) {
            this.contains = contains;
        }

        public void setMatches(String matches) {
            this.matches = matches;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FormField formField = (FormField)o;
            if (this.optional != formField.optional) {
                return false;
            }
            if (this.contains != null ? !this.contains.equals(formField.contains) : formField.contains != null) {
                return false;
            }
            if (this.endsWith != null ? !this.endsWith.equals(formField.endsWith) : formField.endsWith != null) {
                return false;
            }
            if (this.eq != null ? !this.eq.equals(formField.eq) : formField.eq != null) {
                return false;
            }
            if (this.matches != null ? !this.matches.equals(formField.matches) : formField.matches != null) {
                return false;
            }
            if (!this.name.equals(formField.name)) {
                return false;
            }
            return !(this.startsWith != null ? !this.startsWith.equals(formField.startsWith) : formField.startsWith != null);
        }

        public int hashCode() {
            int result = this.name.hashCode();
            result = 31 * result + (this.optional ? 1 : 0);
            result = 31 * result + (this.eq != null ? this.eq.hashCode() : 0);
            result = 31 * result + (this.startsWith != null ? this.startsWith.hashCode() : 0);
            result = 31 * result + (this.endsWith != null ? this.endsWith.hashCode() : 0);
            result = 31 * result + (this.contains != null ? this.contains.hashCode() : 0);
            result = 31 * result + (this.matches != null ? this.matches.hashCode() : 0);
            return result;
        }

        public String toString() {
            return "FormField{name='" + this.name + '\'' + ", optional=" + this.optional + ", eq='" + this.eq + '\'' + ", startsWith='" + this.startsWith + '\'' + ", endsWith='" + this.endsWith + '\'' + ", contains='" + this.contains + '\'' + ", matches='" + this.matches + '\'' + '}';
        }
    }

    public static class ContentLengthRange {
        private int from;
        private int to;

        @XmlAttribute
        public int getFrom() {
            return this.from;
        }

        @XmlAttribute
        public int getTo() {
            return this.to;
        }

        public void setFrom(int from) {
            this.from = from;
        }

        public void setTo(int to) {
            this.to = to;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ContentLengthRange that = (ContentLengthRange)o;
            if (this.from != that.from) {
                return false;
            }
            return this.to == that.to;
        }

        public int hashCode() {
            int result = this.from;
            result = 31 * result + this.to;
            return result;
        }

        public String toString() {
            return "ContentLengthRange{from=" + this.from + ", to=" + this.to + '}';
        }
    }

    public static class Source {
        private List<String> allowList;
        private List<String> denyList;

        @XmlElement(namespace="", name="allow")
        public List<String> getAllowList() {
            return this.allowList;
        }

        @XmlElement(namespace="", name="disallow")
        public List<String> getDenyList() {
            return this.denyList;
        }

        public void setAllowList(List<String> allowList) {
            this.allowList = allowList;
        }

        public void setDenyList(List<String> denyList) {
            this.denyList = denyList;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Source source = (Source)o;
            if (this.allowList != null ? !this.allowList.equals(source.allowList) : source.allowList != null) {
                return false;
            }
            return !(this.denyList != null ? !this.denyList.equals(source.denyList) : source.denyList != null);
        }

        public int hashCode() {
            int result = this.allowList != null ? this.allowList.hashCode() : 0;
            result = 31 * result + (this.denyList != null ? this.denyList.hashCode() : 0);
            return result;
        }

        public String toString() {
            return "Source{allowList=" + this.allowList + ", denyList=" + this.denyList + '}';
        }
    }
}

