/*
 * Decompiled with CFR 0.152.
 */
package com.emc.atmos.api.bean;

import com.emc.atmos.api.Acl;
import com.emc.atmos.api.ChecksumValue;
import com.emc.atmos.api.ChecksumValueImpl;
import com.emc.atmos.api.RestUtil;
import com.emc.atmos.api.bean.BasicResponse;
import com.emc.atmos.api.bean.Metadata;
import com.emc.atmos.api.bean.ObjectMetadata;
import java.util.TreeMap;

public class ReadObjectResponse<T>
extends BasicResponse {
    private T object;
    private ObjectMetadata metadata;

    public ReadObjectResponse() {
    }

    public ReadObjectResponse(T object) {
        this.object = object;
    }

    public T getObject() {
        return this.object;
    }

    public void setObject(T object) {
        this.object = object;
    }

    public synchronized ObjectMetadata getMetadata() {
        if (this.metadata == null) {
            Acl acl = new Acl(RestUtil.parseAclHeader(this.getFirstHeader("x-emc-useracl")), RestUtil.parseAclHeader(this.getFirstHeader("x-emc-groupacl")));
            TreeMap<String, Metadata> metaMap = new TreeMap<String, Metadata>();
            metaMap.putAll(RestUtil.parseMetadataHeader(this.getFirstHeader("x-emc-meta"), false));
            metaMap.putAll(RestUtil.parseMetadataHeader(this.getFirstHeader("x-emc-listable-meta"), true));
            String wsChecksumHeader = this.getFirstHeader("x-emc-wschecksum");
            ChecksumValueImpl wsChecksum = wsChecksumHeader == null ? null : new ChecksumValueImpl(wsChecksumHeader);
            String serverChecksumHeader = this.getFirstHeader("x-emc-content-checksum");
            ChecksumValueImpl serverChecksum = serverChecksumHeader == null ? null : new ChecksumValueImpl(this.getFirstHeader("x-emc-content-checksum"));
            this.metadata = new ObjectMetadata(metaMap, acl, this.getContentType(), wsChecksum, serverChecksum);
        }
        return this.metadata;
    }

    public ChecksumValue getWsChecksum() {
        return this.getMetadata().getWsChecksum();
    }

    public ChecksumValue getServerGeneratedChecksum() {
        return this.getMetadata().getServerChecksum();
    }
}

