/*
 * Decompiled with CFR 0.152.
 */
package com.emc.atmos.api.encryption;

import com.emc.atmos.AtmosException;
import com.emc.atmos.api.Acl;
import com.emc.atmos.api.AtmosApi;
import com.emc.atmos.api.BufferSegment;
import com.emc.atmos.api.ObjectId;
import com.emc.atmos.api.ObjectIdentifier;
import com.emc.atmos.api.ObjectPath;
import com.emc.atmos.api.Range;
import com.emc.atmos.api.bean.BasicResponse;
import com.emc.atmos.api.bean.CreateAccessTokenResponse;
import com.emc.atmos.api.bean.CreateObjectResponse;
import com.emc.atmos.api.bean.GenericResponse;
import com.emc.atmos.api.bean.GetAccessTokenResponse;
import com.emc.atmos.api.bean.ListAccessTokensResponse;
import com.emc.atmos.api.bean.ListDirectoryResponse;
import com.emc.atmos.api.bean.ListObjectsResponse;
import com.emc.atmos.api.bean.ListVersionsResponse;
import com.emc.atmos.api.bean.Metadata;
import com.emc.atmos.api.bean.ObjectInfo;
import com.emc.atmos.api.bean.ObjectMetadata;
import com.emc.atmos.api.bean.ReadObjectResponse;
import com.emc.atmos.api.bean.ServiceInformation;
import com.emc.atmos.api.encryption.CompressionConfig;
import com.emc.atmos.api.encryption.EncryptionConfig;
import com.emc.atmos.api.request.CreateAccessTokenRequest;
import com.emc.atmos.api.request.CreateObjectRequest;
import com.emc.atmos.api.request.CreateSubtenantRequest;
import com.emc.atmos.api.request.ListAccessTokensRequest;
import com.emc.atmos.api.request.ListDirectoryRequest;
import com.emc.atmos.api.request.ListObjectsRequest;
import com.emc.atmos.api.request.ListVersionsRequest;
import com.emc.atmos.api.request.PreSignedRequest;
import com.emc.atmos.api.request.ReadObjectRequest;
import com.emc.atmos.api.request.Request;
import com.emc.atmos.api.request.UpdateObjectRequest;
import com.emc.vipr.transform.InputTransform;
import com.emc.vipr.transform.OutputTransform;
import com.emc.vipr.transform.TransformException;
import com.emc.vipr.transform.TransformFactory;
import com.emc.vipr.transform.encryption.DoesNotNeedRekeyException;
import com.emc.vipr.transform.encryption.EncryptionTransformFactory;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class AtmosEncryptionClient
implements AtmosApi {
    private static final String UNSUPPORTED_MSG = "This operation is not supported by the encryption client";
    private static final String PARTIAL_UPDATE_MSG = "Partial object updates and/or appends are not supported by the encryption client";
    private static final String PARTIAL_READ_MSG = "Partial object reads are not supported by the encryption client";
    private static final String UNSUPPORTED_TYPE_MSG = "Only InputStream, String, and byte[] content are supported";
    private static final int DEFAULT_BUFFER_SIZE = 0x400000;
    private AtmosApi delegate;
    private TreeSet<TransformFactory<?, ?>> factories;
    private int bufferSize = 0x400000;

    public AtmosEncryptionClient(AtmosApi delegate, EncryptionConfig encryptionConfig, CompressionConfig compressionConfig) {
        this.delegate = delegate;
        this.factories = new TreeSet();
        if (encryptionConfig != null) {
            this.factories.add(encryptionConfig.getFactory());
        }
        if (compressionConfig != null) {
            this.factories.add(compressionConfig.getFactory());
        }
    }

    public AtmosEncryptionClient(AtmosApi delegate, Collection<TransformFactory<OutputTransform, InputTransform>> transformations) {
        this.delegate = delegate;
        this.factories = new TreeSet();
        for (TransformFactory<OutputTransform, InputTransform> f : transformations) {
            this.factories.add(f);
        }
    }

    public void rekey(ObjectIdentifier identifier) throws DoesNotNeedRekeyException {
        Map<String, Metadata> umeta = this.delegate.getUserMetadata(identifier, null);
        Map<String, String> rawMeta = this.metaToMap(umeta.values());
        String transformModes = rawMeta.get("x-emc-transform-mode");
        if (transformModes == null) {
            throw new DoesNotNeedRekeyException("Object is not encrypted");
        }
        String[] modes = transformModes.split("\\|");
        ArrayList<String> revModes = new ArrayList<String>();
        revModes.addAll(Arrays.asList(modes));
        Collections.reverse(revModes);
        boolean rekeyed = false;
        for (String mode : revModes) {
            if (!mode.startsWith("ENC")) continue;
            boolean found = false;
            for (TransformFactory<?, ?> f : this.factories) {
                if (!(f instanceof EncryptionTransformFactory) || !f.canDecode(mode, rawMeta)) continue;
                EncryptionTransformFactory ef = (EncryptionTransformFactory)f;
                try {
                    rawMeta = ef.rekey(rawMeta);
                    rekeyed = true;
                }
                catch (DoesNotNeedRekeyException e) {
                    throw e;
                }
                catch (TransformException e) {
                    throw new AtmosException("Error rekeying object: " + e, e);
                }
                found = true;
                break;
            }
            if (found) continue;
            throw new AtmosException("No transformation found to handle '" + mode + "'");
        }
        if (!rekeyed) {
            throw new DoesNotNeedRekeyException("Object was not rekeyed");
        }
        Collection<Metadata> updatedMeta = this.updateMetadata(rawMeta, umeta.values());
        this.delegate.setUserMetadata(identifier, updatedMeta.toArray(new Metadata[updatedMeta.size()]));
    }

    @Override
    public ServiceInformation getServiceInformation() {
        return this.delegate.getServiceInformation();
    }

    @Override
    public long calculateServerClockSkew() {
        return this.delegate.calculateServerClockSkew();
    }

    @Override
    public ObjectId createObject(Object content, String contentType) {
        CreateObjectRequest req = new CreateObjectRequest();
        req.setContent(content);
        req.setContentType(contentType);
        CreateObjectResponse res = this.createObject(req);
        return res.getObjectId();
    }

    @Override
    public ObjectId createObject(ObjectIdentifier identifier, Object content, String contentType) {
        CreateObjectRequest req = new CreateObjectRequest();
        req.setIdentifier(identifier);
        req.setContent(content);
        req.setContentType(contentType);
        CreateObjectResponse res = this.createObject(req);
        return res.getObjectId();
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public CreateObjectResponse createObject(CreateObjectRequest request) {
        void var3_7;
        InputStream in = null;
        if (request.getContent() != null) {
            Object object = request.getContent();
            if (object instanceof InputStream) {
                in = (InputStream)object;
            } else if (object instanceof String) {
                in = new ByteArrayInputStream(((String)object).getBytes());
            } else {
                if (!(object instanceof byte[])) throw new IllegalArgumentException(UNSUPPORTED_TYPE_MSG);
                in = new ByteArrayInputStream((byte[])object);
            }
        } else {
            in = new ByteArrayInputStream(new byte[0]);
        }
        Object var3_4 = null;
        if (request.getUserMetadata() != null) {
            Map<String, String> map = this.metaToMap(request.getUserMetadata());
        } else {
            HashMap hashMap = new HashMap();
        }
        ArrayList appliedTransforms = new ArrayList();
        ArrayList revFactories = new ArrayList();
        revFactories.addAll(this.factories);
        Collections.reverse(revFactories);
        try {
            for (TransformFactory transformFactory : revFactories) {
                Object ot = transformFactory.getOutputTransform(in, (Map<String, String>)var3_7);
                appliedTransforms.add(ot);
                in = ((OutputTransform)ot).getEncodedInputStream();
            }
        }
        catch (TransformException e) {
            throw new AtmosException("Could not transform data: " + e, e);
        }
        catch (IOException e) {
            throw new AtmosException("Error transforming data: " + e, e);
        }
        int c = 0;
        boolean bl = false;
        byte[] buffer = new byte[this.bufferSize];
        try {
            c = this.fillBuffer(buffer, in);
        }
        catch (IOException e) {
            throw new AtmosException("Error reading input data: " + e, e);
        }
        if (c == -1) {
            request.setContent(null);
            try {
                in.close();
            }
            catch (IOException e) {
                throw new AtmosException("Error closing input: " + e, e);
            }
            for (OutputTransform ot : appliedTransforms) {
                var3_7.putAll(ot.getEncodedMetadata());
            }
            Set<Metadata> metadata = request.getUserMetadata();
            if (metadata == null) {
                metadata = new HashSet<Metadata>();
            }
            this.updateMetadata((Map<String, String>)var3_7, metadata);
            request.setUserMetadata(metadata);
            return this.delegate.createObject(request);
        }
        request.setContent(new BufferSegment(buffer, 0, c));
        CreateObjectResponse resp = this.delegate.createObject(request);
        int n = c;
        try {
            while ((c = this.fillBuffer(buffer, in)) != -1) {
                void var7_17;
                UpdateObjectRequest uor = new UpdateObjectRequest();
                uor.setIdentifier(resp.getObjectId());
                uor.setContentType(request.getContentType());
                uor.setRange(new Range((long)var7_17, (long)(var7_17 + c - true)));
                uor.setContent(new BufferSegment(buffer, 0, c));
                var7_17 += c;
                this.delegate.updateObject(uor);
            }
        }
        catch (IOException e) {
            throw new AtmosException("Error reading input data: " + e, e);
        }
        try {
            in.close();
        }
        catch (IOException e) {
            throw new AtmosException("Error closing stream: " + e, e);
        }
        String transformConfig = "";
        for (OutputTransform ot : appliedTransforms) {
            var3_7.putAll(ot.getEncodedMetadata());
            if (transformConfig.length() != 0) {
                transformConfig = transformConfig + "|";
            }
            transformConfig = transformConfig + ot.getTransformConfig();
        }
        var3_7.put("x-emc-transform-mode", transformConfig);
        Set<Metadata> metadata = request.getUserMetadata();
        if (metadata == null) {
            metadata = new HashSet<Metadata>();
        }
        Collection<Metadata> updatedMetadata = this.updateMetadata((Map<String, String>)var3_7, metadata);
        this.delegate.setUserMetadata(resp.getObjectId(), updatedMetadata.toArray(new Metadata[updatedMetadata.size()]));
        return resp;
    }

    private int fillBuffer(byte[] buffer, InputStream in) throws IOException {
        int read;
        int c;
        for (read = 0; read < buffer.length; read += c) {
            c = in.read(buffer, read, buffer.length - read);
            if (c == -1 && read == 0) {
                return -1;
            }
            if (c != -1) continue;
            return read;
        }
        return read;
    }

    private Map<String, String> metaToMap(Collection<Metadata> userMetadata) {
        HashMap<String, String> meta = new HashMap<String, String>();
        for (Metadata m : userMetadata) {
            meta.put(m.getName(), m.getValue());
        }
        return meta;
    }

    private Collection<Metadata> updateMetadata(Map<String, String> meta, Collection<Metadata> collection) {
        HashMap<String, Metadata> updatedMetadata = new HashMap<String, Metadata>();
        for (Metadata m : collection) {
            updatedMetadata.put(m.getName(), m);
        }
        Iterator<Object> i$ = meta.keySet().iterator();
        while (i$.hasNext()) {
            Metadata m;
            String key;
            updatedMetadata.put(key, new Metadata(key, meta.get(key), (m = (Metadata)updatedMetadata.get(key = (String)i$.next())) == null ? false : m.isListable()));
        }
        return updatedMetadata.values();
    }

    @Override
    public <T> T readObject(ObjectIdentifier identifier, Class<T> objectType) throws IOException {
        return this.readObject((ReadObjectRequest)new ReadObjectRequest().identifier(identifier), objectType).getObject();
    }

    @Override
    public <T> T readObject(ObjectIdentifier identifier, Range range, Class<T> objectType) throws IOException {
        return this.readObject(((ReadObjectRequest)new ReadObjectRequest().identifier(identifier)).ranges(range), objectType).getObject();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> ReadObjectResponse<T> readObject(ReadObjectRequest request, Class<T> objectType) throws IOException {
        ReadObjectResponse<T> readObjectResponse;
        String transformModes;
        Map<String, String> rawMeta;
        ReadObjectResponse<InputStream> rawResponse;
        block9: {
            if (request.getRanges() != null && request.getRanges().size() > 0) {
                throw new UnsupportedOperationException(PARTIAL_READ_MSG);
            }
            HashSet<Class> validTypes = new HashSet<Class>(Arrays.asList(String.class, byte[].class, InputStream.class));
            if (!validTypes.contains(objectType)) {
                throw new IllegalArgumentException(UNSUPPORTED_TYPE_MSG);
            }
            rawResponse = null;
            rawResponse = this.delegate.readObjectStream(request.getIdentifier(), null);
            rawMeta = this.metaToMap(rawResponse.getMetadata().getMetadata().values());
            transformModes = rawMeta.get("x-emc-transform-mode");
            if (transformModes != null) break block9;
            ReadObjectResponse<T> readObjectResponse2 = this.rewrap(rawResponse, objectType);
            rawResponse.getObject().close();
            return readObjectResponse2;
        }
        try {
            String[] modes = transformModes.split("\\|");
            ArrayList<String> revModes = new ArrayList<String>();
            revModes.addAll(Arrays.asList(modes));
            Collections.reverse(revModes);
            InputStream streamToDecode = rawResponse.getObject();
            for (String mode : revModes) {
                boolean found = false;
                for (TransformFactory<?, ?> f : this.factories) {
                    if (!f.canDecode(mode, rawMeta)) continue;
                    try {
                        Object trans = f.getInputTransform(mode, streamToDecode, rawMeta);
                        streamToDecode = ((InputTransform)trans).getDecodedInputStream();
                        rawMeta = ((InputTransform)trans).getDecodedMetadata();
                        found = true;
                    }
                    catch (TransformException e) {
                        throw new AtmosException("Error transforming object data: " + e, e);
                    }
                }
                if (found) continue;
                throw new AtmosException("No transformation found to handle '" + mode + "'");
            }
            rawResponse.setObject(streamToDecode);
            this.updateMetadata(rawMeta, rawResponse.getMetadata().getMetadata().values());
            readObjectResponse = this.rewrap(rawResponse, objectType);
        }
        catch (Throwable throwable) {
            ((InputStream)rawResponse.getObject()).close();
            throw throwable;
        }
        rawResponse.getObject().close();
        return readObjectResponse;
    }

    private <T> ReadObjectResponse<T> rewrap(ReadObjectResponse<InputStream> rawResponse, Class<T> objectType) throws IOException {
        ReadObjectResponse<Object> wrapped = null;
        if (InputStream.class.equals(objectType)) {
            return rawResponse;
        }
        if (byte[].class.equals(objectType) || String.class.equals(objectType)) {
            InputStream in = rawResponse.getObject();
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            byte[] buffer = new byte[4096];
            int c = 0;
            while ((c = in.read(buffer)) != -1) {
                out.write(buffer, 0, c);
            }
            in.close();
            out.close();
            if (byte[].class.equals(objectType)) {
                wrapped = new ReadObjectResponse<Object>();
                wrapped.setObject(out.toByteArray());
            } else {
                wrapped = new ReadObjectResponse();
                wrapped.setObject(new String(out.toByteArray()));
            }
        } else {
            throw new IllegalArgumentException(UNSUPPORTED_TYPE_MSG);
        }
        wrapped.setContentLength(rawResponse.getContentLength());
        wrapped.setContentType(rawResponse.getContentType());
        wrapped.setDate(rawResponse.getDate());
        wrapped.setHeaders(rawResponse.getHeaders());
        wrapped.setHttpMessage(rawResponse.getHttpMessage());
        wrapped.setHttpStatus(rawResponse.getHttpStatus());
        wrapped.setLastModified(rawResponse.getLastModified());
        wrapped.setLocation(rawResponse.getLocation());
        return wrapped;
    }

    @Override
    public ReadObjectResponse<InputStream> readObjectStream(ObjectIdentifier identifier, Range range) {
        if (range != null) {
            throw new UnsupportedOperationException(UNSUPPORTED_MSG);
        }
        ReadObjectRequest request = (ReadObjectRequest)new ReadObjectRequest().identifier(identifier);
        try {
            return this.readObject(request, InputStream.class);
        }
        catch (IOException e) {
            throw new AtmosException("Error getting response stream: " + e, e);
        }
    }

    @Override
    public void updateObject(ObjectIdentifier identifier, Object content) {
        UpdateObjectRequest uor = (UpdateObjectRequest)((UpdateObjectRequest)new UpdateObjectRequest().identifier(identifier)).content(content);
        this.updateObject(uor);
    }

    @Override
    public void updateObject(ObjectIdentifier identifier, Object content, Range range) {
        UpdateObjectRequest uor = ((UpdateObjectRequest)((UpdateObjectRequest)new UpdateObjectRequest().identifier(identifier)).content(content)).range(range);
        this.updateObject(uor);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public BasicResponse updateObject(UpdateObjectRequest request) {
        void var5_9;
        if (request.getRange() != null) {
            throw new UnsupportedOperationException(PARTIAL_UPDATE_MSG);
        }
        InputStream in = null;
        if (request.getContent() != null) {
            Object content = request.getContent();
            if (content instanceof InputStream) {
                in = (InputStream)content;
            } else if (content instanceof String) {
                in = new ByteArrayInputStream(((String)content).getBytes());
            } else {
                if (!(content instanceof byte[])) throw new IllegalArgumentException(UNSUPPORTED_TYPE_MSG);
                in = new ByteArrayInputStream((byte[])content);
            }
        } else {
            in = new ByteArrayInputStream(new byte[0]);
        }
        Map<String, Boolean> metaNameMap = this.delegate.getUserMetadataNames(request.getIdentifier());
        HashSet<String> metaNames = new HashSet<String>();
        metaNames.addAll(metaNameMap.keySet());
        Iterator iterator = metaNames.iterator();
        while (iterator.hasNext()) {
            String s = (String)iterator.next();
            if (s.startsWith("x-emc-")) continue;
            iterator.remove();
        }
        Object var5_6 = null;
        if (request.getUserMetadata() != null) {
            Map<String, String> map = this.metaToMap(request.getUserMetadata());
        } else {
            HashMap hashMap = new HashMap();
        }
        ArrayList appliedTransforms = new ArrayList();
        ArrayList revFactories = new ArrayList();
        revFactories.addAll(this.factories);
        Collections.reverse(revFactories);
        try {
            for (TransformFactory transformFactory : revFactories) {
                Object ot = transformFactory.getOutputTransform(in, (Map<String, String>)var5_9);
                appliedTransforms.add(ot);
                in = ((OutputTransform)ot).getEncodedInputStream();
            }
        }
        catch (TransformException e) {
            throw new AtmosException("Could not transform data: " + e, e);
        }
        catch (IOException e) {
            throw new AtmosException("Error transforming data: " + e, e);
        }
        int c = 0;
        boolean bl = false;
        byte[] buffer = new byte[this.bufferSize];
        try {
            c = this.fillBuffer(buffer, in);
        }
        catch (IOException e) {
            throw new AtmosException("Error reading input data: " + e, e);
        }
        if (c == -1) {
            request.setContent(null);
            try {
                in.close();
            }
            catch (IOException e) {
                throw new AtmosException("Error closing input: " + e, e);
            }
            for (OutputTransform ot : appliedTransforms) {
                var5_9.putAll(ot.getEncodedMetadata());
            }
            Set<Metadata> metadata = request.getUserMetadata();
            if (metadata == null) {
                metadata = new HashSet<Metadata>();
            }
            this.updateMetadata((Map<String, String>)var5_9, metadata);
            request.setUserMetadata(metadata);
            return this.delegate.updateObject(request);
        }
        request.setContent(new BufferSegment(buffer, 0, c));
        BasicResponse resp = this.delegate.updateObject(request);
        int n = c;
        try {
            while ((c = this.fillBuffer(buffer, in)) != -1) {
                void var9_19;
                UpdateObjectRequest uor = new UpdateObjectRequest();
                uor.setIdentifier(request.getIdentifier());
                uor.setContentType(request.getContentType());
                uor.setRange(new Range((long)var9_19, (long)(var9_19 + c - true)));
                uor.setContent(new BufferSegment(buffer, 0, c));
                var9_19 += c;
                this.delegate.updateObject(uor);
            }
        }
        catch (IOException e) {
            throw new AtmosException("Error reading input data: " + e, e);
        }
        try {
            in.close();
        }
        catch (IOException e) {
            throw new AtmosException("Error closing stream: " + e, e);
        }
        String transformConfig = "";
        for (OutputTransform ot : appliedTransforms) {
            var5_9.putAll(ot.getEncodedMetadata());
            if (transformConfig.length() != 0) {
                transformConfig = transformConfig + "|";
            }
            transformConfig = transformConfig + ot.getTransformConfig();
        }
        var5_9.put("x-emc-transform-mode", transformConfig);
        Set<Metadata> metadata = request.getUserMetadata();
        if (metadata == null) {
            metadata = new HashSet<Metadata>();
        }
        Collection<Metadata> updatedMetadata = this.updateMetadata((Map<String, String>)var5_9, metadata);
        this.delegate.setUserMetadata(request.getIdentifier(), updatedMetadata.toArray(new Metadata[updatedMetadata.size()]));
        metaNames.removeAll(var5_9.keySet());
        if (metaNames.size() <= 0) return resp;
        this.delegate.deleteUserMetadata(request.getIdentifier(), metaNames.toArray(new String[metaNames.size()]));
        return resp;
    }

    @Override
    public void delete(ObjectIdentifier identifier) {
        this.delegate.delete(identifier);
    }

    @Override
    public ObjectId createDirectory(ObjectPath path) {
        return this.delegate.createDirectory(path);
    }

    @Override
    public ObjectId createDirectory(ObjectPath path, Acl acl, Metadata ... metadata) {
        return this.delegate.createDirectory(path, acl, metadata);
    }

    @Override
    public ListDirectoryResponse listDirectory(ListDirectoryRequest request) {
        return this.delegate.listDirectory(request);
    }

    @Override
    public void move(ObjectPath oldPath, ObjectPath newPath, boolean overwrite) {
        this.delegate.move(oldPath, newPath, overwrite);
    }

    @Override
    public Map<String, Boolean> getUserMetadataNames(ObjectIdentifier identifier) {
        return this.delegate.getUserMetadataNames(identifier);
    }

    @Override
    public Map<String, Metadata> getUserMetadata(ObjectIdentifier identifier, String ... metadataNames) {
        return this.getUserMetadata(identifier, metadataNames);
    }

    @Override
    public Map<String, Metadata> getSystemMetadata(ObjectIdentifier identifier, String ... metadataNames) {
        return this.delegate.getSystemMetadata(identifier, metadataNames);
    }

    @Override
    public boolean objectExists(ObjectIdentifier identifier) {
        return this.delegate.objectExists(identifier);
    }

    @Override
    public ObjectMetadata getObjectMetadata(ObjectIdentifier identifier) {
        return this.delegate.getObjectMetadata(identifier);
    }

    @Override
    public void setUserMetadata(ObjectIdentifier identifier, Metadata ... metadata) {
        this.delegate.setUserMetadata(identifier, metadata);
    }

    @Override
    public void deleteUserMetadata(ObjectIdentifier identifier, String ... names) {
        this.delegate.deleteUserMetadata(identifier, names);
    }

    @Override
    public Set<String> listMetadata(String metadataName) {
        return this.delegate.listMetadata(metadataName);
    }

    @Override
    public ListObjectsResponse listObjects(ListObjectsRequest request) {
        return this.delegate.listObjects(request);
    }

    @Override
    public Acl getAcl(ObjectIdentifier identifier) {
        return this.delegate.getAcl(identifier);
    }

    @Override
    public void setAcl(ObjectIdentifier identifier, Acl acl) {
        this.delegate.setAcl(identifier, acl);
    }

    @Override
    public ObjectInfo getObjectInfo(ObjectIdentifier identifier) {
        return this.delegate.getObjectInfo(identifier);
    }

    @Override
    public ObjectId createVersion(ObjectIdentifier identifier) {
        return this.delegate.createVersion(identifier);
    }

    @Override
    public ListVersionsResponse listVersions(ListVersionsRequest request) {
        return this.delegate.listVersions(request);
    }

    @Override
    public void restoreVersion(ObjectId objectId, ObjectId versionId) {
        this.delegate.restoreVersion(objectId, versionId);
    }

    @Override
    public void deleteVersion(ObjectId versionId) {
        this.delegate.deleteVersion(versionId);
    }

    @Override
    public URL getShareableUrl(ObjectIdentifier identifier, Date expirationDate) throws MalformedURLException {
        throw new UnsupportedOperationException(UNSUPPORTED_MSG);
    }

    @Override
    public URL getShareableUrl(ObjectIdentifier identifier, Date expirationDate, String disposition) throws MalformedURLException {
        throw new UnsupportedOperationException(UNSUPPORTED_MSG);
    }

    @Override
    public CreateAccessTokenResponse createAccessToken(CreateAccessTokenRequest request) throws MalformedURLException {
        throw new UnsupportedOperationException(UNSUPPORTED_MSG);
    }

    @Override
    public GetAccessTokenResponse getAccessToken(URL url) {
        throw new UnsupportedOperationException(UNSUPPORTED_MSG);
    }

    @Override
    public GetAccessTokenResponse getAccessToken(String accessTokenId) {
        throw new UnsupportedOperationException(UNSUPPORTED_MSG);
    }

    @Override
    public void deleteAccessToken(URL url) {
        throw new UnsupportedOperationException(UNSUPPORTED_MSG);
    }

    @Override
    public void deleteAccessToken(String accessTokenId) {
        throw new UnsupportedOperationException(UNSUPPORTED_MSG);
    }

    @Override
    public ListAccessTokensResponse listAccessTokens(ListAccessTokensRequest request) {
        throw new UnsupportedOperationException(UNSUPPORTED_MSG);
    }

    @Override
    public PreSignedRequest preSignRequest(Request request, Date expiration) throws MalformedURLException {
        throw new UnsupportedOperationException(UNSUPPORTED_MSG);
    }

    @Override
    public <T> GenericResponse<T> execute(PreSignedRequest request, Class<T> resultType, Object content) throws URISyntaxException {
        throw new UnsupportedOperationException(UNSUPPORTED_MSG);
    }

    @Override
    public String createSubtenant(CreateSubtenantRequest request) {
        return this.delegate.createSubtenant(request);
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public void setBufferSize(int bufferSize) {
        this.bufferSize = bufferSize;
    }
}

