/*
 * Decompiled with CFR 0.152.
 */
package com.emc.atmos.mgmt.api.jersey;

import com.emc.acdp.AcdpException;
import com.emc.atmos.api.jersey.ErrorFilter;
import com.emc.atmos.mgmt.AtmosMgmtConfig;
import com.emc.atmos.mgmt.api.jersey.AuthFilter;
import com.emc.util.SslUtil;
import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.config.DefaultClientConfig;
import com.sun.jersey.client.urlconnection.HTTPSProperties;

public class JerseyUtil {
    public static Client createClient(AtmosMgmtConfig config) {
        try {
            DefaultClientConfig clientConfig = new DefaultClientConfig();
            if (config.isDisableSslValidation()) {
                clientConfig.getProperties().put("com.sun.jersey.client.impl.urlconnection.httpsProperties", new HTTPSProperties(SslUtil.gullibleVerifier, SslUtil.createGullibleSslContext()));
            }
            Client client = Client.create(clientConfig);
            JerseyUtil.configureClient(client, config);
            return client;
        }
        catch (Exception e) {
            throw new AcdpException("Error configuring REST client", e);
        }
    }

    public static void configureClient(Client client, AtmosMgmtConfig config) {
        client.addFilter(new ErrorFilter());
        client.addFilter(new AuthFilter(config));
    }

    private JerseyUtil() {
    }
}

