/*
 * Decompiled with CFR 0.152.
 */
package com.emc.esu.api.rest;

import java.io.IOException;
import java.io.InputStream;
import org.apache.http.HttpResponse;
import org.apache.http.util.EntityUtils;
import org.apache.log4j.Logger;

public class CommonsInputStreamWrapper
extends InputStream {
    private static final Logger l4j = Logger.getLogger(CommonsInputStreamWrapper.class);
    private InputStream in;
    private HttpResponse response;

    public CommonsInputStreamWrapper(HttpResponse response) throws IllegalStateException, IOException {
        this.in = response.getEntity().getContent();
        this.response = response;
    }

    @Override
    public int available() throws IOException {
        return this.in.available();
    }

    @Override
    public void close() throws IOException {
        this.in.close();
        if (this.response != null) {
            EntityUtils.consume(this.response.getEntity());
            this.response = null;
        }
    }

    @Override
    public synchronized void mark(int readlimit) {
        this.in.mark(readlimit);
    }

    @Override
    public boolean markSupported() {
        return this.in.markSupported();
    }

    @Override
    public int read() throws IOException {
        return this.in.read();
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        return this.in.read(b, off, len);
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.in.read(b);
    }

    @Override
    public synchronized void reset() throws IOException {
        this.in.reset();
    }

    @Override
    public long skip(long n) throws IOException {
        return this.in.skip(n);
    }

    protected void finalize() throws Throwable {
        if (this.response != null) {
            l4j.warn((Object)"Warning: connection was not closed!");
            try {
                EntityUtils.consume(this.response.getEntity());
                this.response = null;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        super.finalize();
    }
}

