/*
 * Decompiled with CFR 0.152.
 */
package com.emc.esu.api.rest;

import com.emc.esu.api.Acl;
import com.emc.esu.api.BufferSegment;
import com.emc.esu.api.Checksum;
import com.emc.esu.api.DirectoryEntry;
import com.emc.esu.api.EsuException;
import com.emc.esu.api.Extent;
import com.emc.esu.api.Grantee;
import com.emc.esu.api.Identifier;
import com.emc.esu.api.ListOptions;
import com.emc.esu.api.MetadataList;
import com.emc.esu.api.MetadataTag;
import com.emc.esu.api.MetadataTags;
import com.emc.esu.api.ObjectId;
import com.emc.esu.api.ObjectInfo;
import com.emc.esu.api.ObjectMetadata;
import com.emc.esu.api.ObjectPath;
import com.emc.esu.api.ObjectResult;
import com.emc.esu.api.ServiceInformation;
import com.emc.esu.api.Version;
import com.emc.esu.api.rest.AbstractEsuRestApi;
import com.emc.esu.api.rest.CommonsInputStreamWrapper;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.conn.scheme.PlainSocketFactory;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.PoolingClientConnectionManager;
import org.apache.http.impl.cookie.DateParseException;
import org.apache.http.impl.cookie.DateUtils;
import org.apache.http.message.AbstractHttpMessage;
import org.apache.http.util.EntityUtils;
import org.apache.log4j.Logger;
import org.jdom.Document;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;

public class EsuRestApiApache
extends AbstractEsuRestApi {
    private static final Logger l4j = Logger.getLogger(EsuRestApiApache.class);
    private DefaultHttpClient httpClient;

    public EsuRestApiApache(String host, int port, String uid, String sharedSecret) {
        super(host, port, uid, sharedSecret);
        SchemeRegistry schemeRegistry = new SchemeRegistry();
        schemeRegistry.register(new Scheme("https", port, SSLSocketFactory.getSocketFactory()));
        schemeRegistry.register(new Scheme("http", port, PlainSocketFactory.getSocketFactory()));
        PoolingClientConnectionManager cm = new PoolingClientConnectionManager(schemeRegistry);
        cm.setMaxTotal(200);
        cm.setDefaultMaxPerRoute(200);
        this.httpClient = new DefaultHttpClient(cm, null);
    }

    public void setProxy(String host, int port, boolean https) {
        this.setProxy(host, port, https, null, null);
    }

    public void setProxy(String host, int port, boolean https, String username, String password) {
        HttpHost proxyHost = new HttpHost(host, port, https ? "https" : "http");
        this.httpClient.getParams().setParameter("http.route.default-proxy", proxyHost);
        if (username != null) {
            this.httpClient.getCredentialsProvider().setCredentials(new AuthScope(host, port), new UsernamePasswordCredentials(username, password));
        }
    }

    @Override
    public ObjectId createObjectFromStreamOnPath(ObjectPath path, Acl acl, MetadataList metadata, InputStream data, long length, String mimeType) {
        try {
            String resource = this.getResourcePath(this.context, path);
            URL u = this.buildUrl(resource, null);
            if (data == null) {
                throw new IllegalArgumentException("Input stream is required");
            }
            HashMap<String, String> headers = new HashMap<String, String>();
            if (mimeType == null) {
                mimeType = "application/octet-stream";
            }
            headers.put("Content-Type", mimeType);
            headers.put("x-emc-uid", this.uid);
            if (metadata != null) {
                this.processMetadata(metadata, headers);
            }
            l4j.debug((Object)("meta " + (String)headers.get("x-emc-meta")));
            if (acl != null) {
                this.processAcl(acl, headers);
            }
            headers.put("Date", this.getDateHeader());
            this.signRequest("POST", resource, null, headers);
            HttpResponse response = this.restPost(u, headers, data, length);
            this.handleError(response);
            String location = response.getFirstHeader("location").getValue();
            this.cleanup(response);
            return this.getObjectId(location);
        }
        catch (MalformedURLException e) {
            throw new EsuException("Invalid URL", e);
        }
        catch (IOException e) {
            throw new EsuException("Error connecting to server", e);
        }
        catch (GeneralSecurityException e) {
            throw new EsuException("Error computing request signature", e);
        }
        catch (URISyntaxException e) {
            throw new EsuException("Invalid URL", e);
        }
    }

    @Override
    public ObjectId createObjectFromStream(Acl acl, MetadataList metadata, InputStream data, long length, String mimeType) {
        try {
            String resource = this.context + "/objects";
            URL u = this.buildUrl(resource, null);
            if (data == null) {
                throw new IllegalArgumentException("Input stream is required");
            }
            HashMap<String, String> headers = new HashMap<String, String>();
            if (mimeType == null) {
                mimeType = "application/octet-stream";
            }
            headers.put("Content-Type", mimeType);
            headers.put("x-emc-uid", this.uid);
            if (metadata != null) {
                this.processMetadata(metadata, headers);
            }
            l4j.debug((Object)("meta " + (String)headers.get("x-emc-meta")));
            if (acl != null) {
                this.processAcl(acl, headers);
            }
            headers.put("Date", this.getDateHeader());
            this.signRequest("POST", resource, null, headers);
            HttpResponse response = this.restPost(u, headers, data, length);
            this.handleError(response);
            String location = response.getFirstHeader("location").getValue();
            this.cleanup(response);
            return this.getObjectId(location);
        }
        catch (MalformedURLException e) {
            throw new EsuException("Invalid URL", e);
        }
        catch (IOException e) {
            throw new EsuException("Error connecting to server", e);
        }
        catch (GeneralSecurityException e) {
            throw new EsuException("Error computing request signature", e);
        }
        catch (URISyntaxException e) {
            throw new EsuException("Invalid URL", e);
        }
    }

    @Override
    public ObjectId createObjectFromSegment(Acl acl, MetadataList metadata, BufferSegment data, String mimeType, Checksum checksum) {
        try {
            String resource = this.context + "/objects";
            URL u = this.buildUrl(resource, null);
            HashMap<String, String> headers = new HashMap<String, String>();
            if (mimeType == null) {
                mimeType = "application/octet-stream";
            }
            headers.put("Content-Type", mimeType);
            headers.put("x-emc-uid", this.uid);
            if (metadata != null) {
                this.processMetadata(metadata, headers);
            }
            l4j.debug((Object)("meta " + (String)headers.get("x-emc-meta")));
            if (acl != null) {
                this.processAcl(acl, headers);
            }
            if (data == null) {
                data = new BufferSegment(new byte[0]);
            }
            headers.put("Date", this.getDateHeader());
            if (checksum != null) {
                checksum.update(data.getBuffer(), data.getOffset(), data.getSize());
                headers.put("x-emc-wschecksum", checksum.toString());
            }
            this.signRequest("POST", resource, null, headers);
            HttpResponse response = this.restPost(u, headers, data);
            this.handleError(response);
            String location = response.getFirstHeader("location").getValue();
            this.cleanup(response);
            return this.getObjectId(location);
        }
        catch (MalformedURLException e) {
            throw new EsuException("Invalid URL", e);
        }
        catch (IOException e) {
            throw new EsuException("Error connecting to server", e);
        }
        catch (GeneralSecurityException e) {
            throw new EsuException("Error computing request signature", e);
        }
        catch (URISyntaxException e) {
            throw new EsuException("Invalid URL", e);
        }
    }

    @Override
    public ObjectId createObjectFromSegmentOnPath(ObjectPath path, Acl acl, MetadataList metadata, BufferSegment data, String mimeType, Checksum checksum) {
        try {
            String resource = this.getResourcePath(this.context, path);
            URL u = this.buildUrl(resource, null);
            HashMap<String, String> headers = new HashMap<String, String>();
            if (mimeType == null) {
                mimeType = "application/octet-stream";
            }
            headers.put("Content-Type", mimeType);
            headers.put("x-emc-uid", this.uid);
            if (metadata != null) {
                this.processMetadata(metadata, headers);
            }
            l4j.debug((Object)("meta " + (String)headers.get("x-emc-meta")));
            if (acl != null) {
                this.processAcl(acl, headers);
            }
            if (data == null) {
                data = new BufferSegment(new byte[0]);
            }
            headers.put("Date", this.getDateHeader());
            if (checksum != null) {
                checksum.update(data.getBuffer(), data.getOffset(), data.getSize());
                headers.put("x-emc-wschecksum", checksum.toString());
            }
            this.signRequest("POST", resource, null, headers);
            HttpResponse response = this.restPost(u, headers, data);
            this.handleError(response);
            String location = response.getFirstHeader("location").getValue();
            this.cleanup(response);
            return this.getObjectId(location);
        }
        catch (MalformedURLException e) {
            throw new EsuException("Invalid URL", e);
        }
        catch (IOException e) {
            throw new EsuException("Error connecting to server", e);
        }
        catch (GeneralSecurityException e) {
            throw new EsuException("Error computing request signature", e);
        }
        catch (URISyntaxException e) {
            throw new EsuException("Invalid URL", e);
        }
    }

    @Override
    public void deleteObject(Identifier id) {
        try {
            String resource = this.getResourcePath(this.context, id);
            URL u = this.buildUrl(resource, null);
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("x-emc-uid", this.uid);
            headers.put("Date", this.getDateHeader());
            this.signRequest("DELETE", resource, null, headers);
            HttpResponse response = this.restDelete(u, headers);
            this.handleError(response);
            this.cleanup(response);
        }
        catch (MalformedURLException e) {
            throw new EsuException("Invalid URL", e);
        }
        catch (IOException e) {
            throw new EsuException("Error connecting to server", e);
        }
        catch (GeneralSecurityException e) {
            throw new EsuException("Error computing request signature", e);
        }
        catch (URISyntaxException e) {
            throw new EsuException("Invalid URL", e);
        }
    }

    @Override
    public void deleteVersion(ObjectId id) {
        try {
            String resource = this.getResourcePath(this.context, id);
            String query = "versions";
            URL u = this.buildUrl(resource, query);
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("x-emc-uid", this.uid);
            headers.put("Date", this.getDateHeader());
            this.signRequest("DELETE", resource, query, headers);
            HttpResponse response = this.restDelete(u, headers);
            this.handleError(response);
            this.cleanup(response);
        }
        catch (MalformedURLException e) {
            throw new EsuException("Invalid URL", e);
        }
        catch (IOException e) {
            throw new EsuException("Error connecting to server", e);
        }
        catch (GeneralSecurityException e) {
            throw new EsuException("Error computing request signature", e);
        }
        catch (URISyntaxException e) {
            throw new EsuException("Invalid URL", e);
        }
    }

    @Override
    public void deleteUserMetadata(Identifier id, MetadataTags tags) {
        if (tags == null) {
            throw new EsuException("Must specify tags to delete");
        }
        try {
            String resource = this.getResourcePath(this.context, id);
            String query = "metadata/user";
            URL u = this.buildUrl(resource, query);
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("x-emc-uid", this.uid);
            if (tags != null) {
                this.processTags(tags, headers);
            }
            headers.put("Date", this.getDateHeader());
            this.signRequest("DELETE", resource, query, headers);
            HttpResponse response = this.restDelete(u, headers);
            this.handleError(response);
            this.finishRequest(response);
        }
        catch (MalformedURLException e) {
            throw new EsuException("Invalid URL", e);
        }
        catch (IOException e) {
            throw new EsuException("Error connecting to server", e);
        }
        catch (GeneralSecurityException e) {
            throw new EsuException("Error computing request signature", e);
        }
        catch (URISyntaxException e) {
            throw new EsuException("Invalid URL", e);
        }
    }

    @Override
    public Acl getAcl(Identifier id) {
        try {
            String resource = this.getResourcePath(this.context, id);
            String query = "acl";
            URL u = this.buildUrl(resource, query);
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("x-emc-uid", this.uid);
            headers.put("Date", this.getDateHeader());
            this.signRequest("GET", resource, query, headers);
            HttpResponse response = this.restGet(u, headers);
            this.handleError(response);
            Acl acl = new Acl();
            this.readAcl(acl, response.getFirstHeader("x-emc-useracl").getValue(), Grantee.GRANT_TYPE.USER);
            this.readAcl(acl, response.getFirstHeader("x-emc-groupacl").getValue(), Grantee.GRANT_TYPE.GROUP);
            this.finishRequest(response);
            return acl;
        }
        catch (MalformedURLException e) {
            throw new EsuException("Invalid URL", e);
        }
        catch (IOException e) {
            throw new EsuException("Error connecting to server", e);
        }
        catch (GeneralSecurityException e) {
            throw new EsuException("Error computing request signature", e);
        }
        catch (URISyntaxException e) {
            throw new EsuException("Invalid URL", e);
        }
    }

    @Override
    public MetadataTags getListableTags(MetadataTag tag) {
        return this.getListableTags(tag == null ? null : tag.getName());
    }

    @Override
    public MetadataTags getListableTags(String tag) {
        try {
            String resource = this.context + "/objects";
            String query = "listabletags";
            URL u = this.buildUrl(resource, query);
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("x-emc-uid", this.uid);
            if (this.unicodeEnabled) {
                headers.put("x-emc-utf8", "true");
            }
            if (tag != null) {
                headers.put("x-emc-tags", this.unicodeEnabled ? this.encodeUtf8(tag) : tag);
            }
            headers.put("Date", this.getDateHeader());
            this.signRequest("GET", resource, query, headers);
            HttpResponse response = this.restGet(u, headers);
            this.handleError(response);
            Header header = response.getFirstHeader("x-emc-listable-tags");
            MetadataTags tags = new MetadataTags();
            if (header != null) {
                l4j.debug((Object)("x-emc-listable-tags: " + header));
                this.readTags(tags, header.getValue(), true);
            }
            this.finishRequest(response);
            return tags;
        }
        catch (MalformedURLException e) {
            throw new EsuException("Invalid URL", e);
        }
        catch (IOException e) {
            throw new EsuException("Error connecting to server", e);
        }
        catch (GeneralSecurityException e) {
            throw new EsuException("Error computing request signature", e);
        }
        catch (URISyntaxException e) {
            throw new EsuException("Invalid URL", e);
        }
    }

    @Override
    public MetadataList getSystemMetadata(Identifier id, MetadataTags tags) {
        try {
            String resource = this.getResourcePath(this.context, id);
            String query = "metadata/system";
            URL u = this.buildUrl(resource, query);
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("x-emc-uid", this.uid);
            if (tags != null) {
                this.processTags(tags, headers);
            }
            headers.put("Date", this.getDateHeader());
            this.signRequest("GET", resource, query, headers);
            HttpResponse response = this.restGet(u, headers);
            this.handleError(response);
            MetadataList meta = new MetadataList();
            this.readMetadata(meta, response.getFirstHeader("x-emc-meta"), false);
            this.readMetadata(meta, response.getFirstHeader("x-emc-listable-meta"), true);
            this.finishRequest(response);
            return meta;
        }
        catch (MalformedURLException e) {
            throw new EsuException("Invalid URL", e);
        }
        catch (IOException e) {
            throw new EsuException("Error connecting to server", e);
        }
        catch (GeneralSecurityException e) {
            throw new EsuException("Error computing request signature", e);
        }
        catch (URISyntaxException e) {
            throw new EsuException("Invalid URL", e);
        }
    }

    @Override
    public MetadataList getUserMetadata(Identifier id, MetadataTags tags) {
        try {
            String resource = this.getResourcePath(this.context, id);
            String query = "metadata/user";
            URL u = this.buildUrl(resource, query);
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("x-emc-uid", this.uid);
            if (this.unicodeEnabled) {
                headers.put("x-emc-utf8", "true");
            }
            if (tags != null) {
                this.processTags(tags, headers);
            }
            headers.put("Date", this.getDateHeader());
            this.signRequest("GET", resource, query, headers);
            HttpResponse response = this.restGet(u, headers);
            this.handleError(response);
            MetadataList meta = new MetadataList();
            this.readMetadata(meta, response.getFirstHeader("x-emc-meta"), false);
            this.readMetadata(meta, response.getFirstHeader("x-emc-listable-meta"), true);
            this.finishRequest(response);
            return meta;
        }
        catch (MalformedURLException e) {
            throw new EsuException("Invalid URL", e);
        }
        catch (IOException e) {
            throw new EsuException("Error connecting to server", e);
        }
        catch (GeneralSecurityException e) {
            throw new EsuException("Error computing request signature", e);
        }
        catch (URISyntaxException e) {
            throw new EsuException("Invalid URL", e);
        }
    }

    @Override
    public List<ObjectResult> listObjects(String tag, ListOptions options) {
        try {
            Header token;
            String resource = this.context + "/objects";
            URL u = this.buildUrl(resource, null);
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("x-emc-uid", this.uid);
            if (this.unicodeEnabled) {
                headers.put("x-emc-utf8", "true");
            }
            if (tag == null) {
                throw new EsuException("Tag cannot be null");
            }
            headers.put("x-emc-tags", this.unicodeEnabled ? this.encodeUtf8(tag) : tag);
            if (options != null) {
                if (options.isIncludeMetadata()) {
                    headers.put("x-emc-include-meta", "1");
                    if (options.getSystemMetadata() != null) {
                        headers.put("x-emc-system-tags", this.join(options.getSystemMetadata(), ","));
                    }
                    if (options.getUserMetadata() != null) {
                        headers.put("x-emc-user-tags", this.join(options.getUserMetadata(), ","));
                    }
                }
                if (options.getLimit() > 0) {
                    headers.put("x-emc-limit", "" + options.getLimit());
                }
                if (options.getToken() != null) {
                    headers.put("x-emc-token", options.getToken());
                }
            }
            headers.put("Date", this.getDateHeader());
            this.signRequest("GET", resource, null, headers);
            HttpResponse response = this.restGet(u, headers);
            try {
                this.handleError(response);
            }
            catch (EsuException e) {
                if (e.getAtmosCode() == 1003) {
                    return Collections.emptyList();
                }
                throw e;
            }
            if (options != null) {
                token = response.getFirstHeader("x-emc-token");
                if (token != null) {
                    options.setToken(token.getValue());
                } else {
                    options.setToken(null);
                }
            } else {
                token = response.getFirstHeader("x-emc-token");
                if (token != null) {
                    l4j.warn((Object)"Result set truncated. Use ListOptions to retrieve token for next page of results.");
                }
            }
            byte[] data = this.readStream(response.getEntity().getContent(), (int)response.getEntity().getContentLength());
            if (l4j.isDebugEnabled()) {
                l4j.debug((Object)("Response: " + new String(data, "UTF-8")));
            }
            this.finishRequest(response);
            return this.parseObjectListWithMetadata(data);
        }
        catch (MalformedURLException e) {
            throw new EsuException("Invalid URL", e);
        }
        catch (IOException e) {
            throw new EsuException("Error connecting to server", e);
        }
        catch (GeneralSecurityException e) {
            throw new EsuException("Error computing request signature", e);
        }
        catch (URISyntaxException e) {
            throw new EsuException("Invalid URL", e);
        }
    }

    @Override
    public MetadataTags listUserMetadataTags(Identifier id) {
        try {
            String resource = this.getResourcePath(this.context, id);
            String query = "metadata/tags";
            URL u = this.buildUrl(resource, query);
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("x-emc-uid", this.uid);
            if (this.unicodeEnabled) {
                headers.put("x-emc-utf8", "true");
            }
            headers.put("Date", this.getDateHeader());
            this.signRequest("GET", resource, query, headers);
            HttpResponse response = this.restGet(u, headers);
            this.handleError(response);
            MetadataTags tags = new MetadataTags();
            Header listableHeader = response.getFirstHeader("x-emc-listable-tags");
            Header metaHeader = response.getFirstHeader("x-emc-tags");
            if (listableHeader != null) {
                this.readTags(tags, listableHeader.getValue(), true);
            }
            if (metaHeader != null) {
                this.readTags(tags, metaHeader.getValue(), false);
            }
            this.finishRequest(response);
            return tags;
        }
        catch (MalformedURLException e) {
            throw new EsuException("Invalid URL", e);
        }
        catch (IOException e) {
            throw new EsuException("Error connecting to server", e);
        }
        catch (GeneralSecurityException e) {
            throw new EsuException("Error computing request signature", e);
        }
        catch (URISyntaxException e) {
            throw new EsuException("Invalid URL", e);
        }
    }

    @Override
    public List<Identifier> listVersions(Identifier id) {
        try {
            String resource = this.getResourcePath(this.context, id);
            String query = "versions";
            URL u = this.buildUrl(resource, query);
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("x-emc-uid", this.uid);
            headers.put("Date", this.getDateHeader());
            this.signRequest("GET", resource, query, headers);
            HttpResponse response = this.restGet(u, headers);
            this.handleError(response);
            byte[] data = this.readStream(response.getEntity().getContent(), (int)response.getEntity().getContentLength());
            if (l4j.isDebugEnabled()) {
                l4j.debug((Object)("Response: " + new String(data, "UTF-8")));
            }
            this.finishRequest(response);
            return this.parseVersionList(data);
        }
        catch (MalformedURLException e) {
            throw new EsuException("Invalid URL", e);
        }
        catch (IOException e) {
            throw new EsuException("Error connecting to server", e);
        }
        catch (GeneralSecurityException e) {
            throw new EsuException("Error computing request signature", e);
        }
        catch (URISyntaxException e) {
            throw new EsuException("Invalid URL", e);
        }
    }

    @Override
    public List<Version> listVersions(ObjectId id, ListOptions options) {
        try {
            Header token;
            String resource = this.getResourcePath(this.context, id);
            String query = "versions";
            URL u = this.buildUrl(resource, query);
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("x-emc-uid", this.uid);
            if (options != null) {
                if (options.isIncludeMetadata()) {
                    l4j.warn((Object)"Include metadata is not supported for listVersions");
                }
                if (options.getLimit() > 0) {
                    headers.put("x-emc-limit", "" + options.getLimit());
                }
                if (options.getToken() != null) {
                    headers.put("x-emc-token", options.getToken());
                }
            }
            headers.put("Date", this.getDateHeader());
            this.signRequest("GET", resource, query, headers);
            HttpResponse response = this.restGet(u, headers);
            this.handleError(response);
            if (options != null) {
                token = response.getFirstHeader("x-emc-token");
                if (token != null) {
                    options.setToken(token.getValue());
                } else {
                    options.setToken(null);
                }
            } else {
                token = response.getFirstHeader("x-emc-token");
                if (token != null) {
                    l4j.warn((Object)"Result set truncated. Use ListOptions to retrieve token for next page of results.");
                }
            }
            byte[] data = this.readStream(response.getEntity().getContent(), (int)response.getEntity().getContentLength());
            if (l4j.isDebugEnabled()) {
                l4j.debug((Object)("Response: " + new String(data, "UTF-8")));
            }
            this.finishRequest(response);
            return this.parseVersionListLong(data);
        }
        catch (MalformedURLException e) {
            throw new EsuException("Invalid URL", e);
        }
        catch (IOException e) {
            throw new EsuException("Error connecting to server", e);
        }
        catch (GeneralSecurityException e) {
            throw new EsuException("Error computing request signature", e);
        }
        catch (URISyntaxException e) {
            throw new EsuException("Invalid URL", e);
        }
    }

    @Override
    public List<ObjectId> queryObjects(String xquery) {
        try {
            String resource = this.context + "/objects";
            URL u = this.buildUrl(resource, null);
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("x-emc-uid", this.uid);
            if (xquery == null) {
                throw new EsuException("Query cannot be null");
            }
            headers.put("x-emc-xquery", xquery);
            headers.put("Date", this.getDateHeader());
            this.signRequest("GET", resource, null, headers);
            HttpResponse response = this.restGet(u, headers);
            this.handleError(response);
            byte[] data = this.readStream(response.getEntity().getContent(), (int)response.getEntity().getContentLength());
            if (l4j.isDebugEnabled()) {
                l4j.debug((Object)("Response: " + new String(data, "UTF-8")));
            }
            this.finishRequest(response);
            return this.parseObjectList(data);
        }
        catch (MalformedURLException e) {
            throw new EsuException("Invalid URL", e);
        }
        catch (IOException e) {
            throw new EsuException("Error connecting to server", e);
        }
        catch (GeneralSecurityException e) {
            throw new EsuException("Error computing request signature", e);
        }
        catch (URISyntaxException e) {
            throw new EsuException("Invalid URL", e);
        }
    }

    @Override
    public byte[] readObject(Identifier id, Extent extent, byte[] buffer, Checksum checksum) {
        try {
            String resource = this.getResourcePath(this.context, id);
            URL u = this.buildUrl(resource, null);
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("x-emc-uid", this.uid);
            headers.put("Date", this.getDateHeader());
            if (extent != null && !extent.equals(Extent.ALL_CONTENT)) {
                headers.put(extent.getHeaderName(), extent.toString());
            }
            this.signRequest("GET", resource, null, headers);
            HttpResponse response = this.restGet(u, headers);
            this.handleError(response);
            byte[] data = this.readStream(response.getEntity().getContent(), (int)response.getEntity().getContentLength());
            this.finishRequest(response);
            Header checksumHeader = response.getFirstHeader("x-emc-wschecksum");
            if (checksumHeader != null && checksum != null) {
                String checksumStr = checksumHeader.getValue();
                l4j.debug((Object)("Checksum header: " + checksumStr));
                checksum.setExpectedValue(checksumStr);
                if (response.getEntity().getContentLength() != -1L) {
                    checksum.update(data, 0, (int)response.getEntity().getContentLength());
                } else {
                    checksum.update(data, 0, data.length);
                }
            }
            return data;
        }
        catch (MalformedURLException e) {
            throw new EsuException("Invalid URL", e);
        }
        catch (IOException e) {
            throw new EsuException("Error connecting to server", e);
        }
        catch (GeneralSecurityException e) {
            throw new EsuException("Error computing request signature", e);
        }
        catch (URISyntaxException e) {
            throw new EsuException("Invalid URL", e);
        }
    }

    @Override
    public InputStream readObjectStream(Identifier id, Extent extent) {
        try {
            String resource = this.getResourcePath(this.context, id);
            URL u = this.buildUrl(resource, null);
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("x-emc-uid", this.uid);
            headers.put("Date", this.getDateHeader());
            if (extent != null && !extent.equals(Extent.ALL_CONTENT)) {
                headers.put(extent.getHeaderName(), extent.toString());
            }
            this.signRequest("GET", resource, null, headers);
            HttpResponse response = this.restGet(u, headers);
            this.handleError(response);
            return new CommonsInputStreamWrapper(response);
        }
        catch (MalformedURLException e) {
            throw new EsuException("Invalid URL", e);
        }
        catch (IOException e) {
            throw new EsuException("Error connecting to server", e);
        }
        catch (GeneralSecurityException e) {
            throw new EsuException("Error computing request signature", e);
        }
        catch (URISyntaxException e) {
            throw new EsuException("Invalid URL", e);
        }
    }

    @Override
    public void updateObjectFromSegment(Identifier id, Acl acl, MetadataList metadata, Extent extent, BufferSegment data, String mimeType, Checksum checksum) {
        try {
            String resource = this.getResourcePath(this.context, id);
            URL u = this.buildUrl(resource, null);
            HashMap<String, String> headers = new HashMap<String, String>();
            if (mimeType == null) {
                mimeType = "application/octet-stream";
            }
            headers.put("Content-Type", mimeType);
            headers.put("x-emc-uid", this.uid);
            if (metadata != null) {
                this.processMetadata(metadata, headers);
            }
            l4j.debug((Object)("meta " + (String)headers.get("x-emc-meta")));
            if (acl != null) {
                this.processAcl(acl, headers);
            }
            if (extent != null && !extent.equals(Extent.ALL_CONTENT)) {
                headers.put(extent.getHeaderName(), extent.toString());
            }
            if (data == null) {
                data = new BufferSegment(new byte[0]);
            }
            headers.put("Date", this.getDateHeader());
            if (checksum != null) {
                checksum.update(data.getBuffer(), data.getOffset(), data.getSize());
                headers.put("x-emc-wschecksum", checksum.toString());
            }
            this.signRequest("PUT", resource, null, headers);
            HttpResponse response = this.restPut(u, headers, data);
            this.handleError(response);
            this.finishRequest(response);
        }
        catch (MalformedURLException e) {
            throw new EsuException("Invalid URL", e);
        }
        catch (IOException e) {
            throw new EsuException("Error connecting to server", e);
        }
        catch (GeneralSecurityException e) {
            throw new EsuException("Error computing request signature", e);
        }
        catch (URISyntaxException e) {
            throw new EsuException("Invalid URL", e);
        }
    }

    @Override
    public void updateObjectFromStream(Identifier id, Acl acl, MetadataList metadata, Extent extent, InputStream data, long length, String mimeType) {
        try {
            String resource = this.getResourcePath(this.context, id);
            URL u = this.buildUrl(resource, null);
            HashMap<String, String> headers = new HashMap<String, String>();
            if (mimeType == null) {
                mimeType = "application/octet-stream";
            }
            headers.put("Content-Type", mimeType);
            headers.put("x-emc-uid", this.uid);
            if (metadata != null) {
                this.processMetadata(metadata, headers);
            }
            l4j.debug((Object)("meta " + (String)headers.get("x-emc-meta")));
            if (acl != null) {
                this.processAcl(acl, headers);
            }
            if (extent != null && !extent.equals(Extent.ALL_CONTENT)) {
                headers.put(extent.getHeaderName(), extent.toString());
            }
            headers.put("Date", this.getDateHeader());
            this.signRequest("PUT", resource, null, headers);
            HttpResponse response = this.restPut(u, headers, data, length);
            this.handleError(response);
            this.finishRequest(response);
        }
        catch (MalformedURLException e) {
            throw new EsuException("Invalid URL", e);
        }
        catch (IOException e) {
            throw new EsuException("Error connecting to server", e);
        }
        catch (GeneralSecurityException e) {
            throw new EsuException("Error computing request signature", e);
        }
        catch (URISyntaxException e) {
            throw new EsuException("Invalid URL", e);
        }
    }

    @Override
    public void setUserMetadata(Identifier id, MetadataList metadata) {
        try {
            String resource = this.getResourcePath(this.context, id);
            String query = "metadata/user";
            URL u = this.buildUrl(resource, query);
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("x-emc-uid", this.uid);
            if (metadata != null) {
                this.processMetadata(metadata, headers);
            }
            headers.put("Date", this.getDateHeader());
            this.signRequest("POST", resource, query, headers);
            HttpResponse response = this.restPost(u, headers, null);
            this.handleError(response);
            this.finishRequest(response);
        }
        catch (MalformedURLException e) {
            throw new EsuException("Invalid URL", e);
        }
        catch (IOException e) {
            throw new EsuException("Error connecting to server", e);
        }
        catch (GeneralSecurityException e) {
            throw new EsuException("Error computing request signature", e);
        }
        catch (URISyntaxException e) {
            throw new EsuException("Invalid URL", e);
        }
    }

    @Override
    public void setAcl(Identifier id, Acl acl) {
        try {
            String resource = this.getResourcePath(this.context, id);
            String query = "acl";
            URL u = this.buildUrl(resource, query);
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("x-emc-uid", this.uid);
            if (acl != null) {
                this.processAcl(acl, headers);
            }
            headers.put("Date", this.getDateHeader());
            this.signRequest("POST", resource, query, headers);
            HttpResponse response = this.restPost(u, headers, null);
            this.handleError(response);
            this.finishRequest(response);
        }
        catch (MalformedURLException e) {
            throw new EsuException("Invalid URL", e);
        }
        catch (IOException e) {
            throw new EsuException("Error connecting to server", e);
        }
        catch (GeneralSecurityException e) {
            throw new EsuException("Error computing request signature", e);
        }
        catch (URISyntaxException e) {
            throw new EsuException("Invalid URL", e);
        }
    }

    @Override
    public ObjectId versionObject(Identifier id) {
        try {
            String resource = this.getResourcePath(this.context, id);
            String query = "versions";
            URL u = this.buildUrl(resource, query);
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("x-emc-uid", this.uid);
            headers.put("Date", this.getDateHeader());
            this.signRequest("POST", resource, query, headers);
            HttpResponse response = this.restPost(u, headers, null);
            this.handleError(response);
            String location = response.getFirstHeader("location").getValue();
            this.finishRequest(response);
            return this.getObjectId(location);
        }
        catch (MalformedURLException e) {
            throw new EsuException("Invalid URL", e);
        }
        catch (IOException e) {
            throw new EsuException("Error connecting to server", e);
        }
        catch (GeneralSecurityException e) {
            throw new EsuException("Error computing request signature", e);
        }
        catch (URISyntaxException e) {
            throw new EsuException("Invalid URL", e);
        }
    }

    @Override
    public List<DirectoryEntry> listDirectory(ObjectPath path, ListOptions options) {
        if (!path.isDirectory()) {
            throw new EsuException("listDirectory must be called with a directory path");
        }
        byte[] data = null;
        try {
            String resource = this.getResourcePath(this.context, path);
            URL u = this.buildUrl(resource, null);
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("x-emc-uid", this.uid);
            if (options != null) {
                if (options.isIncludeMetadata()) {
                    headers.put("x-emc-include-meta", "1");
                    if (options.getSystemMetadata() != null) {
                        headers.put("x-emc-system-tags", this.join(options.getSystemMetadata(), ","));
                    }
                    if (options.getUserMetadata() != null) {
                        headers.put("x-emc-user-tags", this.join(options.getUserMetadata(), ","));
                    }
                }
                if (options.getLimit() > 0) {
                    headers.put("x-emc-limit", "" + options.getLimit());
                }
                if (options.getToken() != null) {
                    headers.put("x-emc-token", options.getToken());
                }
            }
            headers.put("Date", this.getDateHeader());
            this.signRequest("GET", resource, null, headers);
            HttpResponse response = this.restGet(u, headers);
            this.handleError(response);
            if (options != null) {
                Header token = response.getFirstHeader("x-emc-token");
                if (token != null) {
                    options.setToken(token.getValue());
                } else {
                    options.setToken(null);
                }
            } else {
                Header token = response.getFirstHeader("x-emc-token");
                if (token != null) {
                    l4j.warn((Object)"Result set truncated. Use ListOptions to retrieve token for next page of results.");
                }
            }
            data = this.readStream(response.getEntity().getContent(), (int)response.getEntity().getContentLength());
            this.finishRequest(response);
        }
        catch (MalformedURLException e) {
            throw new EsuException("Invalid URL", e);
        }
        catch (IOException e) {
            throw new EsuException("Error connecting to server", e);
        }
        catch (GeneralSecurityException e) {
            throw new EsuException("Error computing request signature", e);
        }
        catch (URISyntaxException e) {
            throw new EsuException("Invalid URL", e);
        }
        return this.parseDirectoryListing(data, path);
    }

    @Override
    public ObjectMetadata getAllMetadata(Identifier id) {
        try {
            String resource = this.getResourcePath(this.context, id);
            URL u = this.buildUrl(resource, null);
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("x-emc-uid", this.uid);
            if (this.unicodeEnabled) {
                headers.put("x-emc-utf8", "true");
            }
            headers.put("Date", this.getDateHeader());
            this.signRequest("HEAD", resource, null, headers);
            HttpResponse response = this.restHead(u, headers);
            this.handleError(response);
            Acl acl = new Acl();
            this.readAcl(acl, response.getFirstHeader("x-emc-useracl").getValue(), Grantee.GRANT_TYPE.USER);
            this.readAcl(acl, response.getFirstHeader("x-emc-groupacl").getValue(), Grantee.GRANT_TYPE.GROUP);
            MetadataList meta = new MetadataList();
            this.readMetadata(meta, response.getFirstHeader("x-emc-meta"), false);
            this.readMetadata(meta, response.getFirstHeader("x-emc-listable-meta"), true);
            ObjectMetadata om = new ObjectMetadata();
            om.setAcl(acl);
            om.setMetadata(meta);
            om.setMimeType(response.getFirstHeader("Content-Type").getValue());
            this.finishRequest(response);
            return om;
        }
        catch (MalformedURLException e) {
            throw new EsuException("Invalid URL", e);
        }
        catch (IOException e) {
            throw new EsuException("Error connecting to server", e);
        }
        catch (GeneralSecurityException e) {
            throw new EsuException("Error computing request signature", e);
        }
        catch (URISyntaxException e) {
            throw new EsuException("Invalid URL", e);
        }
    }

    @Override
    public ServiceInformation getServiceInformation() {
        try {
            String resource = this.context + "/service";
            URL u = this.buildUrl(resource, null);
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("x-emc-uid", this.uid);
            headers.put("Date", this.getDateHeader());
            this.signRequest("GET", resource, null, headers);
            HttpResponse response = this.restGet(u, headers);
            this.handleError(response);
            byte[] data = this.readStream(response.getEntity().getContent(), (int)response.getEntity().getContentLength());
            if (l4j.isDebugEnabled()) {
                l4j.debug((Object)("Response: " + new String(data, "UTF-8")));
            }
            this.finishRequest(response);
            Map<String, List<String>> rHeaders = this.getResponseHeaders(response);
            return this.parseServiceInformation(data, rHeaders);
        }
        catch (MalformedURLException e) {
            throw new EsuException("Invalid URL", e);
        }
        catch (IOException e) {
            throw new EsuException("Error connecting to server", e);
        }
        catch (GeneralSecurityException e) {
            throw new EsuException("Error computing request signature", e);
        }
        catch (URISyntaxException e) {
            throw new EsuException("Invalid URL", e);
        }
    }

    @Override
    public void rename(ObjectPath source, ObjectPath destination, boolean force) {
        try {
            String destPath;
            String resource = this.getResourcePath(this.context, source);
            String query = "rename";
            URL u = this.buildUrl(resource, query);
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("x-emc-uid", this.uid);
            if (this.unicodeEnabled) {
                headers.put("x-emc-utf8", "true");
            }
            if ((destPath = destination.toString()).startsWith("/")) {
                destPath = destPath.substring(1);
            }
            headers.put("x-emc-path", this.unicodeEnabled ? this.encodeUtf8(destPath) : destPath);
            if (force) {
                headers.put("x-emc-force", "true");
            }
            headers.put("Date", this.getDateHeader());
            this.signRequest("POST", resource, query, headers);
            HttpResponse response = this.restPost(u, headers, null);
            this.handleError(response);
            this.finishRequest(response);
        }
        catch (MalformedURLException e) {
            throw new EsuException("Invalid URL", e);
        }
        catch (IOException e) {
            throw new EsuException("Error connecting to server", e);
        }
        catch (GeneralSecurityException e) {
            throw new EsuException("Error computing request signature", e);
        }
        catch (URISyntaxException e) {
            throw new EsuException("Invalid URL", e);
        }
    }

    @Override
    public void restoreVersion(ObjectId id, ObjectId vId) {
        try {
            String resource = this.getResourcePath(this.context, id);
            String query = "versions";
            URL u = this.buildUrl(resource, query);
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("x-emc-uid", this.uid);
            headers.put("x-emc-version-oid", vId.toString());
            headers.put("Date", this.getDateHeader());
            this.signRequest("PUT", resource, query, headers);
            HttpResponse response = this.restPut(u, headers, null);
            this.handleError(response);
            this.cleanup(response);
        }
        catch (MalformedURLException e) {
            throw new EsuException("Invalid URL", e);
        }
        catch (IOException e) {
            throw new EsuException("Error connecting to server", e);
        }
        catch (GeneralSecurityException e) {
            throw new EsuException("Error computing request signature", e);
        }
        catch (URISyntaxException e) {
            throw new EsuException("Invalid URL", e);
        }
    }

    @Override
    public ObjectInfo getObjectInfo(Identifier id) {
        try {
            String resource = this.getResourcePath(this.context, id);
            String query = "info";
            URL u = this.buildUrl(resource, query);
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("x-emc-uid", this.uid);
            headers.put("Date", this.getDateHeader());
            this.signRequest("GET", resource, query, headers);
            HttpResponse response = this.restGet(u, headers);
            this.handleError(response);
            byte[] data = this.readStream(response.getEntity().getContent(), (int)response.getEntity().getContentLength());
            String responseXml = new String(data, "UTF-8");
            if (l4j.isDebugEnabled()) {
                l4j.debug((Object)("Response: " + responseXml));
            }
            this.finishRequest(response);
            return new ObjectInfo(responseXml);
        }
        catch (MalformedURLException e) {
            throw new EsuException("Invalid URL", e);
        }
        catch (IOException e) {
            throw new EsuException("Error connecting to server", e);
        }
        catch (GeneralSecurityException e) {
            throw new EsuException("Error computing request signature", e);
        }
        catch (URISyntaxException e) {
            throw new EsuException("Invalid URL", e);
        }
    }

    @Override
    public long calculateServerOffset() {
        try {
            String resource = this.context + "/service";
            URL u = this.buildUrl(resource, null);
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("x-emc-uid", this.uid);
            headers.put("Date", this.getDateHeader());
            this.signRequest("GET", resource, null, headers);
            HttpResponse response = this.restGet(u, headers);
            Header responseDate = response.getFirstHeader("Date");
            if (responseDate == null) {
                throw new EsuException("Could not get date from response: " + response.getStatusLine().getStatusCode() + ": " + response.getStatusLine().getReasonPhrase());
            }
            Date serverDate = null;
            try {
                serverDate = DateUtils.parseDate(responseDate.getValue());
            }
            catch (DateParseException e) {
                throw new EsuException("Failed to parse date: " + responseDate.getValue(), e);
            }
            return System.currentTimeMillis() - serverDate.getTime();
        }
        catch (MalformedURLException e) {
            throw new EsuException("Invalid URL", e);
        }
        catch (IOException e) {
            throw new EsuException("Error connecting to server", e);
        }
        catch (GeneralSecurityException e) {
            throw new EsuException("Error computing request signature", e);
        }
        catch (URISyntaxException e) {
            throw new EsuException("Invalid URL", e);
        }
    }

    private void handleError(HttpResponse resp) {
        StatusLine status = resp.getStatusLine();
        if (status.getStatusCode() > 299) {
            try {
                try {
                    HttpEntity body = resp.getEntity();
                    if (body == null) {
                        throw new EsuException(status.getReasonPhrase(), status.getStatusCode());
                    }
                    byte[] response = this.readStream(body.getContent(), (int)body.getContentLength());
                    l4j.debug((Object)("Error response: " + new String(response, "UTF-8")));
                    SAXBuilder sb = new SAXBuilder();
                    Document d = sb.build(new ByteArrayInputStream(response));
                    String code = d.getRootElement().getChildText("Code");
                    String message = d.getRootElement().getChildText("Message");
                    if (code == null && message == null) {
                        throw new EsuException(status.getReasonPhrase(), status.getStatusCode());
                    }
                    l4j.debug((Object)("Error: " + code + " message: " + message));
                    throw new EsuException(message, status.getStatusCode(), Integer.parseInt(code));
                }
                catch (IOException e) {
                    l4j.debug((Object)"Could not read error response body", (Throwable)e);
                    throw new EsuException(status.getReasonPhrase(), status.getStatusCode());
                }
                catch (JDOMException e) {
                    l4j.debug((Object)("Could not parse response body for " + status.getStatusCode() + ": " + status.getReasonPhrase()), (Throwable)e);
                    throw new EsuException("Could not parse response body for " + status.getStatusCode() + ": " + status.getReasonPhrase(), e, status.getStatusCode());
                }
            }
            catch (Throwable throwable) {
                if (resp.getEntity() != null) {
                    try {
                        EntityUtils.consume(resp.getEntity());
                    }
                    catch (IOException e) {
                        l4j.warn((Object)"Error finishing error response", (Throwable)e);
                    }
                }
                throw throwable;
            }
        }
    }

    private HttpResponse restPost(URL url, Map<String, String> headers, InputStream in, long contentLength) throws URISyntaxException, ClientProtocolException, IOException {
        HttpPost post = new HttpPost(url.toURI());
        this.setHeaders(post, headers);
        if (in != null) {
            post.setEntity(new InputStreamEntity(in, contentLength));
        } else {
            post.setEntity(new ByteArrayEntity(new byte[0]));
        }
        return this.httpClient.execute(post);
    }

    private HttpResponse restPost(URL url, Map<String, String> headers, BufferSegment data) throws URISyntaxException, ClientProtocolException, IOException {
        HttpPost post = new HttpPost(url.toURI());
        this.setHeaders(post, headers);
        if (data != null) {
            if (data.getOffset() == 0 && data.getSize() == data.getBuffer().length) {
                post.setEntity(new ByteArrayEntity(data.getBuffer()));
            } else {
                post.setEntity(new InputStreamEntity((InputStream)new ByteArrayInputStream(data.getBuffer(), data.getOffset(), data.getSize()), data.getSize()));
            }
        } else {
            post.setEntity(new ByteArrayEntity(new byte[0]));
        }
        return this.httpClient.execute(post);
    }

    private HttpResponse restDelete(URL url, Map<String, String> headers) throws URISyntaxException, ClientProtocolException, IOException {
        HttpDelete delete = new HttpDelete(url.toURI());
        this.setHeaders(delete, headers);
        return this.httpClient.execute(delete);
    }

    private HttpResponse restGet(URL url, Map<String, String> headers) throws URISyntaxException, ClientProtocolException, IOException {
        HttpGet get = new HttpGet(url.toURI());
        this.setHeaders(get, headers);
        return this.httpClient.execute(get);
    }

    private HttpResponse restPut(URL url, Map<String, String> headers, BufferSegment data) throws ClientProtocolException, IOException, URISyntaxException {
        HttpPut put = new HttpPut(url.toURI());
        this.setHeaders(put, headers);
        if (data != null) {
            if (data.getOffset() == 0 && data.getSize() == data.getBuffer().length) {
                put.setEntity(new ByteArrayEntity(data.getBuffer()));
            } else {
                put.setEntity(new InputStreamEntity((InputStream)new ByteArrayInputStream(data.getBuffer(), data.getOffset(), data.getSize()), data.getSize()));
            }
        } else {
            put.setEntity(new ByteArrayEntity(new byte[0]));
        }
        return this.httpClient.execute(put);
    }

    private HttpResponse restPut(URL url, Map<String, String> headers, InputStream in, long contentLength) throws URISyntaxException, ClientProtocolException, IOException {
        HttpPut put = new HttpPut(url.toURI());
        this.setHeaders(put, headers);
        if (in != null) {
            put.setEntity(new InputStreamEntity(in, contentLength));
        } else {
            put.setEntity(new ByteArrayEntity(new byte[0]));
        }
        return this.httpClient.execute(put);
    }

    private HttpResponse restHead(URL url, Map<String, String> headers) throws URISyntaxException, ClientProtocolException, IOException {
        HttpHead head = new HttpHead(url.toURI());
        this.setHeaders(head, headers);
        return this.httpClient.execute(head);
    }

    private void setHeaders(AbstractHttpMessage request, Map<String, String> headers) {
        for (String headerName : headers.keySet()) {
            request.addHeader(headerName, headers.get(headerName));
        }
    }

    private void finishRequest(HttpResponse response) throws IOException {
        if (response.getEntity() != null) {
            this.cleanup(response);
        }
    }

    private void readMetadata(MetadataList meta, Header firstHeader, boolean listable) throws UnsupportedEncodingException {
        if (firstHeader != null) {
            super.readMetadata(meta, firstHeader.getValue(), listable);
        }
    }

    private void cleanup(HttpResponse response) throws IOException {
        if (response.getEntity() != null) {
            EntityUtils.consume(response.getEntity());
        }
    }

    private void signRequest(String method, String resource, String query, Map<String, String> headers) throws IOException, GeneralSecurityException {
        StringBuffer hashStr = new StringBuffer();
        hashStr.append(method + "\n");
        if (headers.containsKey("Content-Type")) {
            l4j.debug((Object)("Content-Type: " + headers.get("Content-Type")));
            hashStr.append(headers.get("Content-Type") + "\n");
        } else {
            hashStr.append("\n");
        }
        if (headers.containsKey("Range")) {
            hashStr.append(headers.get("Range") + "\n");
        } else if (headers.containsKey("Content-Range")) {
            hashStr.append(headers.get("Content-Range") + "\n");
        } else {
            hashStr.append("\n");
        }
        hashStr.append(headers.get("Date") + "\n");
        hashStr.append(resource.toLowerCase());
        if (query != null) {
            hashStr.append("?" + query + "\n");
        } else {
            hashStr.append("\n");
        }
        ArrayList<String> keys = new ArrayList<String>();
        HashMap<String, String> newheaders = new HashMap<String, String>();
        for (String key : headers.keySet()) {
            if (key.indexOf("x-emc") != 0) continue;
            keys.add(key.toLowerCase());
            newheaders.put(key.toLowerCase(), headers.get(key).replace("\n", ""));
        }
        Collections.sort(keys);
        boolean first = true;
        for (String key : keys) {
            if (!first) {
                hashStr.append("\n");
            } else {
                first = false;
            }
            hashStr.append(key + ':' + this.normalizeSpace((String)newheaders.get(key)));
        }
        String hashOut = this.sign(hashStr.toString());
        headers.put("x-emc-signature", hashOut);
    }

    private Map<String, List<String>> getResponseHeaders(HttpResponse response) {
        Header[] headers;
        HashMap rHeaders = new HashMap();
        for (Header h : headers = response.getAllHeaders()) {
            String name = h.getName();
            String value = h.getValue();
            List<String> hValues = null;
            if (rHeaders.containsKey(name)) {
                hValues = (List)rHeaders.get(name);
            } else {
                hValues = new ArrayList();
                rHeaders.put(name, hValues);
            }
            hValues.add(value);
        }
        return Collections.unmodifiableMap(rHeaders);
    }

    @Override
    public ObjectId createObjectWithKeyFromSegment(String keyPool, String key, Acl acl, MetadataList metadata, BufferSegment data, String mimeType, Checksum checksum) {
        try {
            String resource = this.context + "/namespace/" + key;
            URL u = this.buildUrl(resource, null);
            HashMap<String, String> headers = new HashMap<String, String>();
            if (mimeType == null) {
                mimeType = "application/octet-stream";
            }
            headers.put("Content-Type", mimeType);
            headers.put("x-emc-uid", this.uid);
            headers.put("x-emc-pool", keyPool);
            if (metadata != null) {
                this.processMetadata(metadata, headers);
            }
            l4j.debug((Object)("meta " + (String)headers.get("x-emc-meta")));
            if (acl != null) {
                this.processAcl(acl, headers);
            }
            if (data == null) {
                data = new BufferSegment(new byte[0]);
            }
            headers.put("Date", this.getDateHeader());
            if (checksum != null) {
                checksum.update(data.getBuffer(), data.getOffset(), data.getSize());
                headers.put("x-emc-wschecksum", checksum.toString());
            }
            this.signRequest("POST", resource, null, headers);
            HttpResponse response = this.restPost(u, headers, data);
            this.handleError(response);
            String location = response.getFirstHeader("location").getValue();
            this.cleanup(response);
            return this.getObjectId(location);
        }
        catch (MalformedURLException e) {
            throw new EsuException("Invalid URL", e);
        }
        catch (IOException e) {
            throw new EsuException("Error connecting to server", e);
        }
        catch (GeneralSecurityException e) {
            throw new EsuException("Error computing request signature", e);
        }
        catch (URISyntaxException e) {
            throw new EsuException("Invalid URL", e);
        }
    }

    @Override
    public void hardLink(ObjectPath source, ObjectPath target) {
        try {
            String resource = this.getResourcePath(this.context, source);
            String query = "hardlink";
            URL u = this.buildUrl(resource, query);
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("x-emc-uid", this.uid);
            String destPath = target.toString();
            if (destPath.startsWith("/")) {
                destPath = destPath.substring(1);
            }
            headers.put("x-emc-path", destPath);
            headers.put("Date", this.getDateHeader());
            this.signRequest("POST", resource, query, headers);
            HttpResponse response = this.restPost(u, headers, null);
            this.handleError(response);
            this.cleanup(response);
        }
        catch (MalformedURLException e) {
            throw new EsuException("Invalid URL", e);
        }
        catch (IOException e) {
            throw new EsuException("Error connecting to server", e);
        }
        catch (GeneralSecurityException e) {
            throw new EsuException("Error computing request signature", e);
        }
        catch (URISyntaxException e) {
            throw new EsuException("Invalid URL", e);
        }
    }

    @Override
    public ObjectId createObjectWithKeyFromStream(String keyPool, String key, Acl acl, MetadataList metadata, InputStream data, long length, String mimeType) {
        try {
            String resource = this.context + "/namespace/" + key;
            URL u = this.buildUrl(resource, null);
            if (data == null) {
                throw new IllegalArgumentException("Input stream is required");
            }
            HashMap<String, String> headers = new HashMap<String, String>();
            if (mimeType == null) {
                mimeType = "application/octet-stream";
            }
            headers.put("Content-Type", mimeType);
            headers.put("x-emc-uid", this.uid);
            headers.put("x-emc-pool", keyPool);
            if (metadata != null) {
                this.processMetadata(metadata, headers);
            }
            l4j.debug((Object)("meta " + (String)headers.get("x-emc-meta")));
            if (acl != null) {
                this.processAcl(acl, headers);
            }
            headers.put("Date", this.getDateHeader());
            this.signRequest("POST", resource, null, headers);
            HttpResponse response = this.restPost(u, headers, data, length);
            this.handleError(response);
            String location = response.getFirstHeader("location").getValue();
            this.cleanup(response);
            return this.getObjectId(location);
        }
        catch (MalformedURLException e) {
            throw new EsuException("Invalid URL", e);
        }
        catch (IOException e) {
            throw new EsuException("Error connecting to server", e);
        }
        catch (GeneralSecurityException e) {
            throw new EsuException("Error computing request signature", e);
        }
        catch (URISyntaxException e) {
            throw new EsuException("Invalid URL", e);
        }
    }

    @Override
    public void deleteObjectWithKey(String keyPool, String key) {
        try {
            String resource = this.context + "/namespace/" + key;
            URL u = this.buildUrl(resource, null);
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("x-emc-uid", this.uid);
            headers.put("x-emc-pool", keyPool);
            headers.put("Date", this.getDateHeader());
            this.signRequest("DELETE", resource, null, headers);
            HttpResponse response = this.restDelete(u, headers);
            this.handleError(response);
            this.cleanup(response);
        }
        catch (MalformedURLException e) {
            throw new EsuException("Invalid URL", e);
        }
        catch (IOException e) {
            throw new EsuException("Error connecting to server", e);
        }
        catch (GeneralSecurityException e) {
            throw new EsuException("Error computing request signature", e);
        }
        catch (URISyntaxException e) {
            throw new EsuException("Invalid URL", e);
        }
    }

    @Override
    public ObjectMetadata getAllMetadata(String keyPool, String key) {
        try {
            String resource = this.context + "/namespace/" + key;
            URL u = this.buildUrl(resource, null);
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("x-emc-uid", this.uid);
            headers.put("x-emc-pool", keyPool);
            if (this.unicodeEnabled) {
                headers.put("x-emc-utf8", "true");
            }
            headers.put("Date", this.getDateHeader());
            this.signRequest("HEAD", resource, null, headers);
            HttpResponse response = this.restHead(u, headers);
            this.handleError(response);
            Acl acl = new Acl();
            this.readAcl(acl, response.getFirstHeader("x-emc-useracl").getValue(), Grantee.GRANT_TYPE.USER);
            this.readAcl(acl, response.getFirstHeader("x-emc-groupacl").getValue(), Grantee.GRANT_TYPE.GROUP);
            MetadataList meta = new MetadataList();
            this.readMetadata(meta, response.getFirstHeader("x-emc-meta"), false);
            this.readMetadata(meta, response.getFirstHeader("x-emc-listable-meta"), true);
            ObjectMetadata om = new ObjectMetadata();
            om.setAcl(acl);
            om.setMetadata(meta);
            om.setMimeType(response.getFirstHeader("Content-Type").getValue());
            this.finishRequest(response);
            return om;
        }
        catch (MalformedURLException e) {
            throw new EsuException("Invalid URL", e);
        }
        catch (IOException e) {
            throw new EsuException("Error connecting to server", e);
        }
        catch (GeneralSecurityException e) {
            throw new EsuException("Error computing request signature", e);
        }
        catch (URISyntaxException e) {
            throw new EsuException("Invalid URL", e);
        }
    }

    @Override
    public MetadataList getSystemMetadata(String keyPool, String key, MetadataTags tags) {
        try {
            String resource = this.context + "/namespace/" + key;
            String query = "metadata/system";
            URL u = this.buildUrl(resource, query);
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("x-emc-uid", this.uid);
            headers.put("x-emc-pool", keyPool);
            if (tags != null) {
                this.processTags(tags, headers);
            }
            headers.put("Date", this.getDateHeader());
            this.signRequest("GET", resource, query, headers);
            HttpResponse response = this.restGet(u, headers);
            this.handleError(response);
            MetadataList meta = new MetadataList();
            this.readMetadata(meta, response.getFirstHeader("x-emc-meta"), false);
            this.readMetadata(meta, response.getFirstHeader("x-emc-listable-meta"), true);
            this.finishRequest(response);
            return meta;
        }
        catch (MalformedURLException e) {
            throw new EsuException("Invalid URL", e);
        }
        catch (IOException e) {
            throw new EsuException("Error connecting to server", e);
        }
        catch (GeneralSecurityException e) {
            throw new EsuException("Error computing request signature", e);
        }
        catch (URISyntaxException e) {
            throw new EsuException("Invalid URL", e);
        }
    }

    @Override
    public byte[] readObjectWithKey(String keyPool, String key, Extent extent, byte[] buffer, Checksum checksum) {
        try {
            String resource = this.context + "/namespace/" + key;
            URL u = this.buildUrl(resource, null);
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("x-emc-uid", this.uid);
            headers.put("x-emc-pool", keyPool);
            headers.put("Date", this.getDateHeader());
            if (extent != null && !extent.equals(Extent.ALL_CONTENT)) {
                headers.put(extent.getHeaderName(), extent.toString());
            }
            this.signRequest("GET", resource, null, headers);
            HttpResponse response = this.restGet(u, headers);
            this.handleError(response);
            byte[] data = this.readStream(response.getEntity().getContent(), (int)response.getEntity().getContentLength());
            this.finishRequest(response);
            Header checksumHeader = response.getFirstHeader("x-emc-wschecksum");
            if (checksumHeader != null && checksum != null) {
                String checksumStr = checksumHeader.getValue();
                l4j.debug((Object)("Checksum header: " + checksumStr));
                checksum.setExpectedValue(checksumStr);
                if (response.getEntity().getContentLength() != -1L) {
                    checksum.update(data, 0, (int)response.getEntity().getContentLength());
                } else {
                    checksum.update(data, 0, data.length);
                }
            }
            return data;
        }
        catch (MalformedURLException e) {
            throw new EsuException("Invalid URL", e);
        }
        catch (IOException e) {
            throw new EsuException("Error connecting to server", e);
        }
        catch (GeneralSecurityException e) {
            throw new EsuException("Error computing request signature", e);
        }
        catch (URISyntaxException e) {
            throw new EsuException("Invalid URL", e);
        }
    }

    @Override
    public InputStream readObjectStreamWithKey(String keyPool, String key, Extent extent) {
        try {
            String resource = this.context + "/namespace/" + key;
            URL u = this.buildUrl(resource, null);
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("x-emc-uid", this.uid);
            headers.put("x-emc-pool", keyPool);
            headers.put("Date", this.getDateHeader());
            if (extent != null && !extent.equals(Extent.ALL_CONTENT)) {
                headers.put(extent.getHeaderName(), extent.toString());
            }
            this.signRequest("GET", resource, null, headers);
            HttpResponse response = this.restGet(u, headers);
            this.handleError(response);
            return new CommonsInputStreamWrapper(response);
        }
        catch (MalformedURLException e) {
            throw new EsuException("Invalid URL", e);
        }
        catch (IOException e) {
            throw new EsuException("Error connecting to server", e);
        }
        catch (GeneralSecurityException e) {
            throw new EsuException("Error computing request signature", e);
        }
        catch (URISyntaxException e) {
            throw new EsuException("Invalid URL", e);
        }
    }

    @Override
    public void updateObjectWithKeyFromStream(String keyPool, String key, Acl acl, MetadataList metadata, Extent extent, InputStream data, long length, String mimeType) {
        try {
            String resource = this.context + "/namespace/" + key;
            URL u = this.buildUrl(resource, null);
            HashMap<String, String> headers = new HashMap<String, String>();
            if (mimeType == null) {
                mimeType = "application/octet-stream";
            }
            headers.put("Content-Type", mimeType);
            headers.put("x-emc-uid", this.uid);
            headers.put("x-emc-pool", keyPool);
            if (metadata != null) {
                this.processMetadata(metadata, headers);
            }
            l4j.debug((Object)("meta " + (String)headers.get("x-emc-meta")));
            if (acl != null) {
                this.processAcl(acl, headers);
            }
            if (extent != null && !extent.equals(Extent.ALL_CONTENT)) {
                headers.put(extent.getHeaderName(), extent.toString());
            }
            headers.put("Date", this.getDateHeader());
            this.signRequest("PUT", resource, null, headers);
            HttpResponse response = this.restPut(u, headers, data, length);
            this.handleError(response);
            this.finishRequest(response);
        }
        catch (MalformedURLException e) {
            throw new EsuException("Invalid URL", e);
        }
        catch (IOException e) {
            throw new EsuException("Error connecting to server", e);
        }
        catch (GeneralSecurityException e) {
            throw new EsuException("Error computing request signature", e);
        }
        catch (URISyntaxException e) {
            throw new EsuException("Invalid URL", e);
        }
    }

    @Override
    public void updateObjectWithKeyFromSegment(String keyPool, String key, Acl acl, MetadataList metadata, Extent extent, BufferSegment data, String mimeType, Checksum checksum) {
        try {
            String resource = this.context + "/namespace/" + key;
            URL u = this.buildUrl(resource, null);
            HashMap<String, String> headers = new HashMap<String, String>();
            if (mimeType == null) {
                mimeType = "application/octet-stream";
            }
            headers.put("Content-Type", mimeType);
            headers.put("x-emc-uid", this.uid);
            headers.put("x-emc-pool", keyPool);
            if (metadata != null) {
                this.processMetadata(metadata, headers);
            }
            l4j.debug((Object)("meta " + (String)headers.get("x-emc-meta")));
            if (acl != null) {
                this.processAcl(acl, headers);
            }
            if (extent != null && !extent.equals(Extent.ALL_CONTENT)) {
                headers.put(extent.getHeaderName(), extent.toString());
            }
            if (data == null) {
                data = new BufferSegment(new byte[0]);
            }
            headers.put("Date", this.getDateHeader());
            if (checksum != null) {
                checksum.update(data.getBuffer(), data.getOffset(), data.getSize());
                headers.put("x-emc-wschecksum", checksum.toString());
            }
            this.signRequest("PUT", resource, null, headers);
            HttpResponse response = this.restPut(u, headers, data);
            this.handleError(response);
            this.finishRequest(response);
        }
        catch (MalformedURLException e) {
            throw new EsuException("Invalid URL", e);
        }
        catch (IOException e) {
            throw new EsuException("Error connecting to server", e);
        }
        catch (GeneralSecurityException e) {
            throw new EsuException("Error computing request signature", e);
        }
        catch (URISyntaxException e) {
            throw new EsuException("Invalid URL", e);
        }
    }
}

