/*
 * Decompiled with CFR 0.152.
 */
package com.emc.esu.api.rest;

import com.emc.esu.api.Acl;
import com.emc.esu.api.BufferSegment;
import com.emc.esu.api.Checksum;
import com.emc.esu.api.EsuApi;
import com.emc.esu.api.EsuException;
import com.emc.esu.api.Extent;
import com.emc.esu.api.Identifier;
import com.emc.esu.api.MetadataList;
import com.emc.esu.api.ObjectId;
import com.emc.esu.api.ObjectPath;
import com.emc.esu.api.ProgressListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class UploadHelper {
    private static final Logger l4j = Logger.getLogger(UploadHelper.class);
    public static final int DEFAULT_BUFFSIZE = 0x400000;
    private BufferSegment buffer;
    private EsuApi esu;
    private boolean closeStream;
    private InputStream stream;
    private long currentBytes;
    private long totalBytes;
    private boolean complete;
    private boolean failed;
    private Exception error;
    private List<ProgressListener> listeners;
    private int minReadSize = -1;
    private boolean checksumming;
    private Checksum checksum;
    private String mimeType;

    public UploadHelper(EsuApi esu, byte[] buffer) {
        this.esu = esu;
        this.buffer = buffer == null ? new BufferSegment(new byte[0x400000]) : new BufferSegment(buffer);
        this.listeners = new ArrayList<ProgressListener>();
    }

    public UploadHelper(EsuApi api) {
        this(api, null);
    }

    public ObjectId createObject(File f, Acl acl, MetadataList meta) {
        FileInputStream fis;
        try {
            this.totalBytes = f.length();
            fis = new FileInputStream(f);
        }
        catch (FileNotFoundException e) {
            throw new EsuException("Could not open input file", e);
        }
        return this.createObject(fis, acl, meta, true);
    }

    public ObjectId createObject(InputStream stream, Acl acl, MetadataList metadata, boolean closeStream) {
        this.currentBytes = 0L;
        this.complete = false;
        this.failed = false;
        this.error = null;
        this.closeStream = closeStream;
        this.stream = stream;
        ObjectId id = null;
        if (this.checksumming) {
            try {
                this.checksum = new Checksum(Checksum.Algorithm.SHA0);
            }
            catch (NoSuchAlgorithmException e) {
                throw new RuntimeException("Could not initialize checksum", e);
            }
        }
        try {
            boolean eof = this.readChunk();
            id = this.esu.createObjectFromSegment(acl, metadata, this.buffer, this.mimeType, this.checksum);
            if (eof) {
                this.complete();
                return id;
            }
            this.progress(this.buffer.getSize());
            this.appendChunks(id);
        }
        catch (EsuException e) {
            this.fail(e);
            throw e;
        }
        catch (IOException e) {
            this.fail(e);
            throw new EsuException("Error uploading object", e);
        }
        return id;
    }

    public ObjectId createObjectOnPath(ObjectPath path, File f, Acl acl, MetadataList meta) {
        FileInputStream fis;
        try {
            this.totalBytes = f.length();
            fis = new FileInputStream(f);
        }
        catch (FileNotFoundException e) {
            throw new EsuException("Could not open input file", e);
        }
        return this.createObjectOnPath(path, fis, acl, meta, true);
    }

    public ObjectId createObjectOnPath(ObjectPath path, InputStream stream, Acl acl, MetadataList metadata, boolean closeStream) {
        this.currentBytes = 0L;
        this.complete = false;
        this.failed = false;
        this.error = null;
        this.closeStream = closeStream;
        this.stream = stream;
        ObjectId id = null;
        if (this.checksumming) {
            try {
                this.checksum = new Checksum(Checksum.Algorithm.SHA0);
            }
            catch (NoSuchAlgorithmException e) {
                throw new RuntimeException("Could not initialize checksum", e);
            }
        }
        try {
            boolean eof = this.readChunk();
            id = this.esu.createObjectFromSegmentOnPath(path, acl, metadata, this.buffer, this.mimeType, this.checksum);
            if (eof) {
                this.complete();
                return id;
            }
            this.progress(this.buffer.getSize());
            this.appendChunks(path);
        }
        catch (EsuException e) {
            this.fail(e);
            throw e;
        }
        catch (IOException e) {
            this.fail(e);
            throw new EsuException("Error uploading object", e);
        }
        return id;
    }

    public void updateObject(Identifier id, File f, Acl acl, MetadataList metadata) {
        FileInputStream in;
        try {
            in = new FileInputStream(f);
        }
        catch (FileNotFoundException e) {
            throw new EsuException("Could not open input file", e);
        }
        this.totalBytes = f.length();
        this.updateObject(id, in, acl, metadata, true);
    }

    public void updateObject(Identifier id, InputStream stream, Acl acl, MetadataList metadata, boolean closeStream) {
        this.currentBytes = 0L;
        this.complete = false;
        this.failed = false;
        this.error = null;
        this.closeStream = closeStream;
        this.stream = stream;
        if (this.checksumming) {
            try {
                this.checksum = new Checksum(Checksum.Algorithm.SHA0);
            }
            catch (NoSuchAlgorithmException e) {
                throw new RuntimeException("Could not initialize checksum", e);
            }
        }
        try {
            boolean eof = this.readChunk();
            this.esu.updateObjectFromSegment(id, acl, metadata, null, this.buffer, this.mimeType, this.checksum);
            if (eof) {
                this.complete();
                return;
            }
            this.progress(this.buffer.getSize());
            this.appendChunks(id);
        }
        catch (EsuException e) {
            this.fail(e);
            throw e;
        }
        catch (IOException e) {
            this.fail(e);
            throw new EsuException("Error updating object", e);
        }
    }

    public void addListener(ProgressListener l) {
        this.listeners.add(l);
    }

    public void removeListener(ProgressListener l) {
        this.listeners.remove(l);
    }

    public long getTotalBytes() {
        return this.totalBytes;
    }

    public void setTotalBytes(long totalBytes) {
        this.totalBytes = totalBytes;
    }

    public long getCurrentBytes() {
        return this.currentBytes;
    }

    public boolean isComplete() {
        return this.complete;
    }

    public boolean isFailed() {
        return this.failed;
    }

    public Exception getError() {
        return this.error;
    }

    private void appendChunks(Identifier id) throws IOException {
        while (true) {
            boolean eof;
            if (eof = this.readChunk()) {
                this.complete();
                return;
            }
            Extent extent = new Extent(this.currentBytes, this.buffer.getSize());
            this.esu.updateObjectFromSegment(id, null, null, extent, this.buffer, null, this.checksum);
            this.progress(this.buffer.getSize());
        }
    }

    private void fail(Exception e) {
        this.failed = true;
        this.error = e;
        if (this.closeStream) {
            try {
                this.stream.close();
            }
            catch (IOException e1) {
                l4j.warn((Object)"Error closing stream", (Throwable)e1);
            }
        }
        for (ProgressListener pl : this.listeners) {
            pl.onError(e);
        }
    }

    private void complete() {
        this.complete = true;
        if (this.closeStream) {
            try {
                this.stream.close();
            }
            catch (IOException e) {
                l4j.warn((Object)"Error closing stream", (Throwable)e);
            }
        }
        for (ProgressListener pl : this.listeners) {
            pl.onComplete();
        }
    }

    private void progress(int size) {
        this.currentBytes += (long)size;
        for (ProgressListener pl : this.listeners) {
            pl.onProgress(this.currentBytes, this.totalBytes);
        }
    }

    private boolean readChunk() throws IOException {
        int read;
        int c;
        if (this.minReadSize == -1) {
            int c2 = this.stream.read(this.buffer.getBuffer());
            if (c2 == -1) {
                this.buffer.setSize(0);
                return true;
            }
            this.buffer.setSize(c2);
            return false;
        }
        for (read = 0; read < this.minReadSize; read += c) {
            c = this.stream.read(this.buffer.getBuffer(), read, this.buffer.getSize() - read);
            if (c != -1) continue;
            if (read > 0) {
                this.buffer.setSize(read);
                return false;
            }
            this.buffer.setSize(0);
            return true;
        }
        this.buffer.setSize(read);
        return false;
    }

    public void setMinReadSize(int minReadSize) {
        this.minReadSize = minReadSize;
    }

    public int getMinReadSize() {
        return this.minReadSize;
    }

    public boolean isChecksumming() {
        return this.checksumming;
    }

    public void setChecksumming(boolean checksumming) {
        this.checksumming = checksumming;
    }

    public void setMimeType(String mimeType) {
        this.mimeType = mimeType;
    }

    public String getMimeType() {
        return this.mimeType;
    }
}

