/*
 * Decompiled with CFR 0.152.
 */
package com.emc.esu.sysmgmt;

import com.emc.esu.api.EsuException;
import com.emc.esu.sysmgmt.SysMgmtApi;
import com.emc.esu.sysmgmt.SysMgmtResponse;
import com.emc.esu.sysmgmt.SysMgmtUtils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.concurrent.Callable;
import org.apache.log4j.Logger;
import org.jdom.Document;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;

public abstract class SysMgmtRequest<T extends SysMgmtResponse>
implements Callable<T> {
    private static final Logger l4j = Logger.getLogger(SysMgmtRequest.class);
    private static final String PROP_USERNAME = "x-atmos-systemadmin";
    private static final String PROP_PASSWORD = "x-atmos-systemadminpassword";
    private static final String PASSWORD_AUTH = "password";
    private static final String PROP_AUTHTYPE = "x-atmos-authtype";
    protected SysMgmtApi api;

    public SysMgmtRequest(SysMgmtApi api) {
        this.api = api;
    }

    protected HttpURLConnection getConnection(String path, String query) throws IOException, URISyntaxException {
        URI uri = new URI(this.api.getProto(), null, this.api.getHost(), this.api.getPort(), path, query, null);
        l4j.debug((Object)("URI: " + uri));
        URL u = new URL(uri.toASCIIString());
        l4j.debug((Object)("URL: " + u));
        HttpURLConnection con = (HttpURLConnection)u.openConnection();
        con.addRequestProperty(PROP_USERNAME, this.api.getUsername());
        con.addRequestProperty(PROP_PASSWORD, this.api.getPassword());
        con.addRequestProperty(PROP_AUTHTYPE, PASSWORD_AUTH);
        return con;
    }

    protected void handleError(HttpURLConnection con) throws IOException, JDOMException {
        int httpCode = con.getResponseCode();
        String msg = con.getResponseMessage();
        byte[] response = SysMgmtUtils.readResponse(con);
        l4j.debug((Object)("Error response: " + new String(response, "UTF-8")));
        SAXBuilder sb = new SAXBuilder();
        Document d = sb.build(new ByteArrayInputStream(response));
        String code = d.getRootElement().getChildText("Code");
        String message = d.getRootElement().getChildText("Message");
        if (code == null && message == null) {
            throw new EsuException(msg, httpCode);
        }
        l4j.debug((Object)("Error: " + code + " message: " + message));
        throw new EsuException(message, httpCode, Integer.parseInt(code));
    }
}

