/*
 * Decompiled with CFR 0.152.
 */
package com.emc.util;

import com.emc.util.StreamUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import org.apache.log4j.Logger;

public final class HttpUtil {
    private static final String HEADER_FORMAT = "EEE, d MMM yyyy HH:mm:ss z";
    private static final ThreadLocal<DateFormat> headerFormat = new ThreadLocal();
    private static final String ISO_8601_FORMAT = "yyyy-MM-dd'T'HH:mm:ss'Z'";
    private static final ThreadLocal<DateFormat> iso8601Format = new ThreadLocal();
    private static final Logger l4j = Logger.getLogger(HttpUtil.class);

    public static synchronized String headerFormat(Date date) {
        return HttpUtil.getHeaderFormat().format(date);
    }

    public static String encodeUtf8(String value) {
        try {
            return URLEncoder.encode(value, "UTF-8").replace("+", "%20");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("UTF-8 encoding isn't supported on this system", e);
        }
    }

    public static String decodeUtf8(String value) {
        try {
            return URLDecoder.decode(value.replace("+", "%2B"), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("UTF-8 encoding isn't supported on this system", e);
        }
    }

    public static String readResponseString(HttpURLConnection con) throws IOException {
        InputStream in = null;
        if (con.getResponseCode() > 299) {
            in = con.getErrorStream();
        }
        if (in == null) {
            in = con.getInputStream();
        }
        if (in == null) {
            return "";
        }
        return StreamUtil.readAsString(in);
    }

    public static byte[] readResponse(HttpURLConnection con) throws IOException {
        InputStream in = null;
        if (con.getResponseCode() > 299) {
            in = con.getErrorStream();
            if (in == null) {
                in = con.getInputStream();
            }
        } else {
            in = con.getInputStream();
        }
        if (in == null) {
            return new byte[0];
        }
        int contentLength = con.getContentLength();
        if (contentLength != -1) {
            return StreamUtil.readAsBytes(in, contentLength);
        }
        l4j.debug((Object)"Content length is unknown.  Buffering output.");
        byte[] data = StreamUtil.readAsBytes(in);
        l4j.debug((Object)("Buffered " + data.length + " response bytes"));
        return data;
    }

    public static void writeRequest(HttpURLConnection con, String content) throws IOException {
        con.setDoOutput(true);
        con.setFixedLengthStreamingMode(content.getBytes("UTF-8").length);
        con.connect();
        OutputStreamWriter writer = new OutputStreamWriter(con.getOutputStream());
        writer.write(content);
        writer.flush();
        writer.close();
    }

    private static DateFormat getHeaderFormat() {
        DateFormat format = headerFormat.get();
        if (format == null) {
            format = new SimpleDateFormat(HEADER_FORMAT, Locale.ENGLISH);
            format.setTimeZone(TimeZone.getTimeZone("UTC"));
            headerFormat.set(format);
        }
        return format;
    }

    public static DateFormat get8601Format() {
        DateFormat format = iso8601Format.get();
        if (format == null) {
            format = new SimpleDateFormat(ISO_8601_FORMAT);
            format.setTimeZone(TimeZone.getTimeZone("UTC"));
            iso8601Format.set(format);
        }
        return format;
    }
}

