/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.client.apache4;

import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientHandlerException;
import com.sun.jersey.api.client.config.ClientConfig;
import com.sun.jersey.api.client.config.DefaultClientConfig;
import com.sun.jersey.client.apache4.ApacheHttpClient4Handler;
import com.sun.jersey.core.spi.component.ioc.IoCComponentProviderFactory;
import java.net.URI;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.impl.client.BasicCookieStore;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.params.HttpParams;

public class ApacheHttpClient4
extends Client {
    private final ApacheHttpClient4Handler client4Handler;

    public ApacheHttpClient4() {
        this(ApacheHttpClient4.createDefaultClientHandler(null), (ClientConfig)new DefaultClientConfig(), null);
    }

    public ApacheHttpClient4(ApacheHttpClient4Handler root) {
        this(root, (ClientConfig)new DefaultClientConfig(), null);
    }

    public ApacheHttpClient4(ApacheHttpClient4Handler root, ClientConfig config) {
        this(root, config, null);
    }

    public ApacheHttpClient4(ApacheHttpClient4Handler root, ClientConfig config, IoCComponentProviderFactory provider) {
        super(root, config, provider);
        this.client4Handler = root;
    }

    public ApacheHttpClient4Handler getClientHandler() {
        return this.client4Handler;
    }

    public static ApacheHttpClient4 create() {
        return new ApacheHttpClient4(ApacheHttpClient4.createDefaultClientHandler(null));
    }

    public static ApacheHttpClient4 create(ClientConfig cc) {
        return new ApacheHttpClient4(ApacheHttpClient4.createDefaultClientHandler(cc), cc);
    }

    public static ApacheHttpClient4 create(ClientConfig cc, IoCComponentProviderFactory provider) {
        return new ApacheHttpClient4(ApacheHttpClient4.createDefaultClientHandler(cc), cc, provider);
    }

    private static ApacheHttpClient4Handler createDefaultClientHandler(ClientConfig cc) {
        Object connectionManager = null;
        Object httpParams = null;
        if (cc != null) {
            connectionManager = cc.getProperties().get("com.sun.jersey.impl.client.httpclient.connectionManager");
            if (connectionManager != null && !(connectionManager instanceof ClientConnectionManager)) {
                Logger.getLogger(ApacheHttpClient4.class.getName()).log(Level.WARNING, "Ignoring value of property com.sun.jersey.impl.client.httpclient.connectionManager (" + connectionManager.getClass().getName() + ") - not instance of org.apache.http.conn.ClientConnectionManager.");
                connectionManager = null;
            }
            if ((httpParams = cc.getProperties().get("com.sun.jersey.impl.client.httpclient.httpParams")) != null && !(httpParams instanceof HttpParams)) {
                Logger.getLogger(ApacheHttpClient4.class.getName()).log(Level.WARNING, "Ignoring value of property com.sun.jersey.impl.client.httpclient.httpParams (" + httpParams.getClass().getName() + ") - not instance of org.apache.http.params.HttpParams.");
                httpParams = null;
            }
        }
        DefaultHttpClient client = new DefaultHttpClient((ClientConnectionManager)connectionManager, (HttpParams)httpParams);
        BasicCookieStore cookieStore = null;
        boolean preemptiveBasicAuth = false;
        if (cc != null) {
            Object proxyUri;
            Object credentialsProvider;
            for (Map.Entry<String, Object> entry : cc.getProperties().entrySet()) {
                client.getParams().setParameter(entry.getKey(), entry.getValue());
            }
            if (cc.getPropertyAsFeature("com.sun.jersey.impl.client.httpclient.handleCookies")) {
                client.getParams().setParameter("http.protocol.cookie-policy", "ignoreCookies");
            }
            if ((credentialsProvider = cc.getProperty("com.sun.jersey.impl.client.httpclient.credentialsProvider")) != null && credentialsProvider instanceof CredentialsProvider) {
                client.setCredentialsProvider((CredentialsProvider)credentialsProvider);
            }
            if ((proxyUri = cc.getProperties().get("com.sun.jersey.impl.client.httpclient.proxyURI")) != null) {
                URI u = ApacheHttpClient4.getProxyUri(proxyUri);
                HttpHost proxy = new HttpHost(u.getHost(), u.getPort(), u.getScheme());
                if (cc.getProperties().containsKey("com.sun.jersey.impl.client.httpclient.proxyUsername") && cc.getProperties().containsKey("com.sun.jersey.impl.client.httpclient.proxyPassword")) {
                    client.getCredentialsProvider().setCredentials(new AuthScope(u.getHost(), u.getPort()), new UsernamePasswordCredentials(cc.getProperty("com.sun.jersey.impl.client.httpclient.proxyUsername").toString(), cc.getProperty("com.sun.jersey.impl.client.httpclient.proxyPassword").toString()));
                }
                client.getParams().setParameter("http.route.default-proxy", proxy);
            }
            preemptiveBasicAuth = cc.getPropertyAsFeature("com.sun.jersey.impl.client.httpclient.preemptiveBasicAuthentication");
        }
        if (client.getParams().getParameter("http.protocol.cookie-policy") == null || !client.getParams().getParameter("http.protocol.cookie-policy").equals("ignoreCookies")) {
            cookieStore = new BasicCookieStore();
            client.setCookieStore(cookieStore);
        }
        return new ApacheHttpClient4Handler(client, cookieStore, preemptiveBasicAuth);
    }

    private static URI getProxyUri(Object proxy) {
        if (proxy instanceof URI) {
            return (URI)proxy;
        }
        if (proxy instanceof String) {
            return URI.create((String)proxy);
        }
        throw new ClientHandlerException("The proxy URI (com.sun.jersey.impl.client.httpclient.proxyURI) property MUST be an instance of String or URI");
    }
}

