/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.atmos;

import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.atmos.AtmosComponent;
import org.apache.camel.component.atmos.AtmosConfiguration;
import org.apache.camel.component.atmos.integration.consumer.AtmosScheduledPollConsumer;
import org.apache.camel.component.atmos.integration.consumer.AtmosScheduledPollGetConsumer;
import org.apache.camel.component.atmos.integration.producer.AtmosDelProducer;
import org.apache.camel.component.atmos.integration.producer.AtmosGetProducer;
import org.apache.camel.component.atmos.integration.producer.AtmosMoveProducer;
import org.apache.camel.component.atmos.integration.producer.AtmosPutProducer;
import org.apache.camel.component.atmos.util.AtmosException;
import org.apache.camel.component.atmos.util.AtmosOperation;
import org.apache.camel.impl.DefaultEndpoint;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UriEndpoint(firstVersion="2.15.0", scheme="atmos", title="Atmos", syntax="atmos:name/operation", consumerClass=AtmosScheduledPollConsumer.class, label="file,cloud")
public class AtmosEndpoint
extends DefaultEndpoint {
    private static final transient Logger LOG = LoggerFactory.getLogger(AtmosEndpoint.class);
    @UriParam
    private AtmosConfiguration configuration;

    public AtmosEndpoint() {
    }

    public AtmosEndpoint(String uri, AtmosComponent component, AtmosConfiguration configuration) {
        super(uri, (Component)component);
        this.configuration = configuration;
    }

    public AtmosEndpoint(String endpointUri) {
        super(endpointUri);
    }

    public AtmosConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(AtmosConfiguration configuration) {
        this.configuration = configuration;
    }

    public Producer createProducer() throws Exception {
        LOG.debug("resolve producer atmos endpoint {" + this.configuration.getOperation().toString() + "}");
        LOG.debug("resolve producer atmos attached client: " + this.configuration.getClient());
        if (this.configuration.getOperation() == AtmosOperation.put) {
            return new AtmosPutProducer(this, this.configuration);
        }
        if (this.configuration.getOperation() == AtmosOperation.del) {
            return new AtmosDelProducer(this, this.configuration);
        }
        if (this.configuration.getOperation() == AtmosOperation.get) {
            return new AtmosGetProducer(this, this.configuration);
        }
        if (this.configuration.getOperation() == AtmosOperation.move) {
            return new AtmosMoveProducer(this, this.configuration);
        }
        throw new AtmosException("operation specified is not valid for producer!");
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        LOG.debug("resolve consumer atmos endpoint {" + this.configuration.getOperation().toString() + "}");
        LOG.debug("resolve consumer atmos attached client:" + this.configuration.getClient());
        if (this.configuration.getOperation() == AtmosOperation.get) {
            AtmosScheduledPollGetConsumer consumer = new AtmosScheduledPollGetConsumer(this, processor, this.configuration);
            consumer.setDelay(3600000L);
            return consumer;
        }
        throw new AtmosException("operation specified is not valid for consumer!");
    }

    public boolean isSingleton() {
        return true;
    }
}

