/*
 * Decompiled with CFR 0.152.
 */
package com.emc.acdp.util;

import com.emc.cdp.services.rest.model.ObjectFactory;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;

public class XmlUtil {
    private static JAXBContext jaxbContext;
    private static ThreadLocal<Marshaller> marshaller;
    private static ThreadLocal<Unmarshaller> unmarshaller;

    private XmlUtil() {
    }

    public static String marshal(Object bean) throws JAXBException {
        StringWriter writer = new StringWriter();
        XmlUtil.getMarshaller().marshal(bean, (Writer)writer);
        return writer.toString();
    }

    public static void marshal(Object bean, OutputStream os) throws JAXBException {
        XmlUtil.getMarshaller().marshal(bean, os);
    }

    public static <T> T unmarshal(Class<T> beanClass, String xml) throws JAXBException {
        StringReader reader = new StringReader(xml);
        return (T)XmlUtil.getUnmarshaller().unmarshal((Reader)reader);
    }

    public static <T> T unmarshal(Class<T> beanClass, InputStream is) throws JAXBException {
        return (T)XmlUtil.getUnmarshaller().unmarshal(is);
    }

    private static Marshaller getMarshaller() throws JAXBException {
        Marshaller m = marshaller.get();
        if (m == null) {
            m = jaxbContext.createMarshaller();
            marshaller.set(m);
        }
        return m;
    }

    private static Unmarshaller getUnmarshaller() throws JAXBException {
        Unmarshaller um = unmarshaller.get();
        if (um == null) {
            um = jaxbContext.createUnmarshaller();
            unmarshaller.set(um);
        }
        return um;
    }

    static {
        marshaller = new ThreadLocal();
        unmarshaller = new ThreadLocal();
        try {
            jaxbContext = JAXBContext.newInstance((String)"com.emc.cdp.services.rest.model", (ClassLoader)ObjectFactory.class.getClassLoader());
        }
        catch (JAXBException e) {
            throw new RuntimeException(e);
        }
    }
}

