/*
 * Decompiled with CFR 0.152.
 */
package com.emc.atmos;

import com.emc.atmos.LoadBalancingAlgorithm;
import com.emc.atmos.RoundRobinAlgorithm;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.log4j.Logger;

public class AbstractConfig {
    private static final Logger l4j = Logger.getLogger(AbstractConfig.class);
    protected String context;
    protected URI[] endpoints;
    protected boolean disableSslValidation = false;
    protected int resolveCount = 0;
    protected LoadBalancingAlgorithm loadBalancingAlgorithm = new RoundRobinAlgorithm();
    protected ThreadLocal<URI> threadEndpoint = new ThreadLocal();

    public AbstractConfig(String context, URI ... endpoints) {
        this.context = context;
        this.endpoints = endpoints;
    }

    public URI resolvePath(String relativePath, String query) {
        String path = relativePath;
        if (path.length() == 0 || path.charAt(0) != '/') {
            path = '/' + path;
        }
        if (!path.startsWith(this.context)) {
            path = this.context + path;
        }
        URI endpoint = this.loadBalancingAlgorithm.getNextEndpoint(this.endpoints);
        try {
            URI uri = new URI(endpoint.getScheme(), null, endpoint.getHost(), endpoint.getPort(), path, query, null);
            l4j.debug((Object)("raw path & query: " + path + "?" + query));
            l4j.debug((Object)("encoded URI: " + uri));
            return uri;
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("Invalid URI syntax", e);
        }
    }

    public String getContext() {
        return this.context;
    }

    public void setContext(String context) {
        this.context = context;
    }

    public boolean isDisableSslValidation() {
        return this.disableSslValidation;
    }

    public void setDisableSslValidation(boolean disableSslValidation) {
        this.disableSslValidation = disableSslValidation;
    }

    public URI[] getEndpoints() {
        return this.endpoints;
    }

    public void setEndpoints(URI[] endpoints) {
        this.endpoints = endpoints;
    }

    public LoadBalancingAlgorithm getLoadBalancingAlgorithm() {
        return this.loadBalancingAlgorithm;
    }

    public void setLoadBalancingAlgorithm(LoadBalancingAlgorithm loadBalancingAlgorithm) {
        this.loadBalancingAlgorithm = loadBalancingAlgorithm;
    }
}

