/*
 * Decompiled with CFR 0.152.
 */
package com.emc.atmos.api.request;

import com.emc.atmos.api.RestUtil;
import com.emc.atmos.api.request.ListRequest;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public abstract class ListMetadataRequest<T extends ListMetadataRequest<T>>
extends ListRequest<T> {
    protected List<String> userMetadataNames;
    protected List<String> systemMetadataNames;
    protected boolean includeMetadata;

    @Override
    public Map<String, List<Object>> generateHeaders() {
        Map<String, List<Object>> headers = super.generateHeaders();
        if (this.includeMetadata) {
            RestUtil.addValue(headers, "x-emc-include-meta", 1);
            if (this.userMetadataNames != null) {
                for (String name : this.userMetadataNames) {
                    RestUtil.addValue(headers, "x-emc-user-tags", name);
                }
            }
            if (this.systemMetadataNames != null) {
                for (String name : this.systemMetadataNames) {
                    RestUtil.addValue(headers, "x-emc-system-tags", name);
                }
            }
        }
        return headers;
    }

    public T userMetadataNames(String ... userMetadataNames) {
        if (userMetadataNames == null || userMetadataNames.length == 1 && userMetadataNames[0] == null) {
            userMetadataNames = new String[]{};
        }
        this.setUserMetadataNames(Arrays.asList(userMetadataNames));
        return (T)((ListMetadataRequest)this.me());
    }

    public T systemMetadataNames(String ... systemMetadataNames) {
        if (systemMetadataNames == null || systemMetadataNames.length == 1 && systemMetadataNames[0] == null) {
            systemMetadataNames = new String[]{};
        }
        this.setSystemMetadataNames(Arrays.asList(systemMetadataNames));
        return (T)((ListMetadataRequest)this.me());
    }

    public T includeMetadata(boolean includeMetadata) {
        this.setIncludeMetadata(includeMetadata);
        return (T)((ListMetadataRequest)this.me());
    }

    public List<String> getUserMetadataNames() {
        return this.userMetadataNames;
    }

    public List<String> getSystemMetadataNames() {
        return this.systemMetadataNames;
    }

    public boolean isIncludeMetadata() {
        return this.includeMetadata;
    }

    public void setUserMetadataNames(List<String> userMetadataNames) {
        this.userMetadataNames = userMetadataNames;
    }

    public void setSystemMetadataNames(List<String> systemMetadataNames) {
        this.systemMetadataNames = systemMetadataNames;
    }

    public void setIncludeMetadata(boolean includeMetadata) {
        this.includeMetadata = includeMetadata;
    }
}

