/*
 * Decompiled with CFR 0.152.
 */
package com.emc.esu.api.rest;

import com.emc.esu.api.BufferSegment;
import com.emc.esu.api.Checksum;
import com.emc.esu.api.EsuApi;
import com.emc.esu.api.EsuException;
import com.emc.esu.api.Extent;
import com.emc.esu.api.Identifier;
import com.emc.esu.api.MetadataList;
import com.emc.esu.api.ProgressListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class DownloadHelper {
    private static final Logger l4j = Logger.getLogger(DownloadHelper.class);
    private static final int DEFAULT_BUFFSIZE = 0x400000;
    private EsuApi esu;
    private BufferSegment buffer;
    private long currentBytes;
    private long totalBytes;
    private boolean complete;
    private boolean failed;
    private Exception error;
    private boolean closeStream;
    private OutputStream stream;
    private List<ProgressListener> listeners;
    private boolean checksumming;
    private Checksum checksum;

    public DownloadHelper(EsuApi esuApi, byte[] buffer) {
        this.esu = esuApi;
        this.buffer = new BufferSegment(buffer == null ? new byte[0x400000] : buffer);
        this.listeners = new ArrayList<ProgressListener>();
    }

    public void readObject(Identifier id, File f) {
        FileOutputStream out;
        try {
            out = new FileOutputStream(f);
        }
        catch (FileNotFoundException e) {
            throw new EsuException("Error opening output file", e);
        }
        this.readObject(id, out, true);
    }

    public void readObject(Identifier id, OutputStream stream, boolean closeStream) {
        String size;
        this.currentBytes = 0L;
        this.complete = false;
        this.failed = false;
        this.error = null;
        this.closeStream = closeStream;
        this.stream = stream;
        MetadataList sMeta = this.esu.getAllMetadata(id).getMetadata();
        this.totalBytes = sMeta.getMetadata("size") != null ? ((size = sMeta.getMetadata("size").getValue()) != null && size.length() > 0 ? Long.parseLong(size) : -1L) : -1L;
        if (this.totalBytes == -1L) {
            throw new EsuException("Failed to get object size");
        }
        if (this.checksumming) {
            try {
                this.checksum = new Checksum(Checksum.Algorithm.SHA0);
            }
            catch (NoSuchAlgorithmException e) {
                throw new RuntimeException("Could not initialize SHA0 hash algorithm");
            }
        }
        try {
            do {
                Extent extent = null;
                extent = this.currentBytes + (long)this.buffer.getBuffer().length > this.totalBytes ? new Extent(this.currentBytes, this.totalBytes - this.currentBytes) : new Extent(this.currentBytes, this.buffer.getBuffer().length);
                this.buffer.setSize((int)extent.getSize());
                byte[] obuffer = this.esu.readObject(id, extent, this.buffer.getBuffer(), this.checksum);
                if (obuffer != this.buffer.getBuffer()) {
                    if ((long)obuffer.length != extent.getSize()) {
                        throw new EsuException("Read size mismatch.  Requested " + extent.getSize() + " bytes but received " + obuffer.length + " bytes");
                    }
                    stream.write(obuffer, 0, obuffer.length);
                } else {
                    stream.write(this.buffer.getBuffer(), this.buffer.getOffset(), this.buffer.getSize());
                }
                this.progress(this.buffer.getSize());
            } while (this.currentBytes != this.totalBytes);
            if (this.checksumming && this.checksum.getExpectedValue() != null) {
                if (!this.checksum.getExpectedValue().equals(this.checksum.toString())) {
                    throw new EsuException("Checksum validation error.  Expected " + this.checksum.getExpectedValue() + " but computed " + this.checksum.toString());
                }
                l4j.info((Object)("Checksum OK: " + this.checksum.getExpectedValue()));
            }
            this.complete();
            return;
        }
        catch (EsuException e) {
            this.fail(e);
            throw e;
        }
        catch (IOException e) {
            this.fail(e);
            throw new EsuException("Error downloading file", e);
        }
    }

    public long getCurrentBytes() {
        return this.currentBytes;
    }

    public long getTotalBytes() {
        return this.totalBytes;
    }

    public boolean isComplete() {
        return this.complete;
    }

    public boolean isFailed() {
        return this.failed;
    }

    public Exception getError() {
        return this.error;
    }

    public void addListener(ProgressListener listener) {
        this.listeners.add(listener);
    }

    private void progress(long bytes) {
        this.currentBytes += bytes;
        for (ProgressListener pl : this.listeners) {
            pl.onProgress(this.currentBytes, this.totalBytes);
        }
    }

    private void complete() {
        this.complete = true;
        if (this.closeStream) {
            try {
                this.stream.close();
            }
            catch (IOException e) {
                l4j.warn((Object)"Error closing output stream", (Throwable)e);
            }
        }
        for (ProgressListener pl : this.listeners) {
            pl.onComplete();
        }
    }

    private void fail(Exception e) {
        this.failed = true;
        this.error = e;
        for (ProgressListener pl : this.listeners) {
            pl.onError(e);
        }
    }

    public void setChecksumming(boolean checksumming) {
        this.checksumming = checksumming;
    }

    public boolean isChecksumming() {
        return this.checksumming;
    }
}

