/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.atmos;

import com.emc.atmos.api.AtmosApi;
import com.emc.atmos.api.AtmosConfig;
import com.emc.atmos.api.jersey.AtmosApiClient;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.camel.component.atmos.util.AtmosException;
import org.apache.camel.component.atmos.util.AtmosOperation;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriParams;
import org.apache.camel.spi.UriPath;

@UriParams
public class AtmosConfiguration {
    private AtmosApi client;
    @UriPath
    private String name;
    @UriPath
    @Metadata(required="true")
    private AtmosOperation operation;
    @UriParam
    private String secretKey;
    @UriParam
    private String localPath;
    @UriParam
    private String remotePath;
    @UriParam
    private String newRemotePath;
    @UriParam
    private String query;
    @UriParam
    private String fullTokenId;
    @UriParam
    private String uri;
    @UriParam
    private boolean enableSslValidation;

    public void setClient(AtmosApi client) {
        this.client = client;
    }

    public AtmosApi getClient() {
        return this.client;
    }

    public void createClient() throws AtmosException {
        AtmosConfig config = null;
        try {
            config = new AtmosConfig(this.fullTokenId, this.secretKey, new URI(this.uri));
        }
        catch (URISyntaxException use) {
            throw new AtmosException("wrong syntax for Atmos URI!", use);
        }
        if (!this.enableSslValidation) {
            config.setDisableSslValidation(true);
        }
        AtmosApiClient atmosclient = new AtmosApiClient(config);
        this.client = atmosclient;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getSecretKey() {
        return this.secretKey;
    }

    public void setSecretKey(String secretKey) {
        this.secretKey = secretKey;
    }

    public String getLocalPath() {
        return this.localPath;
    }

    public void setLocalPath(String localPath) {
        this.localPath = localPath;
    }

    public String getRemotePath() {
        return this.remotePath;
    }

    public void setRemotePath(String remotePath) {
        this.remotePath = remotePath;
    }

    public String getNewRemotePath() {
        return this.newRemotePath;
    }

    public void setNewRemotePath(String newRemotePath) {
        this.newRemotePath = newRemotePath;
    }

    public String getQuery() {
        return this.query;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    public String getFullTokenId() {
        return this.fullTokenId;
    }

    public void setFullTokenId(String fullTokenId) {
        this.fullTokenId = fullTokenId;
    }

    public AtmosOperation getOperation() {
        return this.operation;
    }

    public void setOperation(AtmosOperation operation) {
        this.operation = operation;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    public String getUri() {
        return this.uri;
    }

    public boolean isEnableSslValidation() {
        return this.enableSslValidation;
    }

    public void setEnableSslValidation(boolean enableSslValidation) {
        this.enableSslValidation = enableSslValidation;
    }
}

