/*
 * Decompiled with CFR 0.152.
 */
package com.emc.acdp.api.jersey;

import com.emc.acdp.AcdpException;
import com.emc.acdp.api.AcdpAdminApi;
import com.emc.acdp.api.AcdpAdminConfig;
import com.emc.acdp.api.jersey.JerseyUtil;
import com.emc.cdp.services.rest.model.Account;
import com.emc.cdp.services.rest.model.AccountList;
import com.emc.cdp.services.rest.model.Assignee;
import com.emc.cdp.services.rest.model.AssigneeList;
import com.emc.cdp.services.rest.model.Identity;
import com.emc.cdp.services.rest.model.IdentityList;
import com.emc.cdp.services.rest.model.LifecycleEvent;
import com.emc.cdp.services.rest.model.LifecycleEventType;
import com.emc.cdp.services.rest.model.LifecycleTargetType;
import com.emc.cdp.services.rest.model.MeteringUsageList;
import com.emc.cdp.services.rest.model.Profile;
import com.emc.cdp.services.rest.model.Subscription;
import com.emc.cdp.services.rest.model.SubscriptionList;
import com.emc.cdp.services.rest.model.Subtenant;
import com.emc.cdp.services.rest.model.Token;
import com.emc.cdp.services.rest.model.TokenGroupList;
import com.emc.cdp.services.rest.model.TokenList;
import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.core.util.MultivaluedMapImpl;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;

public class AcdpAdminApiClient
implements AcdpAdminApi {
    private static final String DATE_FORMAT = "yyyy-MM-dd";
    private static final ThreadLocal<DateFormat> dateFormat = new ThreadLocal();
    private AcdpAdminConfig config;
    private Client client;
    private WebResource adminResource;

    public AcdpAdminApiClient(AcdpAdminConfig config) {
        this.config = config;
        this.client = JerseyUtil.createClient(config);
    }

    public AcdpAdminApiClient(AcdpAdminConfig config, Client client) {
        this.config = config;
        JerseyUtil.configureClient(client, config);
        this.client = client;
    }

    @Override
    public String createAccount(Account acct) {
        ClientResponse response = this.getAdminResource().path("accounts").type("text/xml").post(ClientResponse.class, (Object)acct);
        String location = response.getLocation().toString();
        if (location == null) {
            throw new AcdpException("Location missing from create account response");
        }
        return location.substring(location.lastIndexOf("/") + 1);
    }

    @Override
    public void deleteAccount(String accountId) {
        this.getAdminResource().path("accounts/" + accountId).delete();
    }

    @Override
    public AccountList listAccounts(boolean includeSubscription) {
        return this.listAccounts(includeSubscription, 1, 1000);
    }

    @Override
    public AccountList listAccounts(boolean includeSubscription, int start, int count) {
        WebResource resource = this.getAdminResource().path("accounts");
        if (includeSubscription) {
            resource = resource.queryParam("with_subscriptions", "true");
        }
        if (start > -1) {
            resource = resource.queryParam("start", "" + start);
        }
        if (count > -1) {
            resource = resource.queryParam("count", "" + count);
        }
        return resource.get(AccountList.class);
    }

    @Override
    public IdentityList listIdentities(boolean listAllAccounts, boolean includeProfile) {
        return this.listIdentities(listAllAccounts, includeProfile, 1, 1000);
    }

    @Override
    public IdentityList listIdentities(boolean listAllAccounts, boolean includeProfile, int start, int count) {
        WebResource resource = this.getAdminResource().path("identities");
        if (listAllAccounts) {
            resource = resource.queryParam("show_all_identities", "true");
        }
        if (includeProfile) {
            resource = resource.queryParam("show_profile", "true");
        }
        if (start > -1) {
            resource = resource.queryParam("start", "" + start);
        }
        if (count > -1) {
            resource = resource.queryParam("count", "" + count);
        }
        return resource.get(IdentityList.class);
    }

    @Override
    public Identity getIdentity(String id) {
        return this.getAdminResource().path("identities/" + id).get(Identity.class);
    }

    @Override
    public String createAccountInvitation(String accountId, String email, String accountRole) {
        MultivaluedMapImpl params = new MultivaluedMapImpl();
        params.putSingle("email", email);
        params.putSingle("account_role", accountRole);
        ClientResponse response = this.getAdminResource().path("accounts/" + accountId + "/invitations").type("application/x-www-form-urlencoded").post(ClientResponse.class, (Object)params);
        String location = response.getLocation().toString();
        if (location == null) {
            throw new AcdpException("Location missing from create account invitation response");
        }
        return location.substring(location.lastIndexOf("/") + 1);
    }

    @Override
    public String createSubscription(String accountId, String serviceId) {
        Subscription subscription = new Subscription();
        subscription.setServiceId(serviceId);
        ClientResponse response = this.getAdminResource().path("accounts/" + accountId + "/subscriptions").type("text/xml").post(ClientResponse.class, (Object)subscription);
        String location = response.getLocation().toString();
        if (location == null) {
            throw new AcdpException("Location missing from create subscription response");
        }
        return location.substring(location.lastIndexOf("/") + 1);
    }

    @Override
    public void provisionSubscription(String accountId, String subscriptionId, boolean sendEmail) {
        MultivaluedMapImpl params = new MultivaluedMapImpl();
        params.putSingle("send_email", Boolean.toString(sendEmail));
        this.getAdminResource().path("accounts/" + accountId + "/storage/" + subscriptionId).type("application/x-www-form-urlencoded").post(params);
    }

    @Override
    public Account getIdentityAccount(String identityId, boolean includeSubscription) {
        WebResource resource = this.getAdminResource().path("identities/" + identityId + "/account");
        if (includeSubscription) {
            resource = resource.queryParam("with_subscriptions", "true");
        }
        return resource.get(Account.class);
    }

    @Override
    public SubscriptionList getAccountSubscriptions(String accountId) {
        return this.getAdminResource().path("accounts/" + accountId + "/subscriptions").get(SubscriptionList.class);
    }

    @Override
    public Subtenant getSubtenant(String accountId, String subscriptionId) {
        return this.getAdminResource().path("accounts/" + accountId + "/storage/" + subscriptionId + "/subtenant").get(Subtenant.class);
    }

    @Override
    public void adminAccountEvent(String accountId, LifecycleEventType eventType) {
        LifecycleEvent lifecycleEvent = new LifecycleEvent();
        lifecycleEvent.setTargetId(accountId);
        lifecycleEvent.setTargetType(LifecycleTargetType.ACCOUNT);
        lifecycleEvent.setEventType(eventType);
        this.getAdminResource().path("events").type("text/xml").post(lifecycleEvent);
    }

    @Override
    public void deleteIdentity(String identityId) {
        this.getAdminResource().path("identities/" + identityId).delete();
    }

    @Override
    public void addAccountAssignee(String accountId, String identityId, String password, String firstName, String lastName, String email, String role) {
        MultivaluedMapImpl params = new MultivaluedMapImpl();
        params.putSingle("account_role", role);
        params.putSingle("password", password);
        params.putSingle("firstName", firstName);
        params.putSingle("lastName", lastName);
        params.putSingle("email", email);
        this.getAdminResource().path("accounts/" + accountId + "/identities/" + identityId).type("application/x-www-form-urlencoded").put(params);
    }

    @Override
    public AssigneeList listAccountAssignees(String accountId, boolean includeProfile) {
        WebResource resource = this.getAdminResource().path("accounts/" + accountId + "/identities");
        if (includeProfile) {
            resource = resource.queryParam("show_profile", "true");
        }
        return resource.get(AssigneeList.class);
    }

    @Override
    public Assignee getAccountAssignee(String accountId, String identityId, boolean includeProfile) {
        WebResource resource = this.getAdminResource().path("accounts/" + accountId + "/identities/" + identityId);
        if (includeProfile) {
            resource = resource.queryParam("show_profile", "true");
        }
        return resource.get(Assignee.class);
    }

    @Override
    public void editAccountAssignee(String accountId, String identityId, String newRole) {
        MultivaluedMapImpl params = new MultivaluedMapImpl();
        params.putSingle("account_role", newRole);
        this.getAdminResource().path("accounts/" + accountId + "/identities/" + identityId).type("application/x-www-form-urlencoded").post(params);
    }

    @Override
    public void RemoveAccountAssignee(String accountId, String identityId) {
        this.getAdminResource().path("accounts/" + accountId + "/identities/" + identityId).delete();
    }

    @Override
    public void updateIdentityProfile(String identityId, Profile profile) {
        this.getAdminResource().path("identities/" + identityId + "/profile").type("text/xml").put(profile);
    }

    @Override
    public Account getAccount(String accountId) {
        return this.getAdminResource().path("accounts/" + accountId).get(Account.class);
    }

    @Override
    public MeteringUsageList getSubscriptionUsage(String accountId, String subscriptionId, Date startDate, Date endDate, List<String> resources, String category) {
        return this.getSubscriptionUsage(accountId, subscriptionId, startDate, endDate, resources, category, 1, 1000);
    }

    @Override
    public MeteringUsageList getSubscriptionUsage(String accountId, String subscriptionId, Date startDate, Date endDate, List<String> resources, String category, int start, int count) {
        String resourceStr = "";
        for (String resource : resources) {
            resourceStr = resourceStr + resource + ",";
        }
        resourceStr = resourceStr.substring(0, resourceStr.length() - 1);
        MultivaluedMapImpl params = new MultivaluedMapImpl();
        params.putSingle("start_date", AcdpAdminApiClient.getFormat().format(startDate));
        params.putSingle("end_date", AcdpAdminApiClient.getFormat().format(endDate));
        params.putSingle("resources", resourceStr);
        params.putSingle("cat", category);
        if (start > -1) {
            params.putSingle("start", "" + start);
        }
        if (count > -1) {
            params.putSingle("count", "" + count);
        }
        return this.getAdminResource().path("accounts/" + accountId + "/storage/" + subscriptionId + "/usage").queryParams(params).get(MeteringUsageList.class);
    }

    @Override
    public void deleteSubscription(String accountId, String subscriptionId) {
        this.getAdminResource().path("accounts/" + accountId + "/subscriptions/" + subscriptionId).delete();
    }

    @Override
    public TokenGroupList listTokenGroups(String accountId, String subscriptionId) {
        return this.listTokenGroups(accountId, subscriptionId, 1, 1000);
    }

    @Override
    public TokenGroupList listTokenGroups(String accountId, String subscriptionId, int start, int count) {
        MultivaluedMapImpl params = new MultivaluedMapImpl();
        params.putSingle("start", "" + start);
        params.putSingle("count", "" + count);
        return this.getAdminResource().path("accounts/" + accountId + "/storage/" + subscriptionId + "/tokengroups").queryParams(params).get(TokenGroupList.class);
    }

    @Override
    public MeteringUsageList getTokenGroupUsage(String accountId, String subscriptionId, String tokenGroupId, Date startDate, Date endDate, List<String> resources, String category) {
        return this.getTokenGroupUsage(accountId, subscriptionId, tokenGroupId, startDate, endDate, resources, category, 1, 1000);
    }

    @Override
    public MeteringUsageList getTokenGroupUsage(String accountId, String subscriptionId, String tokenGroupId, Date startDate, Date endDate, List<String> resources, String category, int start, int count) {
        String resourceStr = "";
        for (String resource : resources) {
            resourceStr = resourceStr + resource + ",";
        }
        resourceStr = resourceStr.substring(0, resourceStr.length() - 1);
        MultivaluedMapImpl params = new MultivaluedMapImpl();
        params.putSingle("start_date", AcdpAdminApiClient.getFormat().format(startDate));
        params.putSingle("end_date", AcdpAdminApiClient.getFormat().format(endDate));
        params.putSingle("resources", resourceStr);
        params.putSingle("cat", category);
        if (start > -1) {
            params.putSingle("start", "" + start);
        }
        if (count > -1) {
            params.putSingle("count", "" + count);
        }
        return this.getAdminResource().path("accounts/" + accountId + "/storage/" + subscriptionId + "/tokengroups/" + tokenGroupId + "/usage").queryParams(params).get(MeteringUsageList.class);
    }

    @Override
    public TokenList listTokens(String accountId, String subscriptionId, String tokenGroupId) {
        return this.listTokens(accountId, subscriptionId, tokenGroupId, 1, 1000);
    }

    @Override
    public TokenList listTokens(String accountId, String subscriptionId, String tokenGroupId, int start, int count) {
        MultivaluedMapImpl params = new MultivaluedMapImpl();
        params.putSingle("start", "" + start);
        params.putSingle("count", "" + count);
        return this.getAdminResource().path("accounts/" + accountId + "/storage/" + subscriptionId + "/tokengroups/" + tokenGroupId + "/tokens").queryParams(params).get(TokenList.class);
    }

    @Override
    public Token getTokenInformation(String accountId, String subscriptionId, String tokenGroupId, String tokenId, boolean showFullInfo) {
        WebResource resource = this.getAdminResource().path("accounts/" + accountId + "/storage/" + subscriptionId + "/tokengroups/" + tokenGroupId + "/tokens/" + tokenId);
        if (showFullInfo) {
            resource = resource.queryParam("show_full_info", "true");
        }
        return resource.get(Token.class);
    }

    @Override
    public void unassignAccountIdentity(String accountId, String identityId) {
        this.getAdminResource().path("accounts/" + accountId + "/identities/" + identityId).delete();
    }

    private WebResource getAdminResource() {
        if (this.adminResource == null) {
            this.adminResource = this.client.resource(this.config.getBaseUri() + "/cdp-rest/v1/admin");
        }
        return this.adminResource;
    }

    private static DateFormat getFormat() {
        DateFormat format = dateFormat.get();
        if (format == null) {
            format = new SimpleDateFormat(DATE_FORMAT);
            format.setTimeZone(TimeZone.getTimeZone("UTC"));
            dateFormat.set(format);
        }
        return format;
    }
}

