/*
 * Decompiled with CFR 0.152.
 */
package com.emc.acdp.api.jersey;

import com.emc.acdp.AcdpConfig;
import com.emc.acdp.AcdpException;
import com.sun.jersey.api.client.ClientHandlerException;
import com.sun.jersey.api.client.ClientRequest;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.filter.ClientFilter;
import com.sun.jersey.core.util.MultivaluedMapImpl;
import java.net.URI;
import java.net.URISyntaxException;
import javax.ws.rs.core.MediaType;

public class AuthFilter
extends ClientFilter {
    private static final String PARAM_SESSION_TOKEN = "cdp_session";
    private static final String PARAM_USER_ID = "cdp-identity-id";
    private static final String PARAM_PASSWORD = "cdp-password";
    private AcdpConfig config;

    public AuthFilter(AcdpConfig config) {
        this.config = config;
    }

    @Override
    public ClientResponse handle(ClientRequest request) throws ClientHandlerException {
        ClientResponse response;
        if (!this.config.isSecureRequest(request.getURI().getPath(), request.getMethod())) {
            return this.getNext().handle(request);
        }
        if (this.config.getSessionToken() == null) {
            this.login(request);
        } else {
            this.attachSessionToken(request);
        }
        try {
            response = this.getNext().handle(request);
        }
        catch (AcdpException e) {
            if (e.getHttpCode() == 401) {
                this.login(request);
                response = this.getNext().handle(request);
            }
            throw e;
        }
        return response;
    }

    private void attachSessionToken(ClientRequest request) {
        String uriStr = request.getURI().toString();
        URI uri = request.getURI();
        uriStr = uri.getQuery() != null && uri.getQuery().length() > 0 ? uriStr + "&" : uriStr + "?";
        uriStr = uriStr + "cdp_session=" + this.config.getSessionToken();
        try {
            request.setURI(new URI(uriStr));
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    private void login(ClientRequest request) {
        String holdMethod = request.getMethod();
        URI holdUri = request.getURI();
        Object holdEntity = request.getEntity();
        Object holdType = request.getHeaders().getFirst("Content-Type");
        MultivaluedMapImpl params = new MultivaluedMapImpl();
        params.putSingle(PARAM_USER_ID, this.config.getUsername());
        params.putSingle(PARAM_PASSWORD, this.config.getPassword());
        request.setMethod("POST");
        request.setURI(request.getURI().resolve(this.config.getLoginPath()));
        request.setEntity(params);
        request.getHeaders().putSingle("Content-Type", MediaType.APPLICATION_FORM_URLENCODED_TYPE);
        ClientResponse response = this.getNext().handle(request);
        String token = response.getEntity(String.class);
        this.config.setSessionToken(token);
        request.setMethod(holdMethod);
        request.setURI(holdUri);
        request.setEntity(holdEntity);
        request.getHeaders().putSingle("Content-Type", holdType);
        this.attachSessionToken(request);
    }
}

