/*
 * Decompiled with CFR 0.152.
 */
package com.emc.acdp.api.jersey;

import com.emc.acdp.AcdpException;
import com.sun.jersey.api.client.ClientHandlerException;
import com.sun.jersey.api.client.ClientRequest;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.filter.ClientFilter;
import java.io.InputStreamReader;
import org.dom4j.Document;
import org.dom4j.io.SAXReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ErrorFilter
extends ClientFilter {
    private static final Logger log = LoggerFactory.getLogger(ErrorFilter.class);

    @Override
    public ClientResponse handle(ClientRequest clientRequest) throws ClientHandlerException {
        ClientResponse response = this.getNext().handle(clientRequest);
        if (response.getStatus() > 299) {
            Document d;
            SAXReader saxReader = new SAXReader();
            try {
                d = saxReader.read(new InputStreamReader(response.getEntityInputStream()));
            }
            catch (Exception e) {
                throw new AcdpException(response.getStatusInfo().getReasonPhrase(), response.getStatus());
            }
            String code = d.getRootElement().elementText("code");
            String message = d.getRootElement().elementText("message");
            if (code == null && message == null) {
                throw new AcdpException(response.getStatusInfo().getReasonPhrase(), response.getStatus());
            }
            log.debug("Error: " + code + " message: " + message);
            throw new AcdpException(message, response.getStatus(), code);
        }
        return response;
    }
}

