/*
 * Decompiled with CFR 0.152.
 */
package com.emc.atmos.api;

import com.emc.atmos.AbstractJerseyClient;
import com.emc.atmos.api.AtmosApi;
import com.emc.atmos.api.AtmosConfig;
import com.emc.atmos.api.ObjectId;
import com.emc.atmos.api.ObjectIdentifier;
import com.emc.atmos.api.ObjectKey;
import com.emc.atmos.api.Range;
import com.emc.atmos.api.RestUtil;
import com.emc.atmos.api.bean.GetAccessTokenResponse;
import com.emc.atmos.api.request.ContentRequest;
import com.emc.atmos.api.request.CreateObjectRequest;
import com.emc.atmos.api.request.PreSignedRequest;
import com.emc.atmos.api.request.ReadObjectRequest;
import com.emc.atmos.api.request.Request;
import com.emc.atmos.api.request.UpdateObjectRequest;
import com.emc.util.HttpUtil;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;

public abstract class AbstractAtmosApi
extends AbstractJerseyClient<AtmosConfig>
implements AtmosApi {
    public static final String DEFAULT_CONTENT_TYPE = "application/octet-stream";

    public AbstractAtmosApi(AtmosConfig config) {
        super(config);
    }

    @Override
    public ObjectId createObject(Object content, String contentType) {
        return this.createObject((CreateObjectRequest)((CreateObjectRequest)new CreateObjectRequest().content(content)).contentType(contentType)).getObjectId();
    }

    @Override
    public ObjectId createObject(ObjectIdentifier identifier, Object content, String contentType) {
        return this.createObject((CreateObjectRequest)((CreateObjectRequest)((CreateObjectRequest)new CreateObjectRequest().identifier(identifier)).content(content)).contentType(contentType)).getObjectId();
    }

    @Override
    public <T> T readObject(ObjectIdentifier identifier, Class<T> objectType) throws IOException {
        return this.readObject((ReadObjectRequest)new ReadObjectRequest().identifier(identifier), objectType).getObject();
    }

    @Override
    public <T> T readObject(ObjectIdentifier identifier, Range range, Class<T> objectType) throws IOException {
        return this.readObject(((ReadObjectRequest)new ReadObjectRequest().identifier(identifier)).ranges(range), objectType).getObject();
    }

    @Override
    public void updateObject(ObjectIdentifier identifier, Object content) {
        this.updateObject((UpdateObjectRequest)((UpdateObjectRequest)new UpdateObjectRequest().identifier(identifier)).content(content));
    }

    @Override
    public void updateObject(ObjectIdentifier identifier, Object content, Range range) {
        this.updateObject(((UpdateObjectRequest)((UpdateObjectRequest)new UpdateObjectRequest().identifier(identifier)).content(content)).range(range));
    }

    @Override
    public URL getShareableUrl(ObjectIdentifier identifier, Date expirationDate) throws MalformedURLException {
        return this.getShareableUrl(identifier, expirationDate, null);
    }

    @Override
    public URL getShareableUrl(ObjectIdentifier identifier, Date expirationDate, String disposition) throws MalformedURLException {
        if (identifier instanceof ObjectKey) {
            throw new IllegalArgumentException("You cannot create shareable URLs using a key; try using the object ID");
        }
        URI uri = ((AtmosConfig)this.config).resolveHostAndPath(identifier.getRelativeResourcePath(), null);
        String path = uri.getPath().toLowerCase();
        long expiresTime = expirationDate.getTime() / 1000L;
        String hashString = "GET\n" + path + '\n' + ((AtmosConfig)this.config).getTokenId() + '\n' + expiresTime;
        if (disposition != null) {
            hashString = hashString + '\n' + disposition;
        }
        String hash = RestUtil.sign(hashString, ((AtmosConfig)this.config).getSecretKey());
        String query = "uid=" + HttpUtil.encodeUtf8(((AtmosConfig)this.config).getTokenId()) + "&expires=" + expiresTime + "&signature=" + HttpUtil.encodeUtf8(hash);
        if (disposition != null) {
            query = query + "&disposition=" + HttpUtil.encodeUtf8(disposition);
        }
        return new URL(uri + "?" + query);
    }

    @Override
    public GetAccessTokenResponse getAccessToken(URL url) {
        return this.getAccessToken(RestUtil.lastPathElement(url.getPath()));
    }

    @Override
    public void deleteAccessToken(URL url) {
        this.deleteAccessToken(RestUtil.lastPathElement(url.getPath()));
    }

    @Override
    public PreSignedRequest preSignRequest(Request request, Date expiration) throws MalformedURLException {
        URI uri = ((AtmosConfig)this.config).resolveHostAndPath(request.getServiceRelativePath(), request.getQuery());
        Map<String, List<Object>> headers = request.generateHeaders(((AtmosConfig)this.config).isEncodeUtf8());
        String contentType = null;
        if (request instanceof ContentRequest) {
            contentType = ((ContentRequest)((Object)request)).getContentType();
        }
        if ("POST".equals(request.getMethod())) {
            contentType = DEFAULT_CONTENT_TYPE;
        }
        headers.put("x-emc-expires", Arrays.asList(expiration.getTime()));
        RestUtil.signRequest(request.getMethod(), uri.getPath(), uri.getQuery(), headers, ((AtmosConfig)this.config).getTokenId(), ((AtmosConfig)this.config).getSecretKey(), ((AtmosConfig)this.config).getServerClockSkew());
        return new PreSignedRequest(uri.toURL(), request.getMethod(), contentType, headers, expiration);
    }
}

