/*
 * Decompiled with CFR 0.152.
 */
package com.emc.atmos.api.bean.adapter;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.bind.annotation.adapters.XmlAdapter;

public class Iso8601Adapter
extends XmlAdapter<String, Date> {
    private static final String ISO_8601_FORMAT = "yyyy-MM-dd'T'HH:mm:ss'Z'";
    private static final ThreadLocal<DateFormat> iso8601Format = new ThreadLocal();

    @Override
    public Date unmarshal(String s) throws Exception {
        int hourOffset = 0;
        int minuteOffset = 0;
        String tzPattern = "([-+])(\\d{2}):?(\\d{2})?$";
        Matcher matcher = Pattern.compile(tzPattern).matcher(s);
        if (matcher.find()) {
            hourOffset = Integer.parseInt(matcher.group(2));
            if (matcher.group(3) != null) {
                minuteOffset = Integer.parseInt(matcher.group(3));
            }
            if ("+".equals(matcher.group(1))) {
                hourOffset *= -1;
                minuteOffset *= -1;
            }
            s = s.replaceAll(tzPattern, "") + "Z";
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(Iso8601Adapter.getFormat().parse(s));
        cal.add(11, hourOffset);
        cal.add(12, minuteOffset);
        return cal.getTime();
    }

    @Override
    public String marshal(Date date) throws Exception {
        return Iso8601Adapter.getFormat().format(date);
    }

    public static DateFormat getFormat() {
        DateFormat format = iso8601Format.get();
        if (format == null) {
            format = new SimpleDateFormat(ISO_8601_FORMAT);
            format.setTimeZone(TimeZone.getTimeZone("UTC"));
            iso8601Format.set(format);
        }
        return format;
    }
}

