/*
 * Decompiled with CFR 0.152.
 */
package com.emc.atmos.api.request;

import com.emc.atmos.api.Acl;
import com.emc.atmos.api.ChecksumAlgorithm;
import com.emc.atmos.api.ChecksumValue;
import com.emc.atmos.api.ObjectPath;
import com.emc.atmos.api.RestUtil;
import com.emc.atmos.api.bean.Metadata;
import com.emc.atmos.api.request.ContentRequest;
import com.emc.atmos.api.request.ObjectRequest;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public abstract class PutObjectRequest<T extends PutObjectRequest<T>>
extends ObjectRequest<T>
implements ContentRequest {
    protected Object content;
    protected long contentLength;
    protected String contentType;
    protected Acl acl;
    protected Map<String, Metadata> userMetadata = new TreeMap<String, Metadata>();
    protected Long retentionPeriod;
    protected String retentionPolicy;
    protected ChecksumValue wsChecksum;
    private ChecksumAlgorithm serverGeneratedChecksumAlgorithm;

    @Override
    public Map<String, List<Object>> generateHeaders(boolean encodeUtf8) {
        Map<String, List<Object>> headers = super.generateHeaders(encodeUtf8);
        if (!this.getUserMetadata().isEmpty() && encodeUtf8) {
            RestUtil.addValue(headers, "x-emc-utf8", "true");
        }
        for (Metadata metadata : this.getUserMetadata()) {
            if (metadata.isListable()) {
                RestUtil.addValue(headers, "x-emc-listable-meta", encodeUtf8 ? metadata.toASCIIString() : metadata.toString());
                continue;
            }
            RestUtil.addValue(headers, "x-emc-meta", encodeUtf8 ? metadata.toASCIIString() : metadata.toString());
        }
        if (this.acl != null) {
            headers.put("x-emc-useracl", this.acl.getUserAclHeader());
            headers.put("x-emc-groupacl", this.acl.getGroupAclHeader());
        }
        if (this.retentionPeriod != null) {
            RestUtil.addValue(headers, "x-emc-retention-period", this.retentionPeriod);
        }
        if (this.retentionPolicy != null) {
            RestUtil.addValue(headers, "x-emc-retention-policy", this.retentionPolicy);
        }
        if (this.wsChecksum != null) {
            RestUtil.addValue(headers, "x-emc-wschecksum", this.wsChecksum);
        }
        if (this.serverGeneratedChecksumAlgorithm != null) {
            RestUtil.addValue(headers, "x-emc-generate-checksum", (Object)this.serverGeneratedChecksumAlgorithm);
        }
        return headers;
    }

    @Override
    public boolean supports100Continue() {
        return !(this.getIdentifier() instanceof ObjectPath) || !((ObjectPath)this.getIdentifier()).isDirectory();
    }

    public T content(Object content) {
        this.setContent(content);
        return (T)((PutObjectRequest)this.me());
    }

    public T contentLength(long contentLength) {
        this.setContentLength(contentLength);
        return (T)((PutObjectRequest)this.me());
    }

    public T contentType(String contentType) {
        this.setContentType(contentType);
        return (T)((PutObjectRequest)this.me());
    }

    public T acl(Acl acl) {
        this.setAcl(acl);
        return (T)((PutObjectRequest)this.me());
    }

    public T userMetadata(Metadata ... userMetadata) {
        if (userMetadata == null || userMetadata.length == 1 && userMetadata[0] == null) {
            userMetadata = new Metadata[]{};
        }
        this.setUserMetadata(Arrays.asList(userMetadata));
        return (T)((PutObjectRequest)this.me());
    }

    public T retentionPeriod(Long retentionPeriod) {
        this.setRetentionPeriod(retentionPeriod);
        return (T)((PutObjectRequest)this.me());
    }

    public T retentionPolicy(String retentionPolicy) {
        this.setRetentionPolicy(retentionPolicy);
        return (T)((PutObjectRequest)this.me());
    }

    public T wsChecksum(ChecksumValue wsChecksum) {
        this.setWsChecksum(wsChecksum);
        return (T)((PutObjectRequest)this.me());
    }

    public T serverGeneratedChecksumAlgorithm(ChecksumAlgorithm serverGeneratedChecksumAlgorithm) {
        this.setServerGeneratedChecksumAlgorithm(serverGeneratedChecksumAlgorithm);
        return (T)((PutObjectRequest)this.me());
    }

    @Override
    public Object getContent() {
        return this.content;
    }

    @Override
    public long getContentLength() {
        return this.contentLength;
    }

    @Override
    public String getContentType() {
        return this.contentType;
    }

    public Acl getAcl() {
        return this.acl;
    }

    public Set<Metadata> getUserMetadata() {
        return new HashSet<Metadata>(this.userMetadata.values());
    }

    public Long getRetentionPeriod() {
        return this.retentionPeriod;
    }

    public String getRetentionPolicy() {
        return this.retentionPolicy;
    }

    public ChecksumValue getWsChecksum() {
        return this.wsChecksum;
    }

    public ChecksumAlgorithm getServerGeneratedChecksumAlgorithm() {
        return this.serverGeneratedChecksumAlgorithm;
    }

    public void setContent(Object content) {
        this.content = content;
    }

    public void setContentLength(long contentLength) {
        this.contentLength = contentLength;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public void setAcl(Acl acl) {
        this.acl = acl;
    }

    public void setUserMetadata(Collection<Metadata> userMetadata) {
        this.userMetadata.clear();
        for (Metadata metadata : userMetadata) {
            this.userMetadata.put(metadata.getName(), metadata);
        }
    }

    public void setRetentionPeriod(Long retentionPeriod) {
        this.retentionPeriod = retentionPeriod;
    }

    public void setRetentionPolicy(String retentionPolicy) {
        this.retentionPolicy = retentionPolicy;
    }

    public void setWsChecksum(ChecksumValue wsChecksum) {
        this.wsChecksum = wsChecksum;
    }

    public void setServerGeneratedChecksumAlgorithm(ChecksumAlgorithm serverGeneratedChecksumAlgorithm) {
        this.serverGeneratedChecksumAlgorithm = serverGeneratedChecksumAlgorithm;
    }
}

