/*
 * Decompiled with CFR 0.152.
 */
package com.emc.vipr.transform.compression;

import com.emc.vipr.transform.TransformConstants;
import com.emc.vipr.transform.compression.CompressionOutputTransform;
import com.emc.vipr.transform.compression.CompressionStream;
import com.emc.vipr.transform.compression.DeflateInputFilter;
import com.emc.vipr.transform.compression.DeflateOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;

public class DeflateOutputTransform
extends CompressionOutputTransform {
    public DeflateOutputTransform(OutputStream streamToEncode, Map<String, String> metadataToEncode, int compressionLevel) throws IOException {
        super(streamToEncode, metadataToEncode, "COMP:" + (Object)((Object)TransformConstants.CompressionMode.Deflate) + "/" + compressionLevel);
        if (compressionLevel > 9 || compressionLevel < 0) {
            throw new IllegalArgumentException("Invalid Deflate compression level: " + compressionLevel);
        }
        this.pushStream = new DeflateOutputStream(streamToEncode, compressionLevel);
    }

    public DeflateOutputTransform(InputStream streamToEncode, Map<String, String> metadataToEncode, int compressionLevel) throws IOException {
        super(streamToEncode, metadataToEncode, "COMP:" + (Object)((Object)TransformConstants.CompressionMode.Deflate) + "/" + compressionLevel);
        if (compressionLevel > 9 || compressionLevel < 0) {
            throw new IllegalArgumentException("Invalid Deflate compression level: " + compressionLevel);
        }
        this.pullStream = new DeflateInputFilter(streamToEncode, compressionLevel);
    }

    @Override
    public Map<String, String> getEncodedMetadata() {
        HashMap<String, String> metadata = new HashMap<String, String>();
        switch (this.getStreamMode()) {
            case PULL: {
                metadata.putAll(((CompressionStream)((Object)this.pullStream)).getStreamMetadata());
                break;
            }
            case PUSH: {
                metadata.putAll(((CompressionStream)((Object)this.pushStream)).getStreamMetadata());
            }
        }
        metadata.putAll(this.metadataToEncode);
        return metadata;
    }
}

